/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                   Author :  Paul Taylor                               */
/*                   Date   :  June 1995                                 */
/*-----------------------------------------------------------------------*/
/*              Stream_Items, content info for items                     */
/*                                                                       */
/*=======================================================================*/

#include <stdlib.h>
#include <stdio.h>
#include <fstream.h>
#include "ling_class/EST_Stream_Item.h"

// Users may change the address of a stream_item but they are
// assigned an addr unique for this session
static int general_stream_item_addr = 1;

void EST_Stream_Item::copy(const EST_Stream_Item &x)
{
    n = x.n;
    p = x.p;
    a = x.a;
    p_name = x.p_name;
    p_stream_name = x.p_stream_name;
    f = x.f;
    // can't do this in general
    // relations = x.relations;

}

EST_Stream_Item::~EST_Stream_Item()
{
}

float EST_Stream_Item::start() const
{
    return (p == 0) ? 0.0 : p->end();
}

float EST_Stream_Item::mid() const
{
    return end() - (dur() / 2.0);
}

float EST_Stream_Item::dur() const
{
    return end() - start();
}

void EST_Stream_Item::init(const EST_String &s)
{
    n = 0;
    p = 0;
    a = general_stream_item_addr++;
    p_stream_name = s;
}	

EST_Stream_Item &EST_Stream_Item::operator=(const EST_Stream_Item &x)
{
    copy(x);
    return *this;
}

ostream& operator << (ostream &s, const EST_Stream_Item &a)
{
    s.precision(3);
    s.width(4);
    s.setf(ios::left,ios::adjustfield);
    s << a.name();

    s.setf(ios::left,ios::adjustfield);

    s << a.f;

    // Can't decide when this should happen
//    for (EST_TBI *fptr=a.f.list.head(); fptr != 0; fptr=next(fptr))
//	s << " " << a.f.list(fptr).k <<
//	    " " << quote_string(a.f.list(fptr).v.string());

    return s;
}

    


