
#include <stdio.h>
#include "jni_Wave.h"
#include "EST_Wave.h"
#include "EST_wave_aux.h"
#include "EST_play_audio.h"

static jobject wave_class;
static jfieldID handle_field;

static inline short abs(short s) { return s>=0?s:-s; }

JNIEXPORT jboolean JNICALL
Java_cstr_est_cpp_Wave_initialise_1cpp (JNIEnv *env, jclass myclass)
{
  wave_class = env->NewGlobalRef(myclass);
  handle_field = env->GetFieldID(myclass, "cpp_handle", "J");

  if (!handle_field)
    {
    printf("can't find cpp_handle!\n");
    return 0;
    }

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Wave_finalise_1cpp (JNIEnv *env, jclass myclass)
{
  (void)env;
  (void)myclass;
  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Wave_create_1cpp_1wave(JNIEnv *env, jobject self)
{
  EST_Wave *wave = new EST_Wave;

  // printf("create wave %x\n", wave);

  env->SetLongField(self, handle_field, (jlong)wave);

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Wave_destroy_1cpp_1wave (JNIEnv *env, jobject self)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);

  // printf("destroy wave  %x\n", wave);

  delete wave;
  return 1;
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Wave_cpp_1name (JNIEnv *env, jobject self)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);

  return  env->NewStringUTF(wave->name());
}

JNIEXPORT void JNICALL 
Java_cstr_est_cpp_Wave_cpp_1setName (JNIEnv *env, jobject self, jstring jname)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);
  const char *name=env->GetStringUTFChars(jname, 0);

  fprintf(stderr, "Set Name '%s'\n", name);

  wave->set_name(name);

  fprintf(stderr, "Set Name '%s' done\n", name);

  env->ReleaseStringUTFChars(jname, name);

  fprintf(stderr, "Set Name '%s' return\n", name);
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Wave_cpp_1load (JNIEnv *env, jobject self, jstring jfilename)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);

  const char *filename = env->GetStringUTFChars(jfilename, 0);
  const char *res = "";

  EST_read_status stat = wave->load(filename);

  env->ReleaseStringUTFChars(jfilename, filename);

  if (stat == read_format_error)
    res = "wave format error";
  else if (stat == read_error) 
    res = "wave load error";
  
  return  env->NewStringUTF(res);
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Wave_cpp_1save (JNIEnv *env, jobject self, jstring jfilename, jstring jformat)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);

  const char *filename = env->GetStringUTFChars(jfilename, 0);
  const char *format = env->GetStringUTFChars(jformat, 0);
  const char *res = "";

  EST_write_status stat = wave->save(filename, format);

  env->ReleaseStringUTFChars(jfilename, filename);
  env->ReleaseStringUTFChars(jformat, format);

  if (stat == write_error) 
    res = "wave save error";
  
  return  env->NewStringUTF(res);
}

JNIEXPORT void JNICALL 
Java_cstr_est_cpp_Wave_cpp_1resample (JNIEnv *env, jobject self, jint rate)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);

  wave->resample(rate);
}

JNIEXPORT void JNICALL 
Java_cstr_est_cpp_Wave_cpp_1play (JNIEnv *env, jobject self, 
				  jfloat start_t, jfloat end_t)
{
   EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);
   EST_Wave wv;
   EST_Option op;

   int start = (int)(start_t * wave->sample_rate() + 0.5);
   int end = (int)(end_t * wave->sample_rate() + 0.5);

   wave_subwave(wv, *wave, start, end-start);
   // EST_write_status st = wv.save("/tmp/est_java_wave", "nist");
   
   play_wave(wv, op);
}

JNIEXPORT void JNICALL 
Java_cstr_est_cpp_Wave_cpp_1play_1all (JNIEnv *env, jobject self)
{
   EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);
   EST_Option op;

   play_wave(*wave, op);
}

JNIEXPORT jint JNICALL 
Java_cstr_est_cpp_Wave_cpp_1num_1channels(JNIEnv *env, jobject self)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);

  return wave->num_channels();
}

JNIEXPORT jint JNICALL 
Java_cstr_est_cpp_Wave_cpp_1num_1samples(JNIEnv *env, jobject self)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);

  return wave->num_samples();
}

JNIEXPORT jint JNICALL 
Java_cstr_est_cpp_Wave_cpp_1sample_1rate(JNIEnv *env, jobject self)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);

  return wave->sample_rate();
}

JNIEXPORT jint JNICALL 
Java_cstr_est_cpp_Wave_cpp_1amplitude(JNIEnv *env, jobject self,
				      jint c)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);
  short a=0;

  for(int i=0; i<wave->num_samples(); i++)
    {
      short p = wave->a(i,c);
      if (abs(p) > a)
	a=abs(p);
    }

  return a;
}

JNIEXPORT void JNICALL
Java_cstr_est_cpp_Wave_cpp_1getScanlines(JNIEnv *env, jobject self, 
					 jint c,
					 jbyteArray line, 
					 jint lstart, jint lnum,
					 jint xoff, jint chunk,
					 jint width, jint height, 
					 jint amp)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);
  jbyte *pixels = env->GetByteArrayElements(line, 0);
  int num_samples = wave->num_samples();
  short *data = wave->values().memory();
  int channels = wave->num_channels();

  for(int l=lstart; l<lstart+lnum; l++)
    {
      int min = (int)((float)(height - l)*amp*2.0/height-amp+0.5);
      int max = (int)((float)(height - l+1)*amp*2.0/height-amp+0.5);

      jbyte *lpixels = pixels + (l-lstart)*chunk;

      short la=0;
      int from=(int)((float)xoff*num_samples/width+0.5);

      for(int i=xoff; i<xoff+chunk; i++)
	{
	  int fl=0;
	  int to = (int)((i+1.0)*num_samples/width+0.5);
	  for(int j=from; j<to; j++)
	    {
	      short a = data[j*channels + c];
	      if ((a>min && la <=max)|| (la > min && a <=max))
		fl++;
	      la=a;
	    }
	  lpixels[i-xoff] = fl<5?fl:4;
	  from=to;
	}
    }
}

JNIEXPORT jint JNICALL
Java_cstr_est_cpp_Wave_cpp_1getMin(JNIEnv *env, jobject self, 
				   jint c, jint x1, jint x2)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);
  int minv=64000;

  if (x1<0) x1 = 0;
  if (x2>wave->num_samples()) x2 =  wave->num_samples();

  for(int x=x1; x<x2; x++)
    {
      short v = wave->a(x,c);
      if (v<minv)
	minv=v;
    }
  return minv;
}

JNIEXPORT jint JNICALL
Java_cstr_est_cpp_Wave_cpp_1getMax(JNIEnv *env, jobject self, 
				   jint c, jint x1, jint x2)
{
  EST_Wave *wave = (EST_Wave *) env->GetLongField(self, handle_field);
  int maxv=-64000;

  if (x1<0) x1 = 0;
  if (x2>wave->num_samples()) x2 =  wave->num_samples();

  for(int x=x1; x<x2; x++)
    {
      short v = wave->a(x, c);
      if (v>maxv)
	maxv=v;
    }
  return maxv;
}
