
 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/


#ifndef __EST_TLIST_I_H__
#define __EST_TLIST_I_H__

/** Instantiate rules for list template.
  * 
  * @author Richard Caley <rjc@cstr.ed.ac.uk>
  * @version $Id: EST_TListI.h,v 1.1 1998/08/12 09:29:25 awb Exp $
  */


// Instantiation Macros

#include <iostream.h>

#define Instantiate_TList_T(TYPE, TAG) \
	template class EST_TList< TYPE >; \
	template class EST_TItem< TYPE >; \
	\
	ostream& operator << (ostream &st, EST_TList< TYPE > const &list) { EST_Litem *ptr; for (ptr = list.head(); ptr != 0; ptr = next(ptr)) st << list.item(ptr) << " "; return st;}


#define Instantiate_TList(TYPE) Instantiate_TList_T(TYPE, TYPE)

#define Declare_TList_T(TYPE,TAG)

#define Declare_TList_Base_T(TYPE,DEFAULT,ERROR,TAG)

#define Declare_TList_Class_T(TYPE,DEFAULT,ERROR,TAG)

#define Declare_TList(TYPE) Declare_TList_T(TYPE,TYPE)

#define Declare_TList_Base(TYPE,DEFAULT,ERROR)  Declare_TList_Base_T(TYPE,DEFAULT,ERROR,TYPE)
#define Declare_TList_Class(TYPE,DEFAULT,ERROR) Declare_TList_Class_T(TYPE,DEFAULT,ERROR,TYPE)

#endif

