 /*************************************************************************/
 /*                                                                       */
 /*                Centre for Speech Technology Research                  */
 /*                     University of Edinburgh, UK                       */
 /*                      Copyright (c) 1995,1996                          */
 /*                        All Rights Reserved.                           */
 /*                                                                       */
 /*  Permission to use, copy, modify, distribute this software and its    */
 /*  documentation for research, educational and individual use only, is  */
 /*  hereby granted without fee, subject to the following conditions:     */
 /*   1. The code must retain the above copyright notice, this list of    */
 /*      conditions and the following disclaimer.                         */
 /*   2. Any modifications must be clearly marked as such.                */
 /*   3. Original authors' names are not deleted.                         */
 /*  This software may not be used for commercial purposes without        */
 /*  specific prior written permission from the authors.                  */
 /*                                                                       */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
 /*  THIS SOFTWARE.                                                       */
 /*                                                                       */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Fri Oct 10 1997                               */
 /* --------------------------------------------------------------------  */
 /* A subclass of TMatrix which copies using memcopy. This isn't          */
 /* suitable for Matrixes of class objects which have to be copied        */
 /* useing a constructor or specialised assignment operator.              */
 /*                                                                       */
 /*************************************************************************/

#include "EST_TSimpleMatrix.h"
#include "EST_TVector.h"
#include "fstream.h"
#include "iostream.h"
#include "EST_cutils.h"

template<class T> 
void EST_TSimpleMatrix<T>::copy_data(const EST_TSimpleMatrix<T> &a)
{
  if (!a.p_sub_matrix && !p_sub_matrix)
    memcpy((void *)&a_no_check(0,0),
	   (const void *)&a.a_no_check(0,0),
	   num_rows()*num_columns()*sizeof(T)
	   );
  else
    {
    for (int i = 0; i < num_rows(); ++i)
      for (int j = 0; j < num_columns(); ++j)
	a_no_check(i,j) = a.a_no_check(i,j);
    }
}

template<class T> 
void EST_TSimpleMatrix<T>::copy(const EST_TSimpleMatrix<T> &a)
{
  if (num_rows() != a.num_rows() || num_columns() != a.num_columns())
    resize(a.num_rows(), a.num_columns(), 0);
  
  copy_data(a);
}

template<class T> 
EST_TSimpleMatrix<T>::EST_TSimpleMatrix(const EST_TSimpleMatrix<T> &in)
{
    copy(in);
}

template<class T> 
void EST_TSimpleMatrix<T>::resize(int new_rows, 
				  int new_cols, 
				  int set)
{
  T* old_vals=NULL;

  if (new_rows<0)
    new_rows = num_rows();
  if (new_cols<0)
    new_cols = num_columns();

  if (set)
    {
      if (!p_sub_matrix && new_cols == num_columns() && new_rows != num_rows())
	{
	  int copy_r = Lof(num_rows(), new_rows);

	  just_resize(new_rows, new_cols, &old_vals);

	  memcpy((void *)p_memory, 
		 (const void *)old_vals,
		 copy_r*new_cols*sizeof(T));
	  
	  int i,j;
	  
	  if (new_rows > copy_r)
	    if (*def_val == 0)
	      {
		memset((void *)(p_memory + copy_r*p_row_step),
		       (new_rows-copy_r)*new_cols*sizeof(T),
		       0);
	      }
	    else
	      {
		for(j=0; j<new_cols; j++)
		  for(i=copy_r; i<new_rows; i++)
		    a_no_check(i,j) = *def_val;
	      }
	}
      else if (!p_sub_matrix)
	{
	  int old_row_step = p_row_step;
	  int old_offset = p_offset;
	  int old_column_step = p_column_step;
	  int copy_r = Lof(num_rows(), new_rows);
	  int copy_c = Lof(num_columns(), new_cols);
	  
	  just_resize(new_rows, new_cols, &old_vals);

	  set_values(old_vals + old_offset,
		     old_row_step, old_column_step,
		     0, copy_r,
		     0, copy_c);

	  int i,j;
	  
	  for(i=0; i<copy_r; i++)
	    for(j=copy_c; j<new_cols; j++)
	      a_no_check(i,j) =  *def_val;
	  
	  if (new_rows > copy_r)
	    if (*def_val == 0)
	      {
		memset((void *)(p_memory + copy_r*p_row_step),
		       (new_rows-copy_r)*new_cols*sizeof(T),
		       0);
	      }
	    else
	      {
		for(j=0; j<new_cols; j++)
		  for(i=copy_r; i<new_rows; i++)
		    a_no_check(i,j) = *def_val;
	      }
	}
      else
	EST_TMatrix<T>::resize(new_rows, new_cols, 1);
    }
  else
    EST_TMatrix<T>::resize(new_rows, new_cols, 0);

  if (old_vals && old_vals != p_memory)
    delete [] old_vals;
}

template<class T> EST_TSimpleMatrix<T> &EST_TSimpleMatrix<T>::operator=(const EST_TSimpleMatrix<T> &in)
{
    copy(in);
    return *this;
}

