 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Tue Aug 12 1997                               */
 /* --------------------------------------------------------------------  */
 /* A TargetTracker gets values from a contour in a stream.               */
 /*                                                                       */
 /*************************************************************************/

#include <stdlib.h>
#include "TargetTracker.h"

static float item_fval(EST_Stream_Item *item)
{
  return atof(item->name());
}

TargetTracker::TargetTracker(void)
{
  initialise();
}

TargetTracker::TargetTracker(EST_Stream *st)
{
  initialise(st);
}

TargetTracker::~TargetTracker(void)
{
  stream=NULL;
  prev_item=NULL;
  next_item=NULL;
}

void TargetTracker::initialise(EST_Stream *st)
{
  stream = st;
  prev_item=NULL;
  next_item=NULL;
  prev_time=0.0;
  next_time=0.0;
  prev_val=0.0;
  next_val=0.0;
  if (st)
    reset_to_start();
}

void TargetTracker::reset_to_start(void)
{
  if (stream)
    {
      prev_item=NULL;
      next_item=stream->head();
      prev_time=0.0;
      next_time=next_item->end();
      prev_val=0.0;
      next_val=item_fval(next_item);
    }
}

float TargetTracker::val_at(float t)
{
  if (t < prev_time)
    reset_to_start();

  while (next_time <= t && next_item)
    {
      prev_item = next_item;
      next_item = next(next_item);

      prev_time = next_time;
      next_time = next_item?next_item->end():(t+1.0);

      prev_val = next_val;
      next_val = next_item?item_fval(next_item):0.0;
    }

  // if (!next_item)
  // cout << "run off end of targets\n";

  float val = prev_val + (next_val-prev_val) * (t-prev_time)/(next_time-prev_time);
  
  // cout << prev_time <<":"<< prev_val << " "
  // << t <<":"<< val << " "
  // << next_time <<":"<< next_val << "\n";

  return val;
}
