
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
 //                                                                        \\
 //                 Centre for Speech Technology Research                  \\
 //                      University of Edinburgh, UK                       \\
 //                        Copyright (c) 1996,1997                         \\
 //                         All Rights Reserved.                           \\
 //   Permission to use, copy, modify, distribute this software and its    \\
 //   documentation for research, educational and individual use only, is  \\
 //   hereby granted without fee, subject to the following conditions:     \\
 //    1. The code must retain the above copyright notice, this list of    \\
 //       conditions and the following disclaimer.                         \\
 //    2. Any modifications must be clearly marked as such.                \\
 //    3. Original authors' names are not deleted.                         \\
 //   This software may not be used for commercial purposes without        \\
 //   specific prior written permission from the authors.                  \\
 //   THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        \\
 //   DISCLAIM ALL WARRANTIES With REGARD TO THIS SOFTWARE, INCLUDING      \\
 //   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   \\
 //   SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     \\
 //   FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    \\
 //   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   \\
 //   AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          \\
 //   ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       \\
 //   THIS SOFTWARE.                                                       \\
 //                                                                        \\
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
 //                                                                        \\
 //                  Author: Richard Caley (rjc@cstr.ed.ac.uk)             \\
 //  --------------------------------------------------------------------  \\
 //  Objects representing sessions on festival servers.                    \\
 //                                                                        \\
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\

package cstr.festival.client ;

import java.lang.*;
import java.util.*;
import java.awt.*;
import java.io.*;
import java.net.*;

public class Session {
  protected Festival festival;
  private int lastID=0;
  protected Hashtable requests;

  public Session(Socket sock)
    {
      festival = new Festival(sock);
      requests = new Hashtable(10);
    }

  public Session(InetAddress addr, int p)
		throws IOException
    {
      festival = new Festival(addr, p);
      requests = new Hashtable(10);
    }

  public Session(String host, int p)
		throws IOException, UnknownHostException
    {
      festival = new Festival(InetAddress.getByName(host), p);
      requests = new Hashtable(10);
    }

  protected void finalize()
    {
      terminate(false);
    }

  public void initialise()
    {
      festival.connect();
    }

  public void terminate(boolean carefully)
    {
      festival.disconnect(carefully);
    }

  public Request request(String c, RequestListener l)
    {
      Integer id = new Integer(newID());
      Request r =  new Request(c,id, this);
      if (l!= null)
	r.addRequestListener(l);
      requests.put(id, r);
      festival.newJob(id, c, this);

      return r;
    }

  public void notifyRunning(Integer id)
    {
       Request r =  (Request)requests.get(id);

       r.notifyRunning();
    }

  public void notifyError(Integer id, String message)
    {
       Request r =  (Request)requests.get(id);

       r.notifyError(message);
    }

  public void notifyResult(Integer id, int type, Object result)
    {
       Request r =  (Request)requests.get(id);
       r.notifyResult(result);
    }

  public void notifyFinished(Integer id)
    {
       Request r =  (Request)requests.get(id);
       // it's finished, so we can forget about it.
       requests.remove(id);
       r.notifyFinished();
    }

  private int newID()
    {
      return ++lastID;
    }
}
