/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/*                          Author: Paul Taylor                          */
/*                           Date: March 1998                            */
/* --------------------------------------------------------------------- */
/*                                                                       */
/*************************************************************************/


#ifndef __UNISYN_H__
#define __UNISYN_H__

#include "festival.h"


typedef EST_TVector <EST_Wave> EST_FrameVector;


// utility functions
void parse_unit_times(EST_Relation &unit_stream, EST_Relation &source_lab);
int read_spn(EST_String &filename, EST_Utterance &u);
int verify_spn(EST_Relation &source, EST_Relation &target);
void pitchmarks_to_f0(EST_Track &pm, EST_Track &fz, float shift);

void add_wave_to_utterance(EST_Utterance &u, EST_Wave &sig, 
			const EST_String &name);

void gc_framevector(void *f);

LISP us_ps_synthesis(LISP args);

LISP FT_copy_synth(LISP lsrc_filename, LISP llab_filename, 
		   LISP lspn_filename);

void make_mapping(EST_Relation &slab, EST_Track &slpc, EST_Relation &tlab,
		 EST_Track &tlpc, EST_IVector &map);

LISP FT_lpc_resynth(LISP llpc_filename, LISP lres_filename);

void alt_synth(EST_Track &lpc, EST_Wave & res, EST_Wave &sig);

void window_frame(EST_Wave &frame, EST_Wave &whole, 
			   int start, int end);

void extract_frames(EST_Track &source_lpc, EST_Wave &source_res, 
			 EST_Track &target_lpc, EST_Wave &target_res,
			 EST_IVector &map);

void add_signal(EST_Relation &unit_stream, EST_Wave &source_sig);
void add_residual(EST_Relation &unit_stream, EST_Wave &source_res);

void targets_to_pitchmarks(EST_Relation &targ, EST_Track &pitchmarks, 
			   int num_channels = 0);


void us_unit_copy_wave(EST_Utterance &utt, EST_Wave &source_sig, 
		  EST_Track *source_pm);

void warp_pitchmarks(EST_Utterance &utt, EST_Track *source_pm, 
		    EST_Relation &source_seg, EST_Relation &target_seg);

void us_F0targets_to_pitchmarks(EST_Utterance &utt);

void f0_to_pitchmarks(EST_Track &fz, EST_Track &pm, float target_end = -1);
void add_end_silences(EST_Relation &segment);
void targets_to_f0(EST_Relation &targ, EST_Track &f0, const float shift);

void us_unit_concat(EST_Utterance &utt);

void us_lpc_synthesis(EST_Utterance &utt);
#ifdef HAVE_US_TDPSOLA_TM
void us_init_tdpsola();
void us_tdpsola_synthesis(EST_Utterance &utt);
#endif

void lpc_synthesis(EST_Track &source_coef, EST_Track &target_coef, 
		   EST_TVector <EST_Wave> &frames, EST_Wave &sig, 
		   EST_IVector &map);

void debug_options(EST_Relation &source_lab, EST_Relation &unit,
		   EST_Track &source_coef,
		   EST_Track &target_coef, EST_TVector <EST_Wave> &frames);

void concatenate_coefs(EST_Relation &unit_stream, EST_Track &source_lpc);

void window_signal(EST_Wave &sig, EST_Track &pm, 
		   EST_TVector<EST_Wave> &frames, int &i, float window_factor);

void window_signal(EST_Relation &unit_stream, EST_TVector<EST_Wave> &frames, 
		   float window_factor);

void extract_frames(EST_Track &source_lpc, EST_Track &target_coef, 
		    EST_IVector &map);

void td_synthesis(EST_Track &source_pm, EST_TVector<EST_Wave> &frames,
		  EST_Track &target_pm, EST_Wave &target_sig,
		  EST_IVector &map);

void target_times(EST_Track &source_pm, EST_Track &target_pm, 
		  EST_Relation &unit, EST_IVector &map);

void window_frame(EST_Wave &frame, EST_Wave &whole, 
		  int start, int end);

void smooth_energy(EST_Relation &unit_stream, EST_TVector<EST_Wave> &frames);
void alt_synth(EST_Track &lpc, EST_Wave & res, EST_Wave &sig);

#endif // __UNISYN_H__
