 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/

#ifndef __CSTRRAWUNITCATALOGUE_H__
#define __CSTRRAWUNITCATALOGUE_H__

#include "RawUnitCatalogue.h"
#include "EST_THash.h"

/** Simple textual catalogue.
  * 
  * This class understands the traditional CSTR format catalogues.
  * 
  * @see RawUnitDatabase
  * @author Richard Caley <rjc@cstr.ed.ac.uk>
  * @version $Id: CstrRawUnitCatalogue.h,v 1.1 1998/08/12 09:35:52 awb Exp $
  */
class CstrRawUnitCatalogue : public RawUnitCatalogue {

public:
    /// Itterate over units.
    class CstrRawItterator : UnitCatalogue::Itterator {
    public:
	CstrRawItterator(void);
	virtual ~CstrRawItterator(void);
	virtual UnitName next(void);
	virtual int at_end(void);
    };

private:

    /// maximum input line length
    static const int s_line_length;

    /// Cache of unit entries.
    EST_TStringHash<Entry *> p_entries;
    /// Count of entries.
    int p_num_entries;

    /// Default constructor.
    CstrRawUnitCatalogue(void);
    /// Destructor

public:
    virtual ~CstrRawUnitCatalogue(void);

    /// Return an itterator.
    UnitCatalogue::Itterator *itterator(void);

    /// Get entry for name.
    virtual struct Entry *lookup(UnitName name); 

    /// Count entries in catalogue
    virtual int num_entries (void) {return p_num_entries; };
    /// Is this a valid entry?
    virtual int has_entry(UnitName name);


    /**@name Subtyping */
    //@{
    /// Recognise a RawUnitCatalogue on a stream.
    static bool recognise(FILE *stream);
    /// Create a RawUnitCatalogue.
    static UnitCatalogue *create(void);
    /// Get the database information from the stream.
    virtual EST_read_status fill_from(FILE *stream);
    /// Write the database out.
    virtual EST_write_status write_to(FILE *stream);
    
    /// Name of this subtype.
    virtual EST_String subtype_name(void) const {return "CstrRaw";}
    //@}

    friend class RawUnitDatabase;
};

#endif
