 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/


/**@name UnitAux.h
  * 
  * Auxiliary types used in the unit and unit database systems. These 
  * are currently fairly simple and wil need to be improved when we
  * start to add more complex selection modules.
  * 
  * @see UnitName
  * @see UnitProperties
  * @see UnitDatabase
  * @author Richard Caley <rjc@cstr.ed.ac.uk>
  * @version $Id: UnitAux.h,v 1.1 1998/08/12 09:35:52 awb Exp $
  */
//@{
#ifndef __UNITAUX_H__
#define __UNITAUX_H__

#include "EST_String.h"


/** UnitName is pretty basic, it`s really just a place holder in case we
  * decide to make names something more interesting.
  */
class UnitName {
private:
  /// The actual name.
  EST_String nm;

public:
  /// Default constructors.
  UnitName(void) {nm= "";};
  /// Construct from EST_String
  UnitName(const EST_String s) {nm=s;};
  /// Construct from C string
  UnitName(const char *it) {nm=it;};
  /// Copy constructor
  UnitName(const UnitName &from) {nm=from.nm;};

  /// Access as an EST_String
  operator EST_String () const {return nm;};

  /**@name Operators */
  //@{
  ///
  int operator == (const UnitName &n) const {return nm == n.nm;}; 
  ///
  int operator !=(const UnitName &n) const {return nm != n.nm;};

  ///
  UnitName &operator = (const UnitName &from) {nm=from.nm; return *this;};
  ///
  UnitName &operator = (const char *name) {nm=name; return *this;};
  ///
  UnitName &operator = (const EST_String &name) {nm = name; return *this;};
  //@}
};

/** UnitProperties stores the array of properties which the selection
  * code might want. Outside the indexing and selection code we just treat
  * it as a block of memory 
  */
class UnitProperties {

private:
  /// Size of the property set.
#    define NUM_LONGS_IN_PROPERTIES (4)

  /// Dual view of the memory.
  union cont_u {
    /// as bytes
    char ch[sizeof(long)*NUM_LONGS_IN_PROPERTIES];
    /// as longs
    struct { long a,b,c,d; } ln;
  };

  /// The memory.
  union cont_u contents;

public:
  /// Default constructor.
  UnitProperties(void) {memset(contents.ch, 0, sizeof(long)*NUM_LONGS_IN_PROPERTIES);};
  /// Copy constructor.
  UnitProperties(UnitProperties &from) {contents.ln = from.contents.ln;};

  /// View as bytes.
  operator const char *() const {return contents.ch;};
  /// View as longs.
  operator const long &() const {return contents.ln.a;};

  /// Assign from one to another.
  UnitProperties &operator = (UnitProperties &from) {contents.ln = from.contents.ln; return *this;};
};
  
#endif
//@}
