;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                       Copyright (c) 1996,1997                         ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   CART trees for predicting Tilt parameters
;;;

(set! ked_tilt_param_trees
'(
  (sil
   (tilt_start_f0
    ((pp.name is 0)
     ((0 0))
     ((pp.name is afb)
      ((3.11825 93.9965))
      ((pp.name is c)
       ((14.7581 99.8651))
       ((14.3378 97.2784)))))
    ;; RMSE 17.2464 Correlation is 0.9421 Mean (abs) Error 4.0128 (16.8576)
   ))
  (rb
   (tilt_peak_pos
    ((0.109 0.072))
   )
   (tilt_tilt
    ((0.733 0.352))
   )
   (tilt_duration
    ((0.037 0.188))
   )
   (tilt_amplitude
    ((21.800 23.357))
   )
   (tilt_start_f0
    ((20.117 122.653))
   ))
  (m
   (tilt_peak_pos
    ((Syllable.n.stress is 0)
     ((Syllable.syl_onset_type is +S)
      ((0.0706467 -0.0131875))
      ((0.0776139 0.0316538)))
     ((0.20235 0.0216667)))
    ;; RMSE 0.0240 Correlation is 0.7875 Mean (abs) Error 0.0205 (0.0133)
   )
   (tilt_tilt
    ((Syllable.syl_onset_type is +V-S)
     ((0.662804 0.023619))
     ((Syllable.syl_onset_type is -V)
      ((0.532161 0.0967647))
      ((0.627629 -0.0587727))))
    ;; RMSE 0.2885 Correlation is 0.7031 Mean (abs) Error 0.2397 (0.1703)
   )
   (tilt_duration
    ((Syllable.nn.stress is 0)
     ((Syllable.lisp_get_onset_length < 0.0712)
      ((0.0585898 0.221944))
      ((0.0784008 0.153235)))
     ((0.0545344 0.2136)))
    ;; RMSE 0.0421 Correlation is 0.7451 Mean (abs) Error 0.0340 (0.0263)
   )
   (tilt_amplitude
    ((lisp_next_tilt_accent is 0)
     ((4.92173 2.89779))
     ((6.37411 5.72333)))
    ;; RMSE 8.4903 Correlation is 0.3911 Mean (abs) Error 6.7526 (5.4588)
   )
   (tilt_start_f0
    ((n.name is fb)
     ((6.38126 102.61))
     ((Syllable.ssyl_out < 2.1)
      ((6.06223 104.409))
      ((Syllable.syl_out < 8)
       ((12.4111 110.885))
       ((11.125 116.319)))))
    ;; RMSE 5.1863 Correlation is 0.5192 Mean (abs) Error 4.4467 (2.8310)
   ))
  (fb
   (tilt_peak_pos
    ((Syllable.syl_break is 4)
     ((Syllable.pp.stress is 0)
      ((0.0837093 -0.0760275))
      ((Syllable.lisp_vowel_class is M)
       ((0.0714103 -0.0484524))
       ((0.0887288 -0.02612))))
     ((Syllable.n.syl_break is 0)
      ((0.0377998 0.0036))
      ((0.110406 0.0554))))
    ;; RMSE 0.0707 Correlation is 0.6547 Mean (abs) Error 0.0580 (0.0411)
   )
   (tilt_tilt
    ((nn.name is sil)
     ((Syllable.p.lisp_tilt_accented is 0)
      ((Syllable.last_accent < 2.5)
       ((0.374664 -0.429227))
       ((0.228368 -0.562357)))
      ((Syllable.stress is 0)
       ((0.214006 -0.604461))
       ((0.354467 -0.554929))))
     ((nn.name is a)
      ((0.470828 -0.133588))
      ((Syllable.stress is 0)
       ((Syllable.p.stress is 0)
        ((0.652289 0.28625))
        ((0.653087 0.122625)))
       ((0.597707 -0.0862222)))))
    ;; RMSE 0.4009 Correlation is 0.7066 Mean (abs) Error 0.2984 (0.2711)
   )
   (tilt_duration
    ((Syllable.syl_coda_type is +V-S)
     ((Syllable.duration < 0.2447)
      ((0.0569972 0.1075))
      ((0.0490816 0.1194)))
     ((Syllable.n.syl_break is 0)
      ((Syllable.stress is 0)
       ((Syllable.syl_coda_type is -V)
        ((0.050488 0.0975))
        ((Syllable.duration < 0.1266)
         ((Syllable.duration < 0.1134)
          ((0.0639137 0.115571))
          ((0.043221 0.133056)))
         ((pp.name is c)
          ((0.0586967 0.130789))
          ((0.0685692 0.172273)))))
       ((Syllable.syl_coda_type is -V)
        ((0.0522454 0.153125))
        ((Syllable.lisp_get_onset_length < 0.048)
         ((0.0450392 0.175769))
         ((0.0725948 0.231)))))
      ((0.0644715 0.1625))))
    ;; RMSE 0.0574 Correlation is 0.4435 Mean (abs) Error 0.0463 (0.0344)
   )
   (tilt_amplitude
    ((Syllable.asyl_in < 5.6)
     ((Syllable.syl_in < 14.7)
      ((Syllable.syl_in < 7)
       ((10.7029 0.881))
       ((Syllable.asyl_in < 4.2)
        ((Syllable.asyl_in < 3.1)
         ((12.583 5.10542))
         ((Syllable.syl_in < 11.2)
          ((8.55624 2.85991))
          ((7.65918 3.443))))
        ((Syllable.syl_in < 11)
         ((5.20053 -0.0249286))
         ((11.915 7.43286)))))
      ((Syllable.syl_in < 15.6)
       ((5.55251 2.84008))
       ((6.15121 0.903786))))
     ((7.24085 1.4086)))
    ;; RMSE 42.1760 Correlation is 0.3956 Mean (abs) Error 12.2947 (40.8581)
   )
   (tilt_start_f0
    ((p.name is c)
     ((Syllable.ssyl_in < 5.2)
      ((8.29266 101.743))
      ((4.70417 97.5362)))
     ((Syllable.ssyl_in < 7)
      ((Syllable.ssyl_in < 5.4)
       ((Syllable.ssyl_in < 4.5)
        ((10.4022 108.26))
        ((7.42046 103.589)))
       ((7.14612 102.185)))
      ((Syllable.ssyl_in < 8.2)
       ((Syllable.pp.syl_break is 0)
        ((10.125 104.318))
        ((7.40435 103.457)))
       ((7.52471 104.031)))))
    ;; RMSE 16.7303 Correlation is 0.5021 Mean (abs) Error 7.5337 (15.1284)
   ))
  (c
   (tilt_start_f0
    ((lisp_next_tilt_accent is a)
     ((pp.name is sil)
      ((7.31187 122.778))
      ((pp.name is 0)
       ((11.2976 118.166))
       ((9.84658 110.852))))
     ((lisp_next_tilt_accent is afb)
      ((7.17241 105.399))
      ((lisp_next_tilt_accent is 0)
       ((11.2424 98.3497))
       ((pp.name is c)
        ((lisp_next_tilt_accent is m)
         ((7.24538 107.832))
         ((10.1947 107.82)))
        ((13.1052 118.202))))))
    ;; RMSE 10.6802 Correlation is 0.6500 Mean (abs) Error 7.0926 (8.0038)
   ))
  (arb
   (tilt_peak_pos
    ((0.071 0.136))
   )
   (tilt_tilt
    ((0.067 0.965))
   )
   (tilt_duration
    ((0.045 0.202))
   )
   (tilt_amplitude
    ((12.756 26.770))
   )
   (tilt_start_f0
    ((7.554 107.712))
   ))
  (afb
   (tilt_peak_pos
    ((Syllable.pp.lisp_tilt_accented is 0)
     ((Syllable.duration < 0.449)
      ((Syllable.duration < 0.3125)
       ((nn.name is sil)
        ((0.0607085 -0.0447692))
        ((0.0716553 -0.0158824)))
       ((0.0721435 0.00893939)))
      ((0.0538284 -0.0248)))
     ((0.0386931 -0.0365714)))
    ;; RMSE 0.0365 Correlation is 0.7517 Mean (abs) Error 0.0292 (0.0229)
   )
   (tilt_tilt
    ((Syllable.syl_in < 7.8)
     ((0.174842 -0.428067))
     ((0.290563 -0.403468)))
    ;; RMSE 0.2400 Correlation is 0.2847 Mean (abs) Error 0.1993 (0.1396)
   )
   (tilt_duration
    ((Syllable.lisp_get_rhyme_length < 0.3748)
     ((Syllable.n.syl_break is 0)
      ((Syllable.lisp_get_rhyme_length < 0.213)
       ((0.0597275 0.209))
       ((Syllable.lisp_get_rhyme_length < 0.25)
        ((0.0576773 0.265333))
        ((Syllable.p.stress is 0)
         ((0.111079 0.21))
         ((0.0572012 0.242857)))))
      ((0.0760482 0.298333)))
     ((0.0703901 0.25619)))
    ;; RMSE 0.0457 Correlation is 0.6475 Mean (abs) Error 0.0381 (0.0265)
   )
   (tilt_amplitude
    ((Syllable.syl_break is 4)
     ((Syllable.stress is 0)
      ((7.63193 8.29543))
      ((Syllable.lisp_get_rhyme_length < 0.221)
       ((8.38729 6.45207))
       ((Syllable.lisp_get_rhyme_length < 0.376)
        ((Syllable.syl_coda_type is -V)
         ((9.15147 6.71935))
         ((14.7806 16.1564)))
        ((8.62855 10.5999)))))
     ((8.08785 16.3471)))
    ;; RMSE 8.7243 Correlation is 0.4209 Mean (abs) Error 7.9975 (3.6412)
   )
   (tilt_start_f0
    ((Syllable.duration < 0.263)
     ((4.02673 104.312))
     ((Syllable.duration < 0.493)
      ((6.43455 104.37))
      ((4.87514 105.052))))
    ;; RMSE 8.3066 Correlation is 0.6617 Mean (abs) Error 6.3986 (5.5324)
   ))
  (a
   (tilt_peak_pos
    ((Syllable.ssyl_in < 5.5)
     ((Syllable.ssyl_in < 0.5)
      ((Syllable.pp.syl_break is 0)
       ((Syllable.syl_onset_type is +S)
        ((Syllable.syl_coda_type is +V-S)
         ((0.0578794 0.0462609))
         ((Syllable.lisp_vowel_class is L)
          ((0.0570748 0.0721667))
          ((0.0815165 0.0734615))))
        ((Syllable.lisp_vowel_class is M)
         ((Syllable.syl_onset_type is -V)
          ((0.0441567 0.04732))
          ((0.0774986 0.0789737)))
         ((Syllable.syl_coda_type is +V-S)
          ((0.0773499 0.0982692))
          ((Syllable.lisp_vowel_class is L)
           ((0.0672582 0.093075))
           ((Syllable.syl_coda_type is +S)
            ((0.0693386 0.0910476))
            ((0.208205 0.17887)))))))
       ((0.0652064 0.0574091)))
      ((Syllable.syl_onset_type is +S)
       ((Syllable.ssyl_in < 4.2)
        ((Syllable.ssyl_in < 3.1)
         ((Syllable.lisp_vowel_class is L)
          ((0.0642269 0.001))
          ((Syllable.ssyl_in < 2)
           ((Syllable.syl_coda_type is -V)
            ((0.0770217 -0.0099697))
            ((Syllable.ssyl_in < 1.1)
             ((Syllable.syl_coda_type is +S)
              ((0.203606 0.0734545))
              ((0.141519 0.0278182)))
             ((0.0694096 0.0145946))))
           ((0.0705087 0.00592105))))
         ((0.0625171 0.0122353)))
        ((0.10151 -0.00258621)))
       ((Syllable.lisp_vowel_class is H)
        ((Syllable.ssyl_in < 4.2)
         ((Syllable.ssyl_in < 3.1)
          ((Syllable.syl_coda_type is -V)
           ((0.0787014 0.0182857))
           ((Syllable.syl_onset_type is -V)
            ((0.0791604 0.0204737))
            ((0.136284 0.0295873))))
          ((0.0616234 0.0294848)))
         ((0.0783572 0.0363182)))
        ((Syllable.ssyl_in < 3)
         ((Syllable.syl_coda_type is +V-S)
          ((Syllable.lisp_vowel_class is M)
           ((0.062284 0.0264167))
           ((0.0652833 0.0412857)))
          ((Syllable.ssyl_in < 2)
           ((0.18435 0.0558176))
           ((Syllable.pp.syl_break is 0)
            ((0.0779137 0.0451818))
            ((lisp_next_tilt_boundary is fb)
             ((0.154051 0.0482))
             ((0.0780237 -0.00194444))))))
         ((Syllable.syl_coda_type is -V)
          ((0.0673087 0.0443571))
          ((Syllable.pp.syl_break is 0)
           ((0.0570814 0.03925))
           ((0.153644 0.057069))))))))
     ((Syllable.syl_onset_type is -V)
      ((0.0283965 0.0189615))
      ((0.100082 0.0165823))))
    ;; RMSE 0.1100 Correlation is 0.3945 Mean (abs) Error 0.0605 (0.0921)
   )
   (tilt_tilt
    ((pp.name is c)
     ((Syllable.next_accent < 2.4)
      ((0.41564 -0.0917647))
      ((0.286922 -0.37513)))
     ((Syllable.next_accent < 4)
      ((Syllable.pp.lisp_tilt_accented is 0)
       ((lisp_next_tilt_accent is afb)
        ((Syllable.next_accent < 1.2)
         ((0.498046 0.217867))
         ((0.411368 -0.115147)))
        ((Syllable.next_accent < 2.1)
         ((Syllable.next_accent < 1.2)
          ((pp.name is sil)
           ((Syllable.next_accent < 0.1)
            ((0.291769 0.663042))
            ((0.619499 0.183328)))
           ((Syllable.duration < 0.56847)
            ((Syllable.next_accent < 0.1)
             ((lisp_next_tilt_accent is a)
              ((Syllable.pp.syl_break is 0)
               ((pp.name is 0)
                ((0.760528 -0.0404444))
                ((0.658021 0.283136)))
               ((0.551611 0.211257)))
              ((Syllable.duration < 0.299)
               ((0.635231 0.124526))
               ((0.636275 -0.0767308))))
             ((lisp_next_tilt_accent is 0)
              ((0.366684 -0.181462))
              ((Syllable.duration < 0.3053)
               ((Syllable.duration < 0.24532)
                ((0.647823 0.132299))
                ((0.585684 -0.0486552)))
               ((0.566507 -0.267667)))))
            ((0.325847 -0.595913))))
          ((Syllable.duration < 0.27904)
           ((Syllable.duration < 0.18988)
            ((Syllable.n.syl_break is 0)
             ((0.522524 0.229778))
             ((0.495382 -0.0908919)))
            ((Syllable.duration < 0.24807)
             ((Syllable.pp.syl_break is 0)
              ((0.572111 -0.163381))
              ((0.520219 -0.0668214)))
             ((0.517164 -0.225083))))
           ((Syllable.pp.syl_break is 0)
            ((pp.name is 0)
             ((0.546488 -0.431364))
             ((0.432836 -0.00795238)))
            ((0.351851 -0.0798125)))))
         ((pp.name is sil)
          ((0.521498 0.118786))
          ((0.522452 -0.127915)))))
       ((Syllable.next_accent < 2.1)
        ((Syllable.n.syl_break is 0)
         ((0.421744 -0.197806))
         ((Syllable.next_accent < 1.2)
          ((Syllable.duration < 0.28024)
           ((Syllable.n.syl_break is 4)
            ((0.659705 0.304421))
            ((0.432375 -0.190645)))
           ((0.428853 -0.103471)))
          ((0.370859 -0.161952))))
        ((0.403105 -0.252757))))
      ((pp.name is 0)
       ((0.317927 -0.622696))
       ((Syllable.next_accent < 5.2)
        ((Syllable.duration < 0.25692)
         ((lisp_next_tilt_accent is a)
          ((0.525939 -0.104041))
          ((0.402569 -0.0306667)))
         ((0.32372 -0.206735)))
        ((0.225692 -0.23496))))))
    ;; RMSE 0.4904 Correlation is 0.4557 Mean (abs) Error 0.3974 (0.2880)
   )
   (tilt_duration
    ((Syllable.position_type is final)
     ((Syllable.syl_in < 2.4)
      ((0.0513844 0.233571))
      ((Syllable.next_accent < 0.6)
       ((0.0482479 0.241429))
       ((0.0686357 0.2594))))
     ((Syllable.next_accent < 1)
      ((Syllable.syl_in < 11.9)
       ((Syllable.position_type is initial)
        ((0.0669872 0.177879))
        ((Syllable.position_type is single)
         ((Syllable.syl_in < 1.1)
          ((0.0803163 0.149211))
          ((Syllable.syl_in < 6.5)
           ((0.0785214 0.230122))
           ((0.0672078 0.220857))))
         ((0.0718909 0.172778))))
       ((0.0579338 0.173684)))
      ((Syllable.syl_in < 6.3)
       ((Syllable.syl_in < 0.6)
        ((Syllable.next_accent < 1.5)
         ((0.0419366 0.156842))
         ((Syllable.next_accent < 2.4)
          ((0.0593276 0.160862))
          ((0.0431509 0.176563))))
        ((Syllable.next_accent < 1.9)
         ((Syllable.syl_in < 1.5)
          ((Syllable.position_type is initial)
           ((0.054586 0.2))
           ((0.0640963 0.2175)))
          ((Syllable.position_type is single)
           ((0.0438851 0.261351))
           ((0.0611948 0.226333))))
         ((Syllable.syl_in < 1.5)
          ((Syllable.next_accent < 2.5)
           ((0.0578807 0.234219))
           ((Syllable.nn.stress is 0)
            ((0.0554928 0.216087))
            ((Syllable.next_accent < 3.4)
             ((0.0777496 0.2265))
             ((0.105377 0.221)))))
          ((Syllable.syl_in < 5.2)
           ((Syllable.position_type is single)
            ((Syllable.syl_in < 4.1)
             ((Syllable.next_accent < 2.3)
              ((0.0715067 0.255909))
              ((0.0582217 0.285476)))
             ((0.0444538 0.305556)))
            ((Syllable.next_accent < 2.8)
             ((0.0722542 0.25331))
             ((Syllable.position_type is initial)
              ((Syllable.syl_in < 3.2)
               ((Syllable.syl_in < 2.1)
                ((0.0843594 0.28075))
                ((0.102074 0.228125)))
               ((0.0697102 0.261129)))
              ((0.0669801 0.270517)))))
           ((0.0674395 0.259468))))))
       ((Syllable.syl_in < 14)
        ((Syllable.syl_in < 7.6)
         ((Syllable.next_accent < 1.5)
          ((0.0463501 0.23875))
          ((0.0416545 0.265729)))
         ((0.0633471 0.255669)))
        ((0.0419551 0.269318))))))
    ;; RMSE 0.0656 Correlation is 0.5346 Mean (abs) Error 0.0484 (0.0444)
   )
   (tilt_amplitude
    ((Syllable.n.syl_break is 4)
     ((Syllable.syl_in < 12.5)
      ((Syllable.pp.lisp_tilt_accented is 0)
       ((Syllable.syl_onset_type is -V)
        ((10.0917 8.17733))
        ((Syllable.syl_in < 10)
         ((Syllable.syl_onset_type is +S)
          ((9.11639 10.6822))
          ((11.0195 9.06961)))
         ((8.65104 8.38423))))
       ((7.66234 7.92033)))
      ((5.57534 5.26378)))
     ((Syllable.syl_in < 8.4)
      ((Syllable.syl_in < 6.4)
       ((Syllable.syl_in < 5.4)
        ((Syllable.syl_in < 4.5)
         ((Syllable.syl_in < 3.2)
          ((Syllable.syl_onset_type is +S)
           ((Syllable.syl_in < 0.3)
            ((6.83502 6.68152))
            ((nn.name is a)
             ((Syllable.next_accent < 2.1)
              ((12.7246 10.7685))
              ((10.8916 16.6102)))
             ((8.50684 10.6289))))
           ((Syllable.syl_in < 2.1)
            ((Syllable.pp.lisp_tilt_accented is 0)
             ((Syllable.nn.lisp_tilt_accented is 0)
              ((Syllable.syl_in < 0.2)
               ((Syllable.lisp_vowel_class is L)
                ((7.7421 9.52353))
                ((15.2328 10.6393)))
               ((n.name is c)
                ((Syllable.nn.syl_break is 0)
                 ((14.5425 17.5628))
                 ((Syllable.lisp_vowel_class is M)
                  ((14.8701 10.8813))
                  ((Syllable.syl_break is 0)
                   ((24.2492 20.0438))
                   ((17.3674 14.6303)))))
                ((8.51834 5.49444))))
              ((Syllable.lisp_vowel_class is L)
               ((10.1126 11.0047))
               ((Syllable.syl_onset_type is -V)
                ((9.17803 11.6815))
                ((16.275 14.8068)))))
             ((12.8932 9.35274)))
            ((Syllable.nn.syl_break is 0)
             ((9.72628 7.54696))
             ((Syllable.pp.syl_break is 0)
              ((10.2591 10.8963))
              ((14.7102 19.6105))))))
          ((Syllable.pp.lisp_tilt_accented is 0)
           ((Syllable.nn.syl_break is 0)
            ((10.3688 8.85233))
            ((Syllable.syl_onset_type is +V-S)
             ((13.1315 9.50377))
             ((15.8953 16.1358))))
           ((8.62082 8.72258))))
         ((Syllable.next_accent < 1.4)
          ((Syllable.syl_break is 1)
           ((7.32652 2.53572))
           ((5.57986 6.30494)))
          ((Syllable.n.syl_break is 0)
           ((9.10638 10.006))
           ((Syllable.next_accent < 2.5)
            ((15.2799 13.9507))
            ((10.6434 17.8872))))))
        ((Syllable.nn.syl_break is 0)
         ((6.70397 8.72096))
         ((Syllable.pp.syl_break is 0)
          ((11.8494 12.2881))
          ((14.7318 14.8973)))))
       ((Syllable.nn.syl_break is 4)
        ((5.89769 8.45118))
        ((Syllable.syl_break is 1)
         ((7.57682 9.18504))
         ((9.37639 13.6866)))))
      ((Syllable.pp.lisp_tilt_accented is 0)
       ((Syllable.lisp_vowel_class is L)
        ((6.19677 10.3315))
        ((nn.name is a)
         ((7.44193 9.32358))
         ((Syllable.n.syl_break is 0)
          ((14.6794 12.1852))
          ((8.7834 10.6273)))))
       ((6.57153 6.04525)))))
    ;; RMSE 13.5343 Correlation is 0.4052 Mean (abs) Error 8.3391 (10.6870)
   )
   (tilt_start_f0
    ((Syllable.syl_in < 10.5)
     ((Syllable.syl_in < 7)
      ((Syllable.syl_in < 5.4)
       ((Syllable.syl_in < 4.5)
        ((Syllable.syl_in < 3.2)
         ((Syllable.syl_in < 2.1)
          ((Syllable.position_type is mid)
           ((8.82989 119.318))
           ((Syllable.syl_in < 1.2)
            ((p.name is c)
             ((Syllable.syl_coda_type is -V)
              ((6.70063 121.301))
              ((Syllable.syl_coda_type is +V-S)
               ((6.28776 120.919))
               ((11.617 118.575))))
             ((Syllable.syl_onset_type is -V)
              ((Syllable.position_type is single)
               ((10.0543 130.22))
               ((11.0505 134.873)))
              ((11.5162 124.077))))
            ((Syllable.p.lisp_tilt_accented is 0)
             ((Syllable.syl_onset_type is -V)
              ((6.79506 121.473))
              ((10.4465 119.152)))
             ((7.95688 121.433)))))
          ((Syllable.position_type is single)
           ((7.59178 115.445))
           ((Syllable.syl_coda_type is +V-S)
            ((8.68792 118.068))
            ((10.8168 119.873)))))
         ((Syllable.position_type is single)
          ((6.94477 114.935))
          ((8.55873 114.963))))
        ((Syllable.syl_coda_type is +V-S)
         ((7.42639 107.15))
         ((Syllable.position_type is initial)
          ((8.48156 112.404))
          ((Syllable.asyl_in < 1.2)
           ((8.83161 116.295))
           ((7.96656 111.306))))))
       ((Syllable.syl_onset_type is -V)
        ((6.36835 112.192))
        ((Syllable.position_type is initial)
         ((7.43608 108.37))
         ((8.57304 110.9)))))
      ((Syllable.p.lisp_tilt_accented is 0)
       ((Syllable.syl_in < 9.1)
        ((Syllable.position_type is single)
         ((Syllable.syl_coda_type is +S)
          ((5.70777 107.914))
          ((6.19767 106.116)))
         ((Syllable.syl_coda_type is -V)
          ((Syllable.syl_onset_type is +V-S)
           ((5.23474 110.956))
           ((6.4047 107.634)))
          ((Syllable.position_type is mid)
           ((5.63795 107.417))
           ((8.33548 107.436)))))
        ((Syllable.position_type is initial)
         ((5.77774 105.3))
         ((5.69294 107.301))))
       ((4.68061 110.27))))
     ((Syllable.syl_in < 15)
      ((Syllable.position_type is mid)
       ((5.27599 105.443))
       ((Syllable.syl_onset_type is -V)
        ((6.57286 104.011))
        ((Syllable.syl_coda_type is +S)
         ((4.61974 103.504))
         ((6.30118 106.993)))))
      ((3.99551 105.304))))
    ;; RMSE 7.2788 Correlation is 0.7722 Mean (abs) Error 5.6967 (4.5424)
   ))
))

(provide 'tilt_params)
