
UNDERLINE_COMMAND = sed -e '{p;s/./=/g;}'
INDENT_COMMAND = sed -e 's/^/		/'
KV_COMMAND = 	$(AWK) 'NF>1 {printf("%"  ind  "s%s%s\n", $$1, sep, $$2);next;}{print}'


info: 
	@$(RM) -f $(TOP)/config/modincludes* $(TOP)/config/system.mak
	@$(MAKE) -C $(TOP) --no-print-directory real-info .config_error

real-info: 
	@{ \
	echo '---------------------------------------------------------------' ;\
	echo '' ;\
	echo '$(PROJECT_NAME) v$(PROJECT_VERSION) Configuration' | $(UNDERLINE_COMMAND) | $(INDENT_COMMAND) ;\
	echo '' ;\
	echo '$(PROJECT_PREFIX)_HOME:=:$($(PROJECT_PREFIX)_HOME)' ;\
	if [ '$(PROJECT_PREFIX)' != EST ] ;\
		then \
		echo 'EST:=:$(EST)' ;\
		echo 'EST_HOME:=:$(EST_HOME)' ;\
	fi ;\
	echo 'SYSTEM_TYPE:=:$(SYSTEM_TYPE)' ;\
	echo 'COMPILER:=:$(COMPILER_DESC) '`$(COMPILER_VERSION_COMMAND)` ;\
	if [ '$(JAVA_COMPILER)' != none ] ;\
		then \
		echo 'JAVA_COMPILER:=:$(JAVA_COMPILER_DESC) '`$(JAVA_COMPILER_VERSION_COMMAND)` ;\
		echo 'JAVA_HOME:=:$(JAVA_HOME)' ;\
	fi ;\
	echo 'CONFIGURATION:=:$(CONFIGURATION)' ;\
	if [ -n '$(LOCAL_REPOSITORY)' ] ;\
		then \
		echo '' ;\
		echo 'CENTRAL_DIR:=:$(CENTRAL_DIR)' ;\
	fi ;\
	echo '' ;\
	echo 'NATIVE_AUDIO_MODULE:=:$(NATIVE_AUDIO_MODULE)' ;\
	if [ -n '$(INCLUDE_MODULES)' ] ;\
		then \
		echo 'INCLUDE_MODULES:=:' ;\
		{ : ; $(foreach I,$(sort $(INCLUDE_MODULES)),echo '$(I):$(subst ',,$(MOD_DESC_$(I)))';) }| $(KV_COMMAND) FS=: sep=' ' ind=28 ;\
	fi ;\
	echo '' ;\
	echo 'INCLUDES:=:$(INCLUDES)' ;\
	echo 'TEMPLATES:=:$(TEMPLATES)' ;\
	echo 'LIBS:=:$(LIBS)' ;\
	if [ '$(JAVA_COMPILER)' != none ] ;\
		then \
		echo 'JAVA_CLASSPATH:=:$(JAVA_CLASSPATH)' ;\
	fi ;\
	echo '' ;\
	echo '---------------------------------------------------------------' ;\
	} | $(KV_COMMAND) FS=':=:' sep=' = ' ind=22


ifndef REAL_MODULES
modules:
	@$(MAKE) --no-print-dir REAL_MODULES=1 INCLUDE_EVERYTHING=ALL modules
else
modules: 
	@{ \
	echo '---------------------------------------------------------------' ;\
	echo '' ;\
	echo 'Available $(PROJECT_NAME) Modules'|$(UNDERLINE_COMMAND)|$(INDENT_COMMAND) ;\
	echo '' ;\
	{ $(foreach I,$(sort $(ALL_MODULES)),echo '$(I):$(subst ',,$(MOD_DESC_$(I)))';) } |$(KV_COMMAND) FS=: sep='   ' ind=20 ;\
	echo '' ;\
	echo '---------------------------------------------------------------' ;\
	}

endif
