#include "cs.h"                                       /*  SNDINFO.C  */
#include "soundio.h"
#ifdef __MWERKS__
#include "MacTransport.h"
#endif
extern float maxamp[4];
extern float smaxamp[4];
extern float omaxamp[4];

void sndinfo(int argc, char **argv)
{
        char	*infilnam;
        int 	infd, openin(char *);
	SOUNDIN *p;         /* space allocated here */
	HEADATA *hdr, *readheader(int, char*, SOUNDIN*);
extern  char    *retfilnam;
extern	char *getstrformat(int);

        POLL_EVENTS();
	sssfinit();

	while (--argc) {
	    infilnam = *++argv;
	    if ((infd = openin(infilnam)) < 0) {
	        printf("%s:\n\tcouldn't find\n", retfilnam);
		continue;
	    }
	    p = (SOUNDIN *) mcalloc((long)sizeof(SOUNDIN));
	    if ((hdr = readheader(infd, infilnam, p)) != NULL
	      && !hdr->readlong) {
	        long sframes = hdr->audsize / hdr->sampsize / hdr->nchnls;
		if (hdr->filetyp == TYP_AIFF) {
		    AIFFDAT *adp;
		    printf("\tAIFF soundfile");
		    if ((adp = hdr->aiffdata) != NULL
		      && (adp->loopmode1 || adp->loopmode2))
		        printf(", looping with modes %d, %d",
			       adp->loopmode1, adp->loopmode2);
		    else printf(", no looping");
		    printf("\n");
		}
		else if (hdr->filetyp == TYP_AIFC) {
		  AIFFDAT *adp;
		  int i = 0;
		  printf("AIFC soundfile");
		  if ((adp = hdr->aiffdata) != NULL
		      && (adp->loopmode1 || adp->loopmode2))
		    printf(", looping with modes %d, %d",
			   adp->loopmode1, adp->loopmode2);
		  else printf(", no looping");
		  printf("\n");
		  O.outformat = AE_FLOAT;
		  for (i=0; i< 4; i++) {
		    maxamp[i] = smaxamp[i] = omaxamp[i] = (float)0;
		  }
		  maxamp[0] = smaxamp[0] = omaxamp[0] = adp->maxamps[0];
		}
		else if (hdr->filetyp == TYP_WAV)
		    printf("\tWAVE soundfile\n");
		else printf("%s:\n", retfilnam);
		printf("\tsrate %ld, %s, %ld bit %s, %4.2f seconds\n",
		     hdr->sr,
		     hdr->nchnls==1 ? "monaural":
		       hdr->nchnls==2 ? "stereo":
		       hdr->nchnls==4 ? "quad":
		       hdr->nchnls==6 ? "hex":
		       hdr->nchnls==8 ? "oct": "unknown",
		     hdr->sampsize * 8, getstrformat(hdr->format),
		     (float)sframes / hdr->sr);
		printf("\theadersiz %ld, datasiz %ld (%ld sample frames)\n",
		     hdr->hdrsize, hdr->audsize, sframes);
	    }
	    else printf("%s:\n\tno recognizable soundfile header\n", retfilnam);
#ifdef __MWERKS__
	    nchnls = hdr->nchnls;
	    O.outsampsiz = hdr->sampsize;
	    esr = hdr->sr;	
	    transport.osfd = infd;
	    if (hdr->filetyp == 0) transport.eoheader = 0;
	    else transport.eoheader = tell(transport.osfd);
/*	    printf("transport.eoheader = %d\n",transport.eoheader); */
	    fflush(stdout);
	    transport.state &= ~kUtilPerf;
	    transport.state |= kGenerating;
	   	transport.state = SetTransportState(transport.d,transport.state,
						    kGenFinished,0);
	    transport.state |= kFileReOpened;
	    O.outbufsamps = 8192;
	    O.oMaxLag = 4096;
	    while (!(transport.state & kDone)) 
	    	POLL_EVENTS();
#endif
	    mfree((char *)p);
	    close(infd);
	}
#ifndef CWIN
	exit(0);
#endif
}



