#include "cs.h"				/*		MEMALLOC.C	*/

/* global here so reachable by all standalones */
float sstrcod = (float)SSTRCOD;

#ifdef CWIN 
static void** all = NULL;
static int apsize = 0;
static int ap=0;
extern void DisplayMsg(char *, ...);

void all_free(void)
{
/*     DisplayMsg("%d blocks to free", ap); */
    while (--ap>=0) {
/*        DisplayMsg("freeing %p", all[ap]); */
        if (all[ap] != NULL) free(all[ap]);
        all[ap] = NULL;
    }
    free(all);
    all = NULL;			/* For safety */
    ap = 0;
    return;
}
#endif

#ifdef RESET
void memreset(void)
{
      all_free();
/*       ap = 0; */
/*       all = NULL; */
      apsize = 0;
}
#endif

static void memdie(long nbytes)
{
    err_printf("memory allocate failure for %d\n", nbytes);
#ifdef __MWERKS__
    err_printf("try increasing preferred size setting for the Perf Application\n");
#endif
    exit(1);
}

 char *
mcalloc(long nbytes)		/* allocate new memory space, cleared to 0 */
{
	char *p;
	if ((p = (char *)calloc((size_t)nbytes, (size_t)1)) == NULL) {
	  if (nbytes==0) return NULL;
	  else memdie(nbytes);
	}
#ifdef CWIN
	if (ap >= apsize) {
	  void **new_all = (void **)realloc(all, sizeof(void*)*(apsize += 1020));
	  if (new_all == NULL) err_printf( "Too many allocs\n"), exit(1);
	  all = new_all;
	}
        all[ap++] = p;
#endif
	return(p);
}

 char *
mmalloc(long nbytes)	     /* allocate new memory space, NOT cleared to 0 */
{
	char *p;

	if ((p = (char *)malloc((size_t)nbytes)) == NULL)
		memdie(nbytes);
#ifdef CWIN
	if (ap >= apsize) {
	  void **new_all = (void **)realloc(all, sizeof(void*)*(apsize += 1020));
	  if (new_all == NULL) err_printf( "Too many allocs\n"), exit(1);
	  all = new_all;
	}
        all[ap++] = p;
#endif
	return(p);
}

 void *
mrealloc(void *old, long nbytes)		/* Packaged realloc */
{
    void *p;

    if ((p = realloc(old, (size_t)nbytes)) == NULL)
	memdie(nbytes);
#ifdef CWIN
    if (old != NULL) {
      int oldall = 0;
      while (all[oldall] != old) {
	oldall++;
	if (oldall > ap) memdie(-nbytes);
      }
      all[oldall] = p;
    }
    else {
      if (ap >= apsize) {
	void **new_all = (void**)realloc(all, sizeof(void*)*(apsize += 1020));
	if (new_all == NULL) err_printf( "Too many allocs\n"), exit(1);
	all = new_all;
      }
      all[ap++] = p;
    }      
#endif
    return(p);
}

void mfree(void *ptr)
{
#ifdef CWIN
    int i = 0;
    while (all[i] != ptr) {
      i++;
      if (i>ap) memdie(0);
    }
    all[i] = NULL;
#endif
    free(ptr);
}

