#include "cs.h"                 /*                               MAIN.C */
#include "soundio.h"
#include <ctype.h>              /* For isdigit */

#ifdef SYMANTEC
#define main mw_main
#endif

#ifdef __MWERKS__
#include <SIOUX.h>
#include "perf.h"
#include"MacTransport.h"

#define main mw_main
#define PATH_LEN        128

extern struct Transport transport;

extern char sfdir_path[];
extern char sadir_path[];
extern char ssdir_path[];
extern char saved_scorename[];
extern unsigned char mytitle[];
extern Boolean util_perf;
static char *foo;                       
static char listing_file[PATH_LEN];
static int  vbuf;
static int csNGraphs;
static float temp;
#endif

#ifdef __ZPC__
unsigned int _stack = 0xFFF0U;
#endif

static  int     stdinassgn = 0;
static  char    *xfilename = NULL;
static  char    *sortedscore = "score.srt";
static  char    *xtractedscore = "score.xtr";
static  char    *playscore = "score.srt";     /* unless we extract */
static  FILE    *scorin, *scorout, *xfile;
#if !defined(CSOUND_MAIN)
	extern  OPARMS  O;
	char    *orchname = NULL;	/* used by rdorch */
	char	*scorename = NULL;
        FILE    *dribble;
#ifdef LINUX
int midi_out;
extern void openMIDIout(void);
#endif
#else /* defined(CSOUND_MAIN) */
	static  void    dieu(char *), usage(void);
	extern 	char *orchname; 	 /* used by rdorch */
	extern 	char *scorename;
#ifdef LINUX
extern int midi_out;
#endif
#endif /* !defined(CSOUND_MAIN) */

#if defined(CSOUND_MAIN)

#define FIND(MSG)   if (*s == '\0')  \
                        if (!(--argc) || ((s = *++argv) != NULL) && *s == '-') \
                            dieu(MSG);

#ifdef CWIN
void dialog_arguments(void);
#include <stdarg.h>
extern int cwin_atexit(void (*)(void));
#endif /* CWIN */

#if defined(CWIN)
int cwin_main(int argc, char **argv)
#else
int main(int argc, char **argv)
#endif
{
        char c, *s;
        char  outformch, *filnamp, *envoutyp = NULL;
        int   n;
extern  int   getsizformat(int), musmon(void);
extern  char  *getstrformat(int);

        err_printf( "Csound Version %s (%s)\n", VERSIONSTRING, __DATE__);
#ifdef __ZPC__
#ifdef WITHx87
        extern int _8087;
        if (_8087 == 0)
            die("This Csound needs an 80x87");
#endif
#endif
#if !defined(__MWERKS__) && !defined(SYMANTEC)
        {
            char *getenv(const char*);
            if ((envoutyp = getenv("SFOUTYP")) != NULL) {
                if (strcmp(envoutyp,"AIFF") == 0)
                    O.filetyp = TYP_AIFF;
                else if (strcmp(envoutyp,"WAV") == 0)
                    O.filetyp = TYP_WAV;
                else if (strcmp(envoutyp,"IRCAM") == 0)
                    O.filetyp = TYP_IRCAM;
                else {
                    sprintf(errmsg,"%s not a recognized SFOUTYP env setting",
                            envoutyp);
                    dieu(errmsg);
                }
            }
        }
#endif
        POLL_EVENTS();
#ifdef CWIN
        cwin_atexit(all_free);
#endif
        O.filnamspace = filnamp = mmalloc((long)1024);
        dribble = NULL;
        if (--argc == 0) {
#ifdef CWIN
            dialog_arguments();
#else
            dieu("insufficient arguments");
#endif
        }
#ifdef CWIN
        else
#endif
        do {
            POLL_EVENTS();
            s = *++argv;
            if (*s++ == '-') {                        /* read all flags:  */
                while ((c = *s++) != '\0') {
                    switch(c) {
                    case 'U': FIND("no utility name")
#ifdef __MWERKS__
                                util_perf = true;
                                transport.state |= kUtilPerf;
#endif
                              if (strcmp(s,"hetro") == 0) {
                                  printf("util HETRO:\n");
                                  hetro(argc,argv);
                              }
		              else if (strcmp(s,"lpanal") == 0) {
                                  printf("util LPANAL:\n");
                                  lpanal(argc,argv);
                              }
                              else if (strcmp(s,"pvanal") == 0) {
                                  printf("util PVANAL:\n");
                                  pvanal(argc,argv);
                              }
                              else if (strcmp(s,"sndinfo") == 0) {
                                  printf("util SNDINFO:\n");
                                  sndinfo(argc,argv);
                              }
                              else if (strcmp(s,"cvanal") == 0) {
                                  printf("util CVANAL:\n");
                                  cvanal(argc,argv);
                                  exit(0);
                              }
                              else dies("-U %s not a valid UTIL name",s);
#ifdef __MWERKS__
                      return(0);
#endif
/********** commandline flags only for mac version***************************/
/*********************  matt 5/26/96 ****************************************/
#ifdef __MWERKS__
                    case 'q': FIND("no sound sample directory name") 
                                  foo = filnamp;
                                  while ((*filnamp++ = *s++));  s--;
                                  strcpy(ssdir_path,foo);
                                  break;
                    case 'Q': FIND("no analysis directory name") 
                                  foo = filnamp;
                                  while ((*filnamp++ = *s++));  s--;
                                  strcpy(sadir_path,foo);
                                  break;
                        case 'X': FIND("no sound file directory name")
                                        foo = filnamp;
                                        while ((*filnamp++ = *s++));  s--;
                                        strcpy(sfdir_path,foo);
                                        break;
/*                  case '-': FIND("no listing file name") 
                                  foo = filnamp;
                                  while ((*filnamp++ = *s++));  s--;
                                  strcpy(listing_file,foo);
                                  printf("redirecting standard out to %s......\n",listing_file);
                                          if (!freopen(listing_file,"w",stdout))
                                                die("couldn't redirect sandard out\n");
                                  break;
*/                  case 'V': FIND("no screen buffer size")
                              sscanf(s,"%d",&vbuf);
                              setvbuf(stdout, NULL, _IOFBF, vbuf);
                              while (*++s);
                              break;
                        case 'E': FIND("no number of graphs")
                              sscanf(s,"%d",&csNGraphs);
                              SetCsNGraphs(csNGraphs);
                              while (*++s);
                              break;
                    case 'p': SetPlayOnFinish(TRUE);
                                  break;
                    case 'e': if (O.outformat) goto outform;
                              outformch = c;
                              O.outformat = AE_FLOAT;   /* float soundfile */
                              SetRescaleFloatFile(TRUE);
                                  break;
                    case 'w': SetRecordMIDIData(TRUE);
                                  break;
                    case 'y':  FIND("no Rate for Progress Display")
                              sscanf(s,"%f",&temp);
/*### TEMP */err_printf("The Progress/Profile feature is currently disabled, sorry.\n");
                              while (*++s);
                              break;
                    case 'Y':  FIND("no Rate for Profile Display")
                              sscanf(s,"%f",&temp);
/*### TEMP                printf("Profile flag is %f.\n  COMING SOON!!\n",temp); */
                              while (*++s);
                              break;
#endif
/***************************************************************************/
                    case 'C': O.usingcscore = 1;     /* use cscore processing  */
                              break;
                    case 'I': O.initonly = 1;           /* I-only implies */
                    case 'n': O.sfwrite = 0;            /* nosound        */
                              break;
                    case 'i': FIND("no infilename")
                              O.infilename = filnamp;   /* soundin name */
                              while ((*filnamp++ = *s++));  s--;
                              POLL_EVENTS();
                              if (strcmp(O.infilename,"stdout") == 0)
                                  dieu("-i cannot be stdout");
                              if (strcmp(O.infilename,"stdin") == 0)
#if defined __MWERKS__ || defined SYMANTEC
                                  dieu("stdin audio not supported");
#else
                              {
                                  if (stdinassgn)
                                      dieu("-i: stdin previously assigned");
                                  stdinassgn = 1;
                              }
#endif
                              O.sfread = 1;
                              break;
                    case 'o': FIND("no outfilename")
                              O.outfilename = filnamp;          /* soundout name */
                              while ((*filnamp++ = *s++)); s--;
                              if (strcmp(O.outfilename,"stdin") == 0)
                                  dieu("-o cannot be stdin");
                              if (strcmp(O.outfilename,"stdout") == 0) 
#if defined __MWERKS__ || defined SYMANTEC || defined BCC || defined __WATCOMC__ || defined __unix || defined WIN32
                                  dieu("stdout audio not supported");
#else
                                  if ((O.stdoutfd = dup(1)) < 0) /* redefine stdout */
                                      die("too many open files");
                                  dup2(2,1);                /* & send 1's to stderr */
#endif
                              break;
                    case 'b': FIND("no iobufsamps")
                              sscanf(s,"%d%n",&O.outbufsamps, &n);
                    /* defaults in musmon.c */
                              O.inbufsamps = O.outbufsamps;
                              s += n;
                              break;
                    case 'B': FIND("no hardware bufsamps")
                              sscanf(s,"%ld%n",&O.oMaxLag, &n);
                    /* defaults in rtaudio.c */
                              s += n;
                              break;
                    case 'A': if (O.filetyp == TYP_WAV) {
                                  if (envoutyp == NULL) goto outtyp;
                                  warning("-A overriding local default WAV out");
                              }
                             if (O.outformat == AE_FLOAT) {
                               warning("Overriding File Type to AIFC for AIFF float format");
                               O.filetyp = TYP_AIFC;
                             }
                             else O.filetyp = TYP_AIFF;     /* AIFF output request*/
                              break;
                    case 'J': if (O.filetyp == TYP_AIFF ||
                                  O.filetyp == TYP_WAV) {
                                if (envoutyp == NULL) goto outtyp;
                                warning("-J overriding local default AIFF/WAV out");
                              }
                              O.filetyp = TYP_IRCAM;      /* WAV output request */
                              break;
                    case 'W': if (O.filetyp == TYP_AIFF) {
                                if (envoutyp == NULL) goto outtyp;
                                warning("-W overriding local default AIFF out");
                              }
                              POLL_EVENTS();
                              O.filetyp = TYP_WAV;      /* WAV output request */
                              break;
                    case 'h': O.sfheader = 0;           /* skip sfheader  */
                              break;
                    case 'c': if (O.outformat) goto outform;
                              outformch = c;
                              O.outformat = AE_CHAR;    /* signed 8-bit char soundfile */
                              break;
                    case 'a': if (O.outformat) goto outform;
                              outformch = c;
                              O.outformat = AE_ALAW;    /* a-law soundfile */
                              break;
                    case 'u': if (O.outformat) goto outform;
                              outformch = c;
                              O.outformat = AE_ULAW;    /* mu-law soundfile */
                              break;
                    case '8': if (O.outformat) goto outform;
                              outformch = c;
                              O.outformat = AE_UNCH;    /* unsigned 8-bit soundfile */
                              break;
                    case 's': if (O.outformat) goto outform;
                              outformch = c;
                              O.outformat = AE_SHORT;   /* short_int soundfile*/
                              break;
                    case 'l': if (O.outformat) goto outform;
                              outformch = c;
                              O.outformat = AE_LONG;    /* long_int soundfile */
                              break;
                    case 'f': if (O.outformat) goto outform;
                              outformch = c;
                              O.outformat = AE_FLOAT;   /* float soundfile */
                              if (O.filetyp == TYP_AIFF) {
                                warning("Overriding File Type to AIFC for float output");
                                O.filetyp = TYP_AIFC;
                              }
                              break;
                    case 'r': FIND("no sample rate")
                              sscanf(s,"%ld",&O.sr_override);
                              while (*++s);
                              break;
                    case 'k': FIND("no control rate")
                              sscanf(s,"%ld",&O.kr_override);
                              while (*++s);
                              break;
                    case 'v': O.odebug = odebug = 1;    /* verbose otran  */
                              break;
                    case 'm': FIND("no message level")
                              sscanf(s,"%d%n",&O.msglevel, &n);
                              s += n;
                              break;
                    case 'd': O.displays = 0;           /* no func displays */
                              break;
                    case 'g': O.graphsoff = 1;          /* don't use graphics */
                              break;
                    case 'G': O.postscript = 1;         /* Postscript graphics*/
                              break;
                    case 'x': FIND("no xfilename")
                              xfilename = s;            /* extractfile name */
                              while (*++s);
                              break;
                    case 't': FIND("no tempo value")
                              sscanf(s,"%d%n",&O.cmdTempo, &n);/* use this tempo .. */
                              s += n;
                              if (O.cmdTempo <= 0) dieu("illegal tempo");
                              O.Beatmode = 1;       /* on uninterpreted Beats */
                              break;
                    case 'L': FIND("no Linein score device_name")
                              O.Linename = filnamp;     /* Linein device name */
                              while ((*filnamp++ = *s++));  s--;
                              if (!strcmp(O.Linename,"stdin")) {
                                  if (stdinassgn)
                                      dieu("-L: stdin previously assigned");
                                  stdinassgn = 1;
                              }
                              O.Linein = 1;
                              break;
                    case 'M': FIND("no midi device_name")
                              O.Midiname = filnamp;     /* Midi device name */
                              while ((*filnamp++ = *s++));  s--;
                              if (!strcmp(O.Midiname,"stdin")) {
                                  if (stdinassgn)
                                      dieu("-M: stdin previously assigned");
                                  stdinassgn = 1;
                                }
                              O.Midiin = 1;
                              break;
                    case 'F': FIND("no midifile name")
                              O.FMidiname = filnamp;    /* Midifile name */
                              while ((*filnamp++ = *s++));  s--;
                              if (!strcmp(O.FMidiname,"stdin")) {
                                  if (stdinassgn)
                                      dieu("-F: stdin previously assigned");
                                  stdinassgn = 1;
                                }
                              O.FMidiin = 1;          /***************/
                              break;
                    case 'P': FIND("no pedal threshold")
                              sscanf(s,"%d%n",&O.SusPThresh, &n);
                              s += n;
                              break;
#ifdef LINUX
                    case 'Q': FIND("no MIDI output device")
                              midi_out = -1;
                              if (isdigit(*s)) {
                                sscanf(s,"%d%n",&midi_out,&n);
                                s += n;
                                openMIDIout();
                              }
                              break;
#endif
                    case 'R': O.rewrt_hdr = 1;
                              break;
                    case 'H': if (isdigit(*s)) {
                                sscanf(s, "%d%n", &O.heartbeat, &n);
                                s += n;
                              }
                              else O.heartbeat = 1;
                              break;
                    case 'N': O.ringbell = 1;        /* notify on completion */
                              break;
                    case 'T': O.termifend = 1;       /* terminate on midifile end */
                              break;
                    case 'D': O.gen01defer = 1;  /* defer GEN01 sample loads 
                                                    until performance time */
                              break;
#ifdef LINUX
#ifdef RTAUDIO
                    /* Add option to set soundcard output volume for real-
                       time audio output under Linux. -- J. Mohr 95 Oct 17 */
                    case 'V': FIND("no volume level")
                              sscanf(s,"%d%n",&O.Volume, &n);
                              s += n;
                              break;
#endif
#endif
                    case 'z': {
                                int full = 0;
                                if (*s != '\0') {
                                  if (isdigit(*s)) full = *s++ - '0';
                                }
                                list_opcodes(full);
                              }
                              return (0);
                    case '-': FIND("no log file");
                              dribble = fopen(s, "w");
                              while (*s++); s--;
                              break;
                    default:  sprintf(errmsg,"unknown flag -%c", c);
                              dieu(errmsg);
                    }
                    POLL_EVENTS();
                }
            }
            else {
                if (orchname == NULL)
                    orchname = --s;
                else if (scorename == NULL)
                    scorename = --s;
                else dieu("too many arguments");
            }
            POLL_EVENTS();
        } while (--argc);

        POLL_EVENTS();
        if (O.Linein || O.Midiin || O.FMidiin)
            O.RTevents = 1;
        if (O.RTevents || O.sfread)
            O.ksensing = 1;
        if (!O.outformat)                       /* if no audioformat yet  */
            O.outformat = AE_SHORT;             /*  default to short_ints */
        O.outsampsiz = getsizformat(O.outformat);
        O.informat = O.outformat; /* informat defaults; resettable by readinheader */
        O.insampsiz = O.outsampsiz;
        if (O.filetyp == TYP_AIFF || O.filetyp == TYP_AIFC || O.filetyp == TYP_WAV) {
            if (!O.sfheader)
                dieu("can't write AIFF/WAV soundfile with no header");
            /* WAVE format supports only unsigned bytes for 1- to 8-bit
               samples and signed short integers for 9 to 16-bit samples.
                                   -- Jonathan Mohr  1995 Oct 17  */
            /* Also seems that type 3 is floats */
            if ((O.filetyp != TYP_AIFC) &&
                (O.outformat == AE_ALAW || O.outformat == AE_ULAW
                 || O.outformat == AE_FLOAT)) 
#ifdef __MWERKS__
                printf("WARNING: %s encoding information cannot\n       be contained in the header...\n", getstrformat(O.outformat));
#else
            {
              sprintf(errmsg,"AIFF/WAV does not support %s encoding",
                      getstrformat(O.outformat));
              dieu(errmsg);
            }
#endif
        }
        POLL_EVENTS();
        if (O.rewrt_hdr && !O.sfheader)
            dieu("can't rewrite header if no header requested");
        if (O.sr_override || O.kr_override) {
            long ksmpsover;
            if (!O.sr_override || !O.kr_override)
                dieu("srate and krate overrides must occur jointly");
            ksmpsover = O.sr_override / O.kr_override;
            if (ksmpsover * O.kr_override != O.sr_override)
                dieu("command-line srate / krate not integral");
        }
        if (orchname == NULL)
            dieu("no orchestra name");
        else err_printf("orchname:  %s\n", orchname);
        if (scorename != NULL)
            err_printf("scorename: %s\n", scorename);
        if (xfilename != NULL)
            err_printf("xfilename: %s\n", xfilename);
#if defined(SYS5) || defined(WIN32)
        {
          static  char  buf[80];
          VMSG(setvbuf(stdout,buf,_IOLBF,80);)
        }
#else
#if !defined(SYMANTEC) && !defined(__MWERKS__) && !defined(LATTICE)
        VMSG(setlinebuf(stdout);)
#endif
#endif
        if (scorename == NULL) {
          if (O.RTevents) {
            err_printf("realtime performance using dummy numeric scorefile\n");
            POLL_EVENTS();
            goto perf;
          }
          else scorename = "score.srt";
        }
        POLL_EVENTS();
#ifdef __MWERKS__
        {
          char *c;
          strcpy(saved_scorename,scorename);
          strcpy((char *)mytitle,scorename);
          c = (char *)&mytitle[0] + strlen((char *)mytitle);
          while (*c != ':' && c != (char *)mytitle) c -= 1;
          if (c != (char *) mytitle) c += 1;
          strcpy((char *)mytitle,c);
          strcat((char *)mytitle," listing");
          SIOUXSetTitle(CtoPstr((char *)mytitle));
        }       
#endif  
        if ((n = strlen(scorename)) > 4            /* if score ?.srt or ?.xtr */
          && (!strcmp(scorename+n-4,".srt")
              || !strcmp(scorename+n-4,".xtr"))) {
            err_printf("using previous %s\n",scorename);
            playscore = sortedscore = scorename;            /*   use that one */
        }
        else {
            if (!(scorin = fopen(scorename, "r")))          /* else sort it   */
                dies("cannot open scorefile %s", scorename);
            if (!(scorout = fopen(sortedscore, "w")))
                dies("cannot open %s for writing", sortedscore);
            err_printf("sorting score ...\n");
            scsort(scorin, scorout);
            fclose(scorin);
            fclose(scorout);
        }
        POLL_EVENTS();
        if (xfilename != NULL) {                        /* optionally extract */
            if (!strcmp(scorename,"score.xtr"))
                dies("cannot extract %s, name conflict",scorename);
            if (!(xfile = fopen(xfilename, "r")))
                dies("cannot open extract file %s", xfilename);
            if (!(scorin = fopen(sortedscore, "r")))
                dies("cannot reopen %s", sortedscore);
            if (!(scorout = fopen(xtractedscore, "w")))
                dies("cannot open %s for writing", xtractedscore);
            err_printf("  ... extracting ...\n");
            scxtract(scorin, scorout, xfile);
            fclose(scorin);
            fclose(scorout);
            playscore = xtractedscore;
        }           
        err_printf("\t... done\n");
        POLL_EVENTS();

        s = playscore;
        O.playscore = filnamp;
        while ((*filnamp++ = *s++));    /* copy sorted score name */

perf:   O.filnamsize = filnamp - O.filnamspace;
        if (POLL_EVENTS()) {
          otran();              /* read orcfile, setup desblks & spaces     */
          if (POLL_EVENTS())
            return musmon();   /* load current orch and play current score */
        }
        return (0);


outtyp: dieu("output soundfile cannot be both AIFF and WAV");

outform: sprintf(errmsg,"sound output format cannot be both -%c and -%c",
                outformch, c);
        dieu(errmsg);
	return (0);
}
#endif /* defined(CSOUND_MAIN) */

#if defined(CSOUND_MAIN)

static void dieu(char *s)
{
        err_printf("Csound Command ERROR:\t%s\n",s);
        usage();
#ifdef __MWERKS__
        die("");
#else
        POLL_EVENTS();
#endif
}

static void usage(void)
{
#ifdef M_I286
err_printf( "See usage.txt\n");
#else
err_printf("Usage:\tcsound [-flags] orchfile scorefile\n");
err_printf( "Legal flags are:\n");
err_printf("-U unam\trun utility program unam\n");
err_printf("-C\tuse Cscore processing of scorefile\n");
err_printf("-I\tI-time only orch run\n");
err_printf("-n\tno sound onto disk\n");
err_printf("-i fnam\tsound input filename\n");
err_printf("-o fnam\tsound output filename\n");
err_printf("-b N\tsample frames (or -kprds) per software sound I/O buffer\n");
err_printf("-B N\tsamples per hardware sound I/O buffer\n");
err_printf("-A\tcreate an AIFF format output soundfile\n");
err_printf("-W\tcreate a WAV format output soundfile\n");
err_printf("-J\tcreate an IRCAM format output soundfile\n");
err_printf("-h\tno header on output soundfile\n");
err_printf("-c\t8-bit signed_char sound samples\n");
err_printf("-a\talaw sound samples\n");
err_printf("-8\t8-bit unsigned_char sound samples\n"); /* J. Mohr 1995 Oct 17 */
err_printf("-u\tulaw sound samples\n");
err_printf("-s\tshort_int sound samples\n");
err_printf("-l\tlong_int sound samples\n");
err_printf("-f\tfloat sound samples\n");
err_printf("-r N\torchestra srate override\n");
err_printf("-k N\torchestra krate override\n");
err_printf("-v\tverbose orch translation\n");
err_printf("-m N\ttty message level. Sum of: 1=note amps, 2=out-of-range msg, 4=warnings\n");
err_printf("-d\tsuppress all displays\n");
err_printf("-g\tsuppress graphics, use ascii displays\n");
err_printf("-G\tsuppress graphics, use Postscript displays\n");
err_printf("-x fnam\textract from score.srt using extract file 'fnam'\n");
err_printf("-t N\tuse uninterpreted beats of the score, initially at tempo N\n");
err_printf("-L dnam\tread Line-oriented realtime score events from device 'dnam'\n");
#if defined(LINUX)
err_printf("-Q N\tselect MIDI interface hardware (0 to n)\n");
#endif /* defined(LINUX) */
err_printf("-M dnam\tread MIDI realtime events from device 'dnam'\n");
err_printf("-F fnam\tread MIDIfile event stream from file 'fnam'\n");
err_printf("-P N\tMIDI sustain pedal threshold (0 - 128)\n");
err_printf("-R\tcontinually rewrite header while writing soundfile (WAV/AIFF)\n");
err_printf("-H#\tprint a heartbeat style 1, 2 or 3 at each soundfile write\n");
err_printf("-N\tnotify (ring the bell) when score or miditrack is done\n");
err_printf("-T\tterminate the performance when miditrack is done\n");
err_printf("-D\tdefer GEN01 soundfile loads until performance time\n");
#ifdef LINUX                    /* Jonathan Mohr  1995 Oct 17 */
#ifdef RTAUDIO
err_printf("-V N\tset real-time audio output volume to N (1 to 100)\n");
#endif
#endif
err_printf("-z\tList opcodes in this version\n");
err_printf("-- fnam\tlog output to file\n");
#ifdef __MWERKS__
err_printf("_____________Macintosh Command Line Flags_________________\n");
/* err_printf("-- fnam\t Redirect output to listing file 'fnam'\n"); */
err_printf("-X fnam\t Sound File Directory\n");
err_printf("-q fnam\t Sound Sample-In Directory\n");
err_printf("-Q fnam\t Analysis Directory\n");
err_printf("-V N\t Number of chars in screen buffer for output window\n");
err_printf("-E N\t Number of tables in graphics window\n");
err_printf("-p\t\t Play after rendering\n");
err_printf("-e\t\t Rescaled floats as shorts to max amplitude\n");
err_printf("-w\t\t Record and Save MIDI input to a file\n");
err_printf("-y N\t Enables Progress Display at rate N seconds,\n");
err_printf("\t\t\tor for negative N, at -N kperiods\n");
err_printf("-Y N\t Enables Profile Display at rate N in seconds,\n");
err_printf("\t\t\tor for negative N, at -N kperiods\n");
err_printf("__________________________________________________________\n");
#endif
err_printf("flag defaults: csound -s -otest -b%d -B%d -m7 -P128\n",
        IOBUFSAMPS, IODACSAMPS);
#endif
        exit(1);
}
#endif /* defined(CSOUND_MAIN) */
/* alphabetically, so i dont have to hunt for a letter next time...
**********************************************************************
-a alaw sound samples
-A create an AIFF format output soundfile
-b N sample frames (or -kprds) per software sound I/O buffer
-B N samples per hardware sound I/O buffer
-c 8-bit signed_char sound samples
-C use Cscore processing of scorefile
-d suppress all displays
-D defer GEN01 soundfile loads until performance time
-e Rescale floats as shorts to max amplitude
-E (was -G) N  Number of tables in graphics window
-f float sound samples
-F fnam read MIDIfile event stream from file 'fnam'
-g suppress graphics, use ascii displays
-G suppress graphics, use Postscript displays
-h no header on output soundfile
-H N print a heartbeat style 1, 2 or 3 at each soundfile write
-i fnam sound input filename
-I I-time only orch run
-j
-J create an IRCAM format output soundfile
-k N orchestra krate override
-K
-l long_int sound samples
-L dnam read Line-oriented realtime score events from device 'dnam'
-m N tty message level. Sum of: 1=note amps, 2=out-of-range msg, 4=warnings
-M dnam read MIDI realtime events from device 'dnam'
-n no sound onto disk
-N notify (ring the bell) when score or miditrack is done
-o fnam sound output filename
-O
-p Play after rendering
-P N MIDI sustain pedal threshold (0 - 128)
-q fnam  Sound Sample-In Directory
-Q fnam  Analysis Directory
-r N orchestra srate override
-R continually rewrite header while writing soundfile (WAV/AIFF)
-s short_int sound samples
-S score is in Scot format
-t N use uninterpreted beats of the score, initially at tempo N
-T terminate the performance when miditrack is done
-u ulaw sound samples
-U unam run utility program unam
-v verbose orch translation
-V N  Number of chars in screen buffer for output window
-w   Record and Save MIDI input to a file
-W create a WAV format output soundfile
-x fnam extract from score.srt using extract file 'fnam'
-X fnam  Sound File Directory
-y N  Enables Profile Display at rate N in seconds,
   or for negative N, at -N kperiods
-Y N  Enables Progress Display at rate N seconds,
   or for negative N, at -N kperiods
-z List opcodes in this version
-Z
-- fnam log output to file (was -y fnam  Redirect output to listing file 'fnam')
-8 8-bit unsigned_char sound samples  J. Mohr 1995 Oct 17 
*/

#if !defined(CSOUND_MAIN)
#ifdef CWIN
int args_OK = 0;
extern void  cwin_poll_window_manager(void);
extern void cwin_args(char **, char **, char **);

void dialog_arguments(void)
{
    cwin_args(&orchname, &scorename, &xfilename);
}
#endif

#ifndef CWIN
#include <stdarg.h>

void dribble_printf(char *fmt, ...)
{
    va_list a;
    va_start(a, fmt);
    vprintf(fmt, a);
    va_end(a);
    if (dribble != NULL) {
      va_start(a, fmt);
      vfprintf(dribble, fmt, a);
      va_end(a);
    }
}

void err_printf(char *fmt, ...)
{
    va_list a;
    va_start(a, fmt);
    vfprintf(stderr, fmt, a);
    va_end(a);
    if (dribble != NULL) {
      va_start(a, fmt); /* gab */
      vfprintf(dribble, fmt, a);
      va_end(a);
    }
}
#endif
#endif /* !defined(CSOUND_MAIN) */
