/*	Granular synthesizer designed and coded by Paris Smaragdis	*/
/*	Berklee College of Music Csound development team		*/
/*	Copyright (c) May 1994.  All rights reserved			*/

/* Some speed hacks added by John Fitch */

#include "cs.h"
#include "grain.h"
#include <stdlib.h>

#ifndef RAND_MAX
#define RAND_MAX	(32767)
#endif

#define	Unirand(a)	(((float)rand() / (float)RAND_MAX) * (a))

void agsset(PGRA *p)			/*	Granular U.G. set-up */
{
    FUNC	*gftp, *eftp;
    long	bufsize;
    float	*d;

    if ((gftp = ftfind(p->igfn)) != NULL)
	p->gftp = gftp;
	
    if ((eftp = ftfind(p->iefn)) != NULL)
	p->eftp = eftp;

    p->lst = 0;

    if (*p->opt == 0)
	p->pr = (float)(gftp->flen << gftp->lobits);

    if (*p->opt != 0)
	p->pr = 0.0f;

    bufsize = sizeof(float)*(2L * (long)(esr * *p->imkglen) +  (3L * ksmps));

    if (p->aux.auxp == NULL || bufsize > p->aux.size)
	auxalloc(bufsize, &p->aux);
    d = p->x = (float *)p->aux.auxp;
    d +=  (int)(esr * *p->imkglen) + ksmps;
    p->y = d;

    p->ampadv = (p->XINCODE & 0x2) ? 1 : 0;
    p->lfradv = (p->XINCODE & 0x1) ? 1 : 0;
    p->dnsadv = (p->XINCODE & 0x4) ? 1 : 0;
}

void ags(PGRA *p)		/*	Granular U.G. a-rate main routine	*/
{
    FUNC	*gtp, *etp;
    float	*buf, *out, *rem, *gtbl, *etbl;
    float	*xdns, *xamp, *xlfr, *temp, amp;
    long	isc, isc2, inc, inc2, lb, lb2;
    long	n, i, bufsize;
    long	ekglen;
    long	lst = p->lst;
				/* Pick up common values to locals for speed */
    if (p->aux.auxp==NULL) {
      initerror("grain: not initialized");
      return;
    }
    gtp = p->gftp;
    gtbl = gtp->ftable;

    etp = p->eftp;
    etbl = etp->ftable;
    lb = gtp->lobits;
    lb2 = etp->lobits;

    buf = p->x;
    rem = p->y;

    out = p->sr;

    if (*p->kglen > *p->imkglen)
	*p->kglen = *p->imkglen;

    ekglen = (long)(esr * *p->kglen); /* Useful constant */
    inc2 = (long)(sicvt / *p->kglen); /* Constant for each cycle */
    bufsize = ksmps + ekglen;
    xdns = p->xdns;
    xamp = p->xamp;
    xlfr = p->xlfr;

    i = bufsize;		/* Clear buffer */
    temp = buf;
    do	*temp++ = 0.0f;
    while (--i);

    for (i = 0 ; i < ksmps ; i++, lst++) {
				/* What happens if *xdns is zero?? */
        if (*xdns<=0.0f) {
          err_printf("WARNING: xdns: zero Density requested\n");
          *xdns = 0.0001f;
	}
        if (lst >= (isc = (long) (esr / *xdns))) lst %= isc;
	xdns += p->dnsadv;

        if (lst == 0) {
            amp = *xamp + Unirand(*p->kabnd);
	    isc = (long) Unirand(p->pr);
	    isc2 = 0;
	    inc = (long) ((*xlfr + Unirand(*p->kbnd)) * sicvt);

	    temp = buf + i;
            n = ekglen;
	    do {
		*temp++ += amp  * *(gtbl + (isc >> lb)) *
		                  *(etbl + (isc2 >> lb2));
		isc  = (isc +inc )&PMASK;
		isc2 = (isc2+inc2)&PMASK;
	    } while (--n);
	}
	xamp += p->ampadv;
	xlfr += p->lfradv;
    }

    n = bufsize;
    temp = rem;
    do {
	*temp = *buf++ + *(temp + ksmps);
	temp++;
    } while (--n);

    n = ksmps;
    do	*out++ = *rem++;
    while (--n);
    p->lst = lst;
}
