/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef _XZX_XSPEC_H
#define _XZX_XSPEC_H
/* $Id: screen.h,v 4.1 1998/01/06 21:21:30 erik Rel $ */
#include <X11/Xlib.h>
#include "config.h"


#define DFILE				16384
#define	ROWS				24
#define	COLS				32
#define	X_PIXELS			(COLS * 8)
#define	Y_PIXELS			(ROWS * 8)
#define BORDER_PIXELS		24
#define BORDER_LINES		BORDER_PIXELS
#define	PIXEL_LENGTH		(X_PIXELS * Y_PIXELS / 8)
#define	ATTR_LENGTH			(ROWS * COLS)
#define	ATTR_OFFSET			PIXEL_LENGTH
#define BORDER_WIDTH		(BORDER_PIXELS * GETCFG(scale))
#define HSize				(X_PIXELS * GETCFG(scale))
#define VSize				(Y_PIXELS * GETCFG(scale))
#define TOP_BORDER			64
#define SCR_LINES			Y_PIXELS
#define BOTTOM_BORDER		56

#define	FLASH				0x80
#define	BRIGHT				0x40
#define	PAPER				0x38
#define	INK					0x07

#define NCOLORS				16
#define	BLACK				0
#define	BLUE				1
#define	RED					2
#define	MAGENTA				3
#define	GREEN				4
#define	CYAN				5
#define	YELLOW				6
#define	WHITE				7
#define	BRIGHT_BLACK		8
#define	BRIGHT_BLUE			9
#define	BRIGHT_RED			10
#define	BRIGHT_MAGENTA		11
#define	BRIGHT_GREEN		12
#define	BRIGHT_CYAN			13
#define	BRIGHT_YELLOW		14
#define	BRIGHT_WHITE		15

extern void ScreenWrite(uns16, uns8);
extern void ScreenUpdateBuffers(void);
extern void ForceScreenRefresh(void);
extern void AttrWrite(uns16, uns8);
extern void DoFlashing(void);
extern void SetBorderColor(uns8);
extern void InitX(int *, char **);
extern void CheckEvents(void);
extern Display *Dpy;
extern void (*ScreenRefresh)(void);
#endif

