/*******************************************************************************
 * Copyright (c) Erik Kunze 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * changed by EKU
 ******************************************************************************/

#ifndef _XZX_CONFIG_H
#define _XZX_CONFIG_H

/* $Id: config.h,v 1.2 1998/02/08 13:54:34 erik Rel $ */

#include <X11/keysym.h>
#include <endian.h>		/* Comment this out if your system doesn't have it! */

/********************************************************************************
 * General configuration
 *******************************************************************************/

/* Where the configuraion files and ROM images are installed */
#ifndef ZXLIBDIR
#define ZXLIBDIR		/usr/local/lib/xzx
#endif

/* Where the binary files are installed */
#ifndef BINDIR
#define BINDIR			/usr/local/bin
#endif

/* Where the manual pages are installed */
#ifndef MANDIR
#define MANDIR			/usr/local/man/man1
#endif

/* Compile with debug code.  You should not define this unless you are searching
   for a bug. */
#undef DEBUG

/* Compile without assert() calls. */
#undef NDEBUG

/* The file emul.c contains the code for the emulation of the Z80, which itself
   is a huge switch statement.  With optimizations turned on, cc needs a huge
   amount of memory in order to compile/optimize this code.  Undefine this
   if you run out of swap space. */
#undef HAVE_ENOUGH_SWAP

/* Compile in the MIT-SHM code.  If you can, do - it speeds things up lots. */
#define MITSHM


/********************************************************************************
 * Common configuration valid for both shareware and registered version
 *******************************************************************************/

/* Define this for Spectrum +3 emulation support. */
#define XZX_PLUS3

/* Define this for Shadow ROM and Microdrive support. */
#define XZX_IF1

/* How many microrives are there (1-8)? */
#define IF1_DRIVES		2

/* Define this for Multiface 128 support.  You need an image of the Multiface
   ROM. */
#undef XZX_MF128

/* Audio support.  Choose the audio support type you want. */

#if defined(sun)
/* Emulate speaker and AY chip via /dev/audio on SunOS/Solaris */
/* NOTE: Simultaneous speaker and AY emulation doesn't work yet */
#define SUN_AUDIO
#define AYCHIP_AUDIO
#endif

/* Emulate AY chip via /dev/dsp (Open-Sound-System only) */
#undef AYCHIP_AUDIO

/* Emulate speaker via direct PC speaker manipulation (PC only) */
#undef PCSPKR_AUDIO

/* Emulate ROM beeps only via X server bell (most platforms) */
#undef XBELL_AUDIO

#if defined(__linux__) && defined(i386)
/* Linux x86 gets the best of both worlds :-) */
#define PCSPKR_AUDIO
#define AYCHIP_AUDIO
#endif

/* Joystick support.  You need Linux/FreeBSD with a joystick driver. */
#undef JOY

/* Emulate ULA delay: slows down emulation but is necessary  */
#define EMULATE_ULA_DELAY

/* Warn if a 48k program accesses ports from the 128K machinery. */
#undef PEDANTIC

/* Define this if you're running XZX on a very fast machine (e.g. DEC Alpha). */
#undef SLOWDOWN

/* Define this to connect I/O ports to stdin, stdout & stderr. */
#undef PSEUDO_IO


/********************************************************************************
 * Configuration valid for the sharware version only
 *******************************************************************************/

/* Compile without support for 1bpp/monochrome X servers. */
#undef EXCLUDE_EXOTIC

/* Compile without support for X pixmaps. */
#define EXCLUDE_PIXMAP

/* Use pseudo line by line drawing (see ChangeLog). */
#define LINE_VIDEO

/* Define this if you run XZX on a X terminal.  XZX works slightly different
   when running on X terminal so it doesn't lose key events. */
#undef X_TERMINAL

/* Define the Key to use as ESCAPE in the OSD's.  Change this if your keyboard
   lacks the ESC key (X11/keysym.h). */
#define ESCAPE			XK_Escape

/* Define this for OffiX drag 'n' drop support.  See http://leb.net/OffiX */
#undef OFFIX_DND


/********************************************************************************
 * Configuration valid for the registered version only
 *******************************************************************************/

/* Printer support. Choose the printer support type you want. */

/* Emulate ZX printer (not supported yet) */
#undef ZX_PRINTER

/* Emulate Interface I printer (not supported yet) */
#undef IF1_PRINTER

/* Emulate +3 centronics printer */
#undef PLUS3_PRINTER

/* Update only parts of screen lines that have changed. */
#define LOWLOW_BANDWIDTH

/* Update only screen lines that have changed. */
#undef LOW_BANDWIDTH


/********************************************************************************
 * Do not change anything below this line
 *******************************************************************************/

/* Byte order of your CPU.  Intel is little-endian, Sparc is big-endian. */
#if !defined(LITTLE_ENDIAN) &&  !defined(BIG_ENDIAN)
#if defined(i386) || defined(add_your_machine_here)
#define LITTLE_ENDIAN
#else
#define BIG_ENDIAN
#endif
#endif

/* Define this if your system lacks the gethostname() function. */
#if defined(SYSV) || defined(SVR4)
#define NEED_UNAME
#endif

/* Define this if your system lacks the str[n]casecmp functions. */
#if defined(SYSV) || defined(SVR4)
#define NEED_STRCASECMP
#endif

/* SunOS 4.x does not provide fpos_t, fsetpos(), or fgetpos() */
#if defined(sun) && !defined(SVR4)
#define NO_FPOS_T
#endif

/* Make sure that the unsigned short type on this machine is 16 bits or the moon
   will explode. */
typedef unsigned char	uns8;
typedef unsigned short	uns16;
typedef unsigned int	uns32;
typedef signed char		sgn8;
typedef signed short	sgn16;
typedef signed int		sgn32;

#define IMC_FLAGS

#if defined(NAS_AUDIO) || defined(AYCHIP_AUDIO) || defined(SUN_AUDIO) || \
						  defined(PCSPKR_AUDIO) || defined(XBELL_AUDIO)
#define AUDIO
#endif

#if defined(XBELL_AUDIO) && (defined(SUN_AUDIO) || defined(PCSPKR_AUDIO))
#ifdef __GNUC__
#error Speaker and X bell together not supported!
#else
#pragma error Speaker and X bell together not supported!
#endif
#endif

#if defined(PCSPKR_AUDIO) && !defined(__linux__)
#ifdef __GNUC__
#error Do not define PCSPKR_AUDIO on non Linux systems!
#else
#pragma error Do not define PCSPKR_AUDIO on non Linux systems!
#endif
#endif

#if defined(NAS_AUDIO) && (defined(AYCHIP_AUDIO) || defined(SUN_AUDIO) || \
						   defined(PCSPKR_AUDIO) || defined(XBELL_AUDIO))
#ifdef __GNUC__
#error Do not define NAS_AUDIO together with another XXX_AUDIO
#else
#pragma error Do not define NAS_AUDIO together with another XXX_AUDIO
#endif
#endif

#if defined(ZX_PRINTER) || defined(IF1_PRINTER) || defined(PLUS3_PRINTER)
#define PRINTER
#endif

#if defined(PLUS3_PRINTER) && !defined(XZX_PLUS3)
#ifdef __GNUC__
#error +3 parallel printer emulation needs basic +3 emulation!
#else
#pragma +3 parallel printer emulation needs basic +3 emulation!
#endif
#endif

#if defined(LOW_BANDWITH) && defined(LOWLOW_BANDWIDTH)
#undef LOW_BANDWIDTH
#endif

#if defined(REGISTERED)
#undef LINE_VIDEO
#else
#undef PRINTER
#undef ZX_PRINTER
#undef IF1_PRINTER
#undef PLUS3_PRINTER
#endif /* REGISTERED */

#endif /* ! _XZX_CONFIG_H */

/* EOF *************************************************************************/
