/*
 * devices.c -- picasm
 */

#include <stdio.h>

#include "picasm.h"

/*
 * This PIC type table is not anywhere near complete...
 * (I don't have full data sheets of all the chips that I have
 * put in this table, so it may contain errors...)
 */

struct pic_type pic_types[] = {
  { "16C52",   384,  0, 0x20, PIC12BIT },
  { "16C54",   512,  0, 0x20, PIC12BIT },
  { "16C55",   512,  0, 0x20, PIC12BIT },
  { "16C56",  1024,  0, 0x20, PIC12BIT },
  { "16C57",  2048,  0, 0x20, PIC12BIT },

  { "16C61",  1024,  0, 0x30, PIC14BIT },         /* RAM 36B  */

  { "16C62",  2048,  0, 0x80, PIC14BIT|PIC_CP2 }, /* RAM 128B */
  { "16C63",  4096,  0, 0x80, PIC14BIT|PIC_CP2 }, /* RAM 192B */
  { "16C64",  2048,  0, 0x80, PIC14BIT|PIC_CP2 }, /* RAM 128B */
  { "16C65",  4096,  0, 0x80, PIC14BIT|PIC_CP2 }, /* RAM 192B */

  { "16C71",  1024,  0, 0x30, PIC14BIT },         /* RAM 36B  */

  { "16C73",  4096,  0, 0x80, PIC14BIT|PIC_CP2 }, /* RAM 192B */
  { "16C74",  4096,  0, 0x80, PIC14BIT|PIC_CP2 }, /* RAM 192B */

  { "16C84",  1024, 64, 0x30, PIC14BIT },         /* RAM 36B  */

  { "16C83",   512, 64, 0x30, PIC14BIT|PIC_CP4|PIC_PWRT_INV },

  { "16C84A", 1024, 64, 0x50, PIC14BIT|PIC_CP4|PIC_PWRT_INV },
  { "16F84",  1024, 64, 0x50, PIC14BIT|PIC_CP4|PIC_PWRT_INV },

  /* RAM 80B (0x20-0x6f) */
  { "16C620",  512,  0, 0x70, PIC14BIT|PIC_CP3|PIC_BOD|PIC_PWRT_INV },
  { "16C621", 1024,  0, 0x70, PIC14BIT|PIC_CP3|PIC_BOD|PIC_PWRT_INV },
  /* RAM 128B (0x20-0x7f,0xa0-0xbf)*/
  { "16C622", 2048,  0, 0x80, PIC14BIT|PIC_CP3|PIC_BOD|PIC_PWRT_INV },

  /* RAM 192B (special case in config.c) */
  { "14000",  4096,  0, 0x80, PIC14BIT },

  { NULL,        0,  0,   0, -1} /* end marker */
};

