/* This file is Copyright 1993 by Clifford A. Adams */
/* sgdata.h
 *
 * Data structures and functions for group scan
 */

/* per-newsgroup data */
typedef struct sg_groupdata {
    char *name;
    char *desc;		/* description of newsgroup */
    long rcnum;		/* index into rc array */
    long flags;
    /* current flag values:  (flags default to 0/FALSE)
     *     1	moderated newsgroup
     *     2	newsgroup's toread[] has been set
     *     4	Attempted to fill description field
     */
} SG_GROUPDATA;

EXT int sg_num_groups		INIT(0);
EXT int sg_groups_alloc		INIT(0);
EXT SG_GROUPDATA *sg_groups	INIT((SG_GROUPDATA*)NULL);

/* if true, have tried to get the newsgroup descriptions and failed */
EXT bool sg_desc_unavail	INIT(FALSE);

/* per-entry data */
/* could be a union, but why bother? */
typedef struct sg_entrydata {
    int  type;
    /* 1: normal newsgroup
     * 2: file
     * 3: restriction list
     * 4: virtual newsgroup
     * 5: text to be paged.
     */
    long flags;
    /* for initial testing, groupnum is newsgroup number */
    long groupnum;		/* index into sg_groups */
    char *name;			/* what to display for the description */
    /* find a better name for the below */
    char *restrict;		/* filename or restriction list */
} SG_ENTRYDATA;

/* note: the 0th entry of sg_ents is unused (scan compatibility) */
EXT int sg_num_ents		INIT(0);
EXT int sg_ents_alloc		INIT(0);
EXT SG_ENTRYDATA *sg_ents	INIT((SG_ENTRYDATA*)NULL);

typedef struct sg_context {
    int  cnum;			/* context number */
    int  num_ents;		/* number of entries */
    int  ents_alloc;		/* number of allocated entries */
    char *title;		/* for this context */
    char *filename;		/* if non-null, is filename of local context */
    char *label;		/* label to start at within filename */
    char *tmpfilename;		/* if non-null, is actual (temp) filename */
    /* add other things like flags later */
    SG_ENTRYDATA *ents;		/* entries */
} SG_CONTEXT;

EXT int sg_num_contexts		INIT(0);
EXT int sg_max_contexts		INIT(0);
EXT SG_CONTEXT *sg_contexts	INIT((SG_CONTEXT*)NULL);

void	sg_init_context	_((void));
void	sg_new_context	_((void));
void	sg_old_context	_((void));

bool	sg_init_ents	_((void));
int	sg_add_ent	_((int,char*));
void	sg_free_ents	_((void));
void	sg_delete_invalid_ents _((void));

void	sg_init_groups	_((void));
void	sg_reinit_groups _((void));
bool	sg_add_ng	_((int));
bool	sg_go_ng	_((char *));
void	sg_toread	_((long,bool_int));
void	sg_allgroups	_((void));
bool	sg_group_desc	_((int));
