# DEXPIRE.CTL
#
# Information from all matching entries are merged, taking
# the lowest equivalent expire time.  So, for example,
# a * entry with a maximum file size of 2m covers ALL
# articles, but a later :m400k match will reduce that.
#
# Expiration is in percentage of best-case and values may
# be between 1 and 100.  At least one entry should have
# an expiration of 100 :-). Most people specify 100 for
# local groups and lesser values for other groups.
#
# You can revert to the old FIFO spool storage mechanism
# simply by specifying a 100 expiration for all groups
# in this file.
#
# directives:
#
#	mSIZE[k,m,g]	specify maximum article size
#
#	sFLOAT		DEPRECIATED, no longer supported.
#
#	cFLOAT		exponential cross posting factor, reduce expire
#			based on number of cross posts.  1.0 == no effect.
#			Specify a number 0.01 to 1.0 inclusive.  Numbers
#			less then 0.50 are typically not specified.
#
#			actual = pow(factor, numgroups)
#
# An expiration of 0 rejects the article entirely.
#
# NOTE! expirations are set for an article when it is
# received, not when dexpire runs.

*:100:c0.95:m2m
alt.*:80
*.advocacy:30
*.test:10

alt.binaries.*:10:m400k
alt.binaries.warez*:1
alt.binaries.mac.games:1
alt.binaries.misc*:2
alt.binaries.games*:1
alt.cracks*:1:m400k
alt.sex*:1:m400k
alt.sex.pictures*:1:m400k
#
# control
#
control:5

# permanent, semi-permanent, local groups
#
best.*:100

