
/*
 * LIB/SIGS.C
 *
 * (c)Copyright 1997, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution 
 *    for specific rights granted.
 */

#include "defs.h"

Prototype void rsignal(int sigNo, void (*func)(int sigNo));

void 
rsignal(int sigNo, void (*func)(int sigNo))
{
    struct sigaction sa = { 0 };

#ifndef SUNOS
    sa.sa_flags = SA_RESTART;	/* do not set SA_RESETHAND */
#endif
    sa.sa_handler = func;
    sigaddset(&sa.sa_mask, sigNo);

    if (sigaction(sigNo, &sa, NULL) < 0) {
	perror("sigaction");
	exit(1);
    }
}

