#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <savant.h>

size_t
fwrite_big(void *ptr, size_t size, size_t num, FILE *stream)
{
#if (WORDS_BIGENDIAN == 0)
  unsigned char *big = malloc(size*num);
  int i, j;
  size_t out;

  for(i=0; i<num; i++) {
    for(j=0; j<size; j++) {
      big[size*i + (size-1-j)] = ((unsigned char *) ptr)[size*i + j];
    }
  }
  
  out = fwrite((void *)big, size, num, stream);
  free(big);
  return(out);

#else
  return(fwrite(ptr, size, num, stream));

#endif
}

size_t
fread_big(void *ptr, size_t size, size_t num, FILE *stream)
{
#if (WORDS_BIGENDIAN == 0)
  unsigned char *big = malloc(size*num);
  int i, j;
  size_t out;

  out = fread((void *)big, size, num, stream);

  for(i=0; i<num; i++) {
    for(j=0; j<size; j++) {
      ((unsigned char *)ptr)[size*i + (size-1-j)] = big[size*i + j];
    }
  }
  
  free(big);
  return(out);

#else
  return(fread(ptr, size, num, stream));

#endif
}

