/************************************************************************/
/* Module : tooltip.c					                */
/* Purpose: tooltip module              	                        */
/* By     : Keith R. Davis					        */
/* Date   : 6/10/97					                */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software                    */
/*          Some of this code was lifted from a snippet w/ no author    */
/************************************************************************/

#include <Mrm/MrmAppl.h>

static Widget sTooltipPopup = NULL;
static Widget sFrame = NULL;
static Widget sLabel = NULL;
static XmFontList sFontList;

#define BORDER 2

/************************************************************************/
/* Function: InitializeTooltip                                          */
/* Purpose : inits the tooltip shell                                    */
/* Params  : display   : app's shell display 		                */
/*	     className : app's classname 	                        */
/* Returns : nothing			                                */
/************************************************************************/

void InitializeTooltip (Display *display, char *className)
{
  sTooltipPopup = XtVaAppCreateShell ("tooltip", className,
				      applicationShellWidgetClass,
                                      display,
                                      XmNoverrideRedirect, True,
                                      NULL);
  sFrame = (Widget) XmCreateFrame (sTooltipPopup, "frame", NULL, 0);
  XtVaSetValues (sFrame, XmNshadowThickness, 0,
		 XmNborderWidth, 1,
                 XmNmarginWidth, BORDER,
                 XmNmarginHeight, BORDER, NULL);
  sLabel = (Widget) XmCreateLabel (sFrame, "label", NULL, 0);
  XtVaGetValues (sLabel,                                                   
		 XmNfontList, &sFontList,
		 NULL);
  XtManageChild (sFrame);
  XtManageChild (sLabel);
  return;
}

/************************************************************************/
/* Function: PopdownTooltip                				*/
/* Purpose : removes the tooltip window                                 */
/* Params  : none                                                       */
/* Returns : nothing			                                */
/************************************************************************/

void PopdownTooltip (Widget w, XtPointer clientdata, XtPointer callData)
{
  XtPopdown (sTooltipPopup);
  return;
}

/************************************************************************/
/* Function: PopupTooltip                      			        */
/* Purpose : displays the tooltip window                         	*/
/* Params  : button : widget displaying tooltip                         */
/* Returns : nothing			                                */
/************************************************************************/

void PopupTooltip (Widget button)
{
  XmString labelString = NULL;
  Dimension labelWidth = 0;
  Dimension labelHeight = 0;
  Dimension height = 0;
  Position root_x = 0;
  Position root_y = 0;
  
  XtVaGetValues (button, XmNlabelString, &labelString,
		 XmNheight, &height, NULL);
  XtVaSetValues (sLabel, XmNlabelString, labelString, NULL);
  labelWidth  = XmStringWidth  (sFontList, labelString);
  labelHeight = XmStringHeight (sFontList, labelString);
  XtTranslateCoords (button, (Position) 0, (Position) 0,
		     &root_x, &root_y);
  XtVaSetValues (sTooltipPopup,
		 XmNx,      root_x,
		 XmNy,      root_y + height,
		 XmNwidth,  labelWidth + (BORDER * 2 + 2),
		 XmNheight, labelHeight + (BORDER + 4),
		 NULL);
  XtAddCallback (button, XmNdestroyCallback, PopdownTooltip, NULL);
  XtPopup (sTooltipPopup, XtGrabNone);
}

