/************************************************************************/
/* Module : mquel.c					                */
/* Purpose: motif SQL / query tool for PostgresSQL	                */
/* By     : Keith R. Davis				                */
/* Date   : 12/8/95					                */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software	                */
/************************************************************************/

#include <Xm/Xm.h>		/* motif lib header		*/
#include <Xm/Protocols.h>       /* motif protocol header        */
#include <Xm/PrimitiveP.h>      /* motif primitive widget head. */
#include <Xm/PushB.h>		/* push button widget header	*/
#include <Xm/MainW.h>		/* main window widget header	*/
#include <Xm/PanedW.h>		/* paned window widget header	*/
#include <Xm/ScrolledW.h>       /* scrolled window widget head. */
#include <Xm/ScrollBar.h>       /* scrollbar widget header      */
#include <Xm/Form.h>		/* form widget header	        */
#include <Xm/Frame.h>           /* frame widget header          */
#include <Xm/Label.h>		/* label widget header		*/
#include <Xm/Text.h>		/* text widget header		*/
#include <stdio.h>              /* stdio header                 */ 
#include <stdlib.h>             /* stdlib header                */
#include <unistd.h>             /* unix std header              */
#include <contexthelp.h>        /* help lib header              */
#include <help.h>               /* help lib header              */

#include "textBuf.h"            /* text widget headers          */
#include "textSel.h"
#include "text.h"
#include "textDisp.h"
#include "textP.h"
#include "window.h"
#include "highlight.h"
#include "highlightData.h"

#include "xutil.h"              /* X utils header               */
#include "msgbox.h"             /* message box header           */
#include "imageutil.h"          /* image header                 */
#include "pixmap.h"             /* button bar icons             */
#include "mquel.h"              /* mquel header                 */
#include "callback.h"           /* callback header              */
#include "menu.h"		/* menu header		        */
#include "llist.h"              /* linked list header           */
#include "util.h"               /* util function header         */
#include "db.h"                 /* db header                    */
#include "tooltip.h"            /* tooltip header               */

#define CFG_BUFFER_SZ    1024   /* config file read buffer size */
#define CFG_DELIMITER    "\t"   /* config file rec delimiter    */
#define CFG_COMMENT_CHAR "#"    /* config file comment char     */   

#ifdef TOOLTIP
#define  SHOWLBL 0
#else
#define  SHOWLBL 1
#endif

/* global widget handle */
MQUELwidgets AppWidgets;
MQUELwidgets *AppWidgetsPtr = &AppWidgets;

/* global text widget options */
WindowInfo WinData;           
WindowInfo *WinDataPtr = &WinData;
WindowInfo *WindowList = &WinData;

/* tooltip actions and translations */
#ifdef TOOLTIP
XtActionsRec actions[] = {
  { "PopupTooltip",        (XtActionProc) PopupTooltip   },
  { "PopdownTooltip",      (XtActionProc) PopdownTooltip },
};
char transTable[] = "#<EnterWindow>:PopupTooltip()\n<LeaveWindow>:PopdownTooltip()";
XtTranslations toolTrans;
#endif

/* Main: entry point */
void main (int argc, char **argv)
{
    int		   status;		            /* function return status		*/
    int            args;                            /* cmd line arg flag                */
    Atom           WM_DELETE_WINDOW;                /* delete window atom               */
    int            display_depth;                   /* depth of  X display              */
    XFontStruct    *font;                           /* X font struct                    */
 
    /* process cmd line */
    args = MQUEL_GetCmdLineArg(argc, argv);

    /* setup the shell widget */
    AppWidgets.shell = XtVaAppInitialize(&app, "Mpsql", NULL, 0,
					 &argc, argv, NULL,
					 XmNdeleteResponse, XmDESTROY,
					 NULL);
#ifdef TOOLTIP
    InitializeTooltip (XtDisplay(AppWidgets.shell),"Mpsql");
#endif

    /* register wm protocol callback func. */
    WM_DELETE_WINDOW = XInternAtom(XtDisplay(AppWidgets.shell),
				   "WM_DELETE_WINDOW", FALSE);

    /* add callback for protocol */
    XmAddWMProtocolCallback(AppWidgets.shell, WM_DELETE_WINDOW,
			    DeleteWindowCallback, NULL);
    
    /* setup the mainwindow widget */
    AppWidgets.mainwindow = XtCreateManagedWidget("main",xmMainWindowWidgetClass,
						  AppWidgets.shell, NULL, 0);
#ifdef COLOR_PIXMAPS
    /* check color depth */
    if((display_depth = DefaultDepthOfScreen(XtScreen(AppWidgets.mainwindow))) < 16) {
      fprintf(stderr, "Display depth: %dbpp  You need X to be running at least 16bpp w/ color pixmaps.\n",
	      display_depth);
      exit(0);
    }
#endif

    /* setup the button bar widget */
    AppWidgets.btnbar = XtCreateManagedWidget("btnbar", xmFormWidgetClass, 
					      AppWidgets.mainwindow, NULL, 0);

    /* setup the new file btn */
    AppWidgets.btn_new = XtVaCreateManagedWidget("btnnew",
						 xmPushButtonWidgetClass,
						 AppWidgets.btnbar,
						 XmNtopAttachment, XmATTACH_FORM,
						 XmNtopOffset, 5,
						 XmNbottomAttachment, XmATTACH_NONE,
						 XmNleftAttachment, XmATTACH_FORM,
						 XmNleftOffset, 5,
						 XmNrightAttachment, XmATTACH_NONE,
						 NULL);

    /* set button image */
    InstallLabeledPixmap(AppWidgets.btn_new, new_xpm, SHOWLBL);

    /* add callback for the new btn */
    XtAddCallback(AppWidgets.btn_new, XmNactivateCallback,
		  NewCallback, NULL);

    /* add help callback for the new btn */
    XtAddCallback(AppWidgets.btn_new, XmNhelpCallback,
		  get_help, "mpsql_toolbar.html");

    /* setup the open file btn */
    AppWidgets.btn_open = XtVaCreateManagedWidget("btnopen",
						  xmPushButtonWidgetClass,
						  AppWidgets.btnbar,
						  XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
						  XmNtopWidget, AppWidgets.btn_new,
						  XmNbottomAttachment,
						  XmATTACH_OPPOSITE_WIDGET,
						  XmNbottomWidget, AppWidgets.btn_new,
						  XmNleftAttachment, XmATTACH_WIDGET,
						  XmNleftWidget, AppWidgets.btn_new,
						  XmNrightAttachment, XmATTACH_NONE, 
						  NULL);
    /* set button image */
    InstallLabeledPixmap(AppWidgets.btn_open, open_xpm, SHOWLBL);

     /* add callback for open file btn */
    XtAddCallback(AppWidgets.btn_open, XmNactivateCallback,
		  OpenCallback, NULL);

    /* add help callback for the file btn */
    XtAddCallback(AppWidgets.btn_open, XmNhelpCallback,
		  get_help, "mpsql_toolbar.html");

    /* setup the save file btn */
    AppWidgets.btn_save = XtVaCreateManagedWidget("btnsave",
						  xmPushButtonWidgetClass,
						  AppWidgets.btnbar,
						  XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
						  XmNtopWidget, AppWidgets.btn_new,
						  XmNbottomAttachment,
						  XmATTACH_OPPOSITE_WIDGET,
						  XmNbottomWidget, AppWidgets.btn_new,
						  XmNleftAttachment, XmATTACH_WIDGET,
						  XmNleftWidget, AppWidgets.btn_open,
						  XmNrightAttachment, XmATTACH_NONE, 
						  NULL);
    /* set button image */
    InstallLabeledPixmap(AppWidgets.btn_save, save_xpm, SHOWLBL);

    /* add callback for the save btn */
    XtAddCallback(AppWidgets.btn_save, XmNactivateCallback,
		  SaveCallback, NULL);

    /* add help callback for the save btn */
    XtAddCallback(AppWidgets.btn_save, XmNhelpCallback,
		  get_help, "mpsql_toolbar.html");

    /* setup the print file btn */
    AppWidgets.btn_print = XtVaCreateManagedWidget("btnprint",
						    xmPushButtonWidgetClass,
						    AppWidgets.btnbar,
						    XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
						    XmNtopWidget, AppWidgets.btn_new,
						    XmNbottomAttachment,
						    XmATTACH_OPPOSITE_WIDGET,
						    XmNbottomWidget, AppWidgets.btn_new,
						    XmNleftAttachment, XmATTACH_WIDGET,
						    XmNleftWidget, AppWidgets.btn_save,
						    XmNrightAttachment, XmATTACH_NONE, 
						    NULL);
    /* set button image */
    InstallLabeledPixmap(AppWidgets.btn_print, print_xpm, SHOWLBL);

    /* add callback for the print btn */
    XtAddCallback(AppWidgets.btn_print, XmNactivateCallback,
		  PrintCallback, NULL);

    /* add help callback for the print btn */
    XtAddCallback(AppWidgets.btn_print, XmNhelpCallback,
		  get_help, "mpsql_toolbar.html");

    /* setup the execute SQL btn */
    AppWidgets.btn_exe = XtVaCreateManagedWidget("btnexe",
						    xmPushButtonWidgetClass,
						    AppWidgets.btnbar,
						    XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
						    XmNtopWidget, AppWidgets.btn_new,
						    XmNbottomAttachment,
						    XmATTACH_OPPOSITE_WIDGET,
						    XmNbottomWidget, AppWidgets.btn_new,
						    XmNleftAttachment, XmATTACH_WIDGET,
						    XmNleftWidget, AppWidgets.btn_print,
						    XmNrightAttachment, XmATTACH_NONE, 
						    NULL);
    /* set button image */
    InstallLabeledPixmap(AppWidgets.btn_exe, execute_xpm, SHOWLBL);

    /* add callback for execute SQL btn */
    XtAddCallback(AppWidgets.btn_exe, XmNactivateCallback,
		  ExecSQLCallback, NULL);

    /* add help callback for the execute SQL btn */
    XtAddCallback(AppWidgets.btn_exe, XmNhelpCallback,
		  get_help, "mpsql_toolbar.html");

    /* setup the spool results btn */
    AppWidgets.btn_spool = XtVaCreateManagedWidget("btnspool",
						    xmPushButtonWidgetClass,
						    AppWidgets.btnbar,
						    XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
						    XmNtopWidget, AppWidgets.btn_new,
						    XmNbottomAttachment,
						    XmATTACH_OPPOSITE_WIDGET,
						    XmNbottomWidget, AppWidgets.btn_new,
						    XmNleftAttachment, XmATTACH_WIDGET,
						    XmNleftWidget, AppWidgets.btn_exe,
						    XmNrightAttachment, XmATTACH_NONE, 
						    NULL);
    /* set button image */
    InstallLabeledPixmap(AppWidgets.btn_spool, spool_xpm, SHOWLBL);

    /* add callback for spool SQL btn */
    XtAddCallback(AppWidgets.btn_spool, XmNactivateCallback,
		  SpoolCallback, NULL);
   
    /* add help callback for the spool btn */
    XtAddCallback(AppWidgets.btn_spool, XmNhelpCallback,
		  get_help, "mpsql_toolbar.html");

    /* setup the db connect btn */
    AppWidgets.btn_connect = XtVaCreateManagedWidget("btnconnect",
						    xmPushButtonWidgetClass,
						    AppWidgets.btnbar,
						    XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
						    XmNtopWidget, AppWidgets.btn_new,
						    XmNbottomAttachment,
						    XmATTACH_OPPOSITE_WIDGET,
						    XmNbottomWidget, AppWidgets.btn_new,
						    XmNleftAttachment, XmATTACH_WIDGET,
						    XmNleftWidget, AppWidgets.btn_spool,
						    XmNrightAttachment, XmATTACH_NONE, 
						    NULL);
    /* set button image */
    InstallLabeledPixmap(AppWidgets.btn_connect, connect_xpm, SHOWLBL);

    /* add callback for the connect btn */
    XtAddCallback(AppWidgets.btn_connect, XmNactivateCallback,
		  ConnectCallback, NULL);

    /* add help callback for the connect btn */
    XtAddCallback(AppWidgets.btn_connect, XmNhelpCallback,
		  get_help, "mpsql_toolbar.html");

#ifdef TOOLTIP
    XtAppAddActions(app, actions, XtNumber(actions));
    toolTrans = XtParseTranslationTable(transTable);
    XtOverrideTranslations(AppWidgets.btn_new, toolTrans);
    XtOverrideTranslations(AppWidgets.btn_open, toolTrans);
    XtOverrideTranslations(AppWidgets.btn_save, toolTrans);
    XtOverrideTranslations(AppWidgets.btn_print, toolTrans);
    XtOverrideTranslations(AppWidgets.btn_exe, toolTrans);
    XtOverrideTranslations(AppWidgets.btn_spool, toolTrans);
    XtOverrideTranslations(AppWidgets.btn_connect, toolTrans);
#endif


    /* setup the paned widget */
    AppWidgets.pane = XtVaCreateManagedWidget("pane",
					      xmPanedWindowWidgetClass,
					      AppWidgets.mainwindow,
					      XmNsashHeight, 8,
					      NULL);

    /* setup the SQL window */
    /*AppWidgets.sqlwindow = XmCreateScrolledText(AppWidgets.pane, "sqlwindow", NULL, 0);*/
    AppWidgets.sqlwindow = MQUEL_CreateSqlTextArea(AppWidgets.pane);
    XtManageChild(AppWidgets.sqlwindow);
    /*XtVaSetValues(AppWidgets.sqlwindow,
		  XmNeditMode, XmMULTI_LINE_EDIT,
		  NULL);*/

    /* add callback for the SQL window */
    /*XtAddCallback(AppWidgets.sqlwindow, XmNmodifyVerifyCallback,
		  TextModifiedCallback, NULL);*/

    /* add help callback for the SQL window */
    /*XtAddCallback(AppWidgets.sqlwindow, XmNhelpCallback,
		  get_help, "mpsql_edit.html");*/
   
    /* setup the result window */
    AppWidgets.resultwindow = MQUEL_CreateResultTextArea(AppWidgets.pane);
   
    /* add help callback for the results window */
    /*XtAddCallback(AppWidgets.resultwindow, XmNhelpCallback,
		  get_help, "mpsql_output.html");*/

    /* create the menu */
    AppWidgets.menu = CreateMenuBar(AppWidgets.mainwindow);

    /* create the message label's frame */
    AppWidgets.msgframe = XtVaCreateManagedWidget("msgframe",
						  xmFrameWidgetClass,
						  AppWidgets.mainwindow,
						  XmNshadowType, XmSHADOW_ETCHED_IN,
						  NULL);
    
    /* create the message window */
    AppWidgets.message = XtVaCreateManagedWidget("message",
						 xmLabelWidgetClass,
						 AppWidgets.msgframe,
						 XmNmarginHeight, 4,
						 XmNmarginWidth, 4,
						 XmNalignment, XmALIGNMENT_BEGINNING,
						 NULL);

    /* set work areas for the main window */
    XtVaSetValues(AppWidgets.mainwindow,
		  XmNmenuBar, AppWidgets.menu,
		  XmNcommandWindow, AppWidgets.btnbar,
		  XmNworkWindow, AppWidgets.pane,
		  XmNmessageWindow, AppWidgets.msgframe,
		  XmNshowSeparator, FALSE,
		  NULL);

    /* set app's icon */
    SetupIcon(AppWidgets.shell, icon_xpm);

    /* get saved app options */
    MQUEL_GetOptions();

    /* setup the sqlwindow data */

    /* load default highlight styles */
    if(!LoadStylesString(NULL)){
      fprintf(stderr, "Error: Cannot create default highlight styles.\n"); 
      LLIST_Remove();
      exit(-1);
    }

    /* load default highlight modes */
    if(!LoadLanguageModesString(NULL)){
      fprintf(stderr, "Error: Cannot create default highlight modes.\n"); 
      LLIST_Remove();
      exit(-1);
    }

    font = XLoadQueryFont(XtDisplay(AppWidgets.shell), "-*-courier-medium-r-*-*-14-*-*-*-*-*-*-*");

    WinData.next = NULL;
    WinData.shell = AppWidgets.shell;
    WinData.textArea = AppWidgets.sqlwindow;
    WinData.highlightSyntax = False;
    WinData.highlightData = NULL;
    WinData.buffer = NULL;
    WinData.languageMode = 0; /* 0 = SQL-mode, -1 = PLAIN_LANGUAGE_MODE */
    WinData.nPanes = 0;
    WinData.fontList = XmFontListCreate(font, XmSTRING_DEFAULT_CHARSET);
    WinData.italicFontStruct = 
      XLoadQueryFont(XtDisplay(AppWidgets.shell), "-*-courier-medium-i-*-*-14-*-*-*-*-*-*-*");
    WinData.boldFontStruct =
      XLoadQueryFont(XtDisplay(AppWidgets.shell), "-*-courier-bold-r-*-*-14-*-*-*-*-*-*-*");
    WinData.boldItalicFontStruct =
      XLoadQueryFont(XtDisplay(AppWidgets.shell), "-*-courier-bold-i-*-*-14-*-*-*-*-*-*-*");
 
    /* init dummy node */
    empty_buffer.filename = "";
    empty_buffer.buffer = BufCreate();
    BufAddModifyCB(empty_buffer.buffer, SyntaxHighlightModifyCB, WinDataPtr);
    BufAddModifyCB(empty_buffer.buffer, TextModifiedCallback, NULL);

    /* initialize the buffer list */
    if(LLIST_Init() == NULL){
      fprintf(stderr, "Error: Out of memory.\n");
      exit(-1);
    }

    /* add the scratch buffer to the buffer list */
    if((buffer_curr = DB_OpenScratchBuffer()) == NULL){
      fprintf(stderr, "Error: Out of memory.\n"); 
      LLIST_Remove();
      exit(-1);
    }

    /* start the application */
    XtRealizeWidget(AppWidgets.shell);

    /* set the default scratch buffer as the current buffer */
    buffer_curr = DB_SetBuffer(buffer_curr);

    /* startup according to cmd args */
    if(args && !user_prompt) 
      DB_Connect();
    else if(args && user_prompt)
      ConnectCallback(NULL, NULL, NULL);

    /* redirect stderr so explain qy results go to the result window */
    DB_TrapStderr();

    XtAppMainLoop(app);
}

/************************************************************************/
/* Function: MQUEL_CreateSqlTextArea                                    */
/* Purpose : sets up the text widget for the SQL window                 */
/* Params  :                                                            */
/* Returns : text widget                                                */
/* Notes   :                                                            */
/************************************************************************/

Widget MQUEL_CreateSqlTextArea(Widget parent)
{
    Widget text, sw, hScrollBar, vScrollBar;
        
    /* Create a text widget inside of a scrolled window widget */
    sw = XtVaCreateManagedWidget("sqlScrolledW", xmScrolledWindowWidgetClass,
				 parent,
				 XmNscrolledWindowMarginHeight, 3,
				 XmNscrolledWindowMarginWidth, 3,
				 XmNspacing, 4,
				 XmNshadowThickness, 2,
				 XmNhighlightThickness, 1, 
				 NULL); 

    hScrollBar = XtVaCreateManagedWidget("sqlHorScrollBar",
    	    xmScrollBarWidgetClass, sw, XmNorientation, XmHORIZONTAL, 
    	    XmNrepeatDelay, 10, NULL);

    vScrollBar = XtVaCreateManagedWidget("sqlVertScrollBar",
    	    xmScrollBarWidgetClass, sw, XmNorientation, XmVERTICAL,
    	    XmNrepeatDelay, 10, NULL);

    text = XtVaCreateManagedWidget("sqlwindow", textWidgetClass, sw,
				   textNhScrollBar, hScrollBar, 
				   textNvScrollBar, vScrollBar,
				   textNautoWrap, 0,
				   textNcontinuousWrap, 0,
				   textNemulateTabs, 4,
				   NULL);

    XtVaSetValues(sw, XmNworkWindow, text, XmNhorizontalScrollBar, hScrollBar,
    	    XmNverticalScrollBar, vScrollBar, NULL);

    return text;
}

/************************************************************************/
/* Function: MQUEL_CreateResultTextArea                                 */
/* Purpose : sets up the text widget for the result window              */
/* Params  :                                                            */
/* Returns : text widget                                                */
/* Notes   :                                                            */
/************************************************************************/

Widget MQUEL_CreateResultTextArea(Widget parent)
{
    Widget text, sw, hScrollBar, vScrollBar;
       
    /* Create a text widget inside of a scrolled window widget */
    sw = XtVaCreateManagedWidget("ResultScrolledW", xmScrolledWindowWidgetClass,
				 parent,
				 XmNscrolledWindowMarginHeight, 3,
				 XmNscrolledWindowMarginWidth, 3,
				 XmNspacing, 4,
				 XmNshadowThickness, 2,
				 XmNhighlightThickness, 1, 
				 NULL); 

    hScrollBar = XtVaCreateManagedWidget("resultHorScrollBar",
    	    xmScrollBarWidgetClass, sw, XmNorientation, XmHORIZONTAL, 
    	    XmNrepeatDelay, 10, NULL);

    vScrollBar = XtVaCreateManagedWidget("resultVertScrollBar",
    	    xmScrollBarWidgetClass, sw, XmNorientation, XmVERTICAL,
    	    XmNrepeatDelay, 10, NULL);

    text = XtVaCreateManagedWidget("resultwindow", textWidgetClass, sw,
				   textNhScrollBar, hScrollBar, 
				   textNvScrollBar, vScrollBar,
				   textNautoWrap, 0,
				   textNcontinuousWrap, 0,
				   textNreadOnly, 1,
				   NULL);

    XtVaSetValues(sw, XmNworkWindow, text, XmNhorizontalScrollBar, hScrollBar,
    	    XmNverticalScrollBar, vScrollBar, NULL);

    return text;
}

/************************************************************************/
/* Function: MQUEL_GetOptions                                           */
/* Purpose : gets app options from setup file                           */
/* Params  :                                                            */
/* Returns : 1 on SUCCESS / 0 on FAILURE                                */
/* Notes   :                                                            */
/************************************************************************/

int MQUEL_GetOptions(void)
{
  FILE *optf;
  char *token;
  char home[MAX_PATH_LEN];    
  char db_msg[ERR_MSG_SIZE];
  char buffer[CFG_BUFFER_SZ];
  char key_buffer[30];
  char val_buffer[255];

  strcat(strcpy(home, getenv("HOME")), "/.mpsql_cfg");

  if((optf = fopen(home, "r")) != NULL){
    
    while(fgets(buffer, CFG_BUFFER_SZ, optf) != NULL) {
      if(strstr(buffer, CFG_COMMENT_CHAR) == '\0'){ 
	if((token = strtok(buffer, CFG_DELIMITER)) != NULL)        
	  strcpy(key_buffer, doubleTrim(token));
	if((token = strtok(NULL, CFG_DELIMITER)) != NULL)   
	  strcpy(val_buffer, doubleTrim(token));

	if(strcmp("VERSION", key_buffer) == 0){}
	if(strcmp("DATABASE", key_buffer) == 0)
	  if(dbname[0] == '\0')
	    strcpy(dbname, val_buffer);
	if(strcmp("HOST", key_buffer) == 0)
	  if(host[0] == '\0')
	    strcpy(host, val_buffer);
	if(strcmp("PORT", key_buffer) == 0)
	  if(port[0] == '\0')
	    strcpy(port, val_buffer);
	if(strcmp("PRINTER", key_buffer) == 0)
	  strcpy(printer, val_buffer);
	if(strcmp("SPOOL_FILE", key_buffer) == 0)
	  strcpy(spool_file, val_buffer); 
	if(strcmp("SYNTAX_HIGHLIGHT", key_buffer) == 0)
	  SetHighlight(atoi(val_buffer));
	if(strcmp("COLUMN_SEP", key_buffer) == 0)
	  SetColSeparator(atoi(val_buffer));
	if(strcmp("OUTPUT_ALIGN", key_buffer) == 0)
	  SetAlignment(atoi(val_buffer));
	if(strcmp("OUTPUT_TYPE", key_buffer) == 0)
	  SetType(atoi(val_buffer));
	if(strcmp("SPOOL_RESULTS", key_buffer) == 0)
	  XmToggleButtonSetState(AppWidgetsPtr->tglspool, atoi(val_buffer), TRUE);
	if(strcmp("SHOW_HEADINGS", key_buffer) == 0)
	  XmToggleButtonSetState(AppWidgetsPtr->tglcol, atoi(val_buffer), TRUE);
	if(strcmp("ECHO_QUERY", key_buffer) == 0)
	  XmToggleButtonSetState(AppWidgetsPtr->tglecho, atoi(val_buffer), TRUE);
      }
    }

    if(fclose(optf) != 0){
      sprintf(db_msg, "Error closing options file:\n%s", home);
      MSGBOX_Error("Get Options", db_msg, AppWidgetsPtr->mainwindow);
      return 0;
    }
    return 1;
  }
  else{
   strcpy(dbname, "template1");
   strcpy(host, "localhost");
   strcpy(port, "5432");
   strcpy(printer, "lpr");
   strcpy(spool_file, "/tmp/spool.txt");
   SetHighlight(1);
   SetColSeparator(SPACE);
   SetAlignment(0);
   SetType(0);
   return 0;
  }
}

/************************************************************************/
/* Function: MQUEL_SaveOptions                                          */
/* Purpose : saves app options to setup file                            */
/* Params  :                                                            */
/* Returns : 1 on SUCCESS / 0 on FAILURE                                */
/* Notes   :                                                            */
/************************************************************************/

int MQUEL_SaveOptions(void)
{
  FILE *optf;
  char home[MAX_PATH_LEN];  
  char db_msg[ERR_MSG_SIZE];   

  strcat(strcpy(home, getenv("HOME")), "/.mpsql_cfg");

  if((optf = fopen(home, "w+")) == NULL){
    sprintf(db_msg, "Error opening options file:\n%s", home);
    MSGBOX_Error("Save Options", db_msg, AppWidgetsPtr->mainwindow);
    return 0;
  }

  XUTIL_BeginWait(AppWidgetsPtr->mainwindow);

  fprintf(optf, "#############################################\n");
  fprintf(optf, "# MPSQL Configuration File - DO NOT MODIFY! #\n");
  fprintf(optf, "#############################################\n");
  fprintf(optf, "VERSION\t\t\t%s\n", MPSQL_VERSION);
  fprintf(optf, "DATABASE\t\t%s\n", dbname);
  fprintf(optf, "HOST\t\t\t%s\n", host, optf);
  fprintf(optf, "PORT\t\t\t%s\n", port, optf);
  fprintf(optf, "PRINTER\t\t\t%s\n", printer, optf);
  fprintf(optf, "SPOOL_FILE\t\t%s\n", spool_file, optf);
  fprintf(optf, "SYNTAX_HIGHLIGHT\t%d\n", GetHighlight());
  fprintf(optf, "COLUMN_SEP\t\t%d\n", GetColSeparatorId());
  fprintf(optf, "OUTPUT_ALIGN\t\t%d\n", GetAlignment());
  fprintf(optf, "OUTPUT_TYPE\t\t%d\n", GetType());
  fprintf(optf, "SPOOL_RESULTS\t\t%d\n", XmToggleButtonGetState(AppWidgetsPtr->tglspool));
  fprintf(optf, "SHOW_HEADINGS\t\t%d\n", XmToggleButtonGetState(AppWidgetsPtr->tglcol));
  fprintf(optf, "ECHO_QUERY\t\t%d\n", XmToggleButtonGetState(AppWidgetsPtr->tglecho));

  fflush(optf);

  XUTIL_EndWait(AppWidgetsPtr->mainwindow);

  if(fclose(optf) != 0){
    sprintf(db_msg, "Error closing options file:\n%s", home);
    MSGBOX_Error("Save Options", db_msg, AppWidgetsPtr->mainwindow);
    return 0;
  } 
  sprintf(db_msg, "Saved file: %s", home);
  XtVaSetValues(AppWidgetsPtr->message,
		XtVaTypedArg, XmNlabelString, XmRString,
		db_msg, strlen(db_msg)+1, NULL);
  return 1;
}

/************************************************************************/
/* Function: MQUEL_GetCmdLineArg                                        */
/* Purpose : gets the command line args                                 */
/* Params  : argc : arg count                                           */
/*           argv : array of cmd line args                              */
/* Returns : 1 if dbname passed) / 0 on no dbname passed                */
/* Notes   :                                                            */
/************************************************************************/

int MQUEL_GetCmdLineArg(int argc, char **argv)
{
  extern char* optarg;
  extern int optind, opterr;
  int c;
  int db_arg = 0;

  memset(dbname, '\0', DB_NAME_SZ);
  memset(host, '\0', HOST_NAME_SZ);
  memset(port, '\0', PORT_NAME_SZ);

  while((c = getopt(argc, argv, "D:H:P:Uh")) != EOF){
    switch(c){
    case 'D':
      strcpy(dbname, optarg);
      db_arg = 1;
      break;
    case 'H':
      strcpy(host, optarg);
      db_arg = 1;
      break;
    case 'P':
      strcpy(port, optarg);
      db_arg = 1;
      break;
    case 'U':
      user_prompt = 1;
      break;
    case 'h':
      fprintf(stdout, "\nmpsql v%s - copyright (c) 1996-98 Mutiny Bay Software\n\n", MPSQL_VERSION);
      fprintf(stdout, "usage: mpsql [options]\n  where options are:\n");
      fprintf(stdout, "\t[-D <database name>]\n");
      fprintf(stdout, "\t[-H <host>]\n\t[-P <port>]\n");
      fprintf(stdout, "\t[-U]\t- prompt for username & password\n");
      fprintf(stdout, "\t[-h]\t- this text\n\n");
      exit(0);
    default:
      exit(-1);
    }
  }

  if(db_arg)
    return 1;
  else
    return 0;
}
