/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: util.h,v 1.3 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		util.h
**
**  contents:		header file for utilities
**
**  interface:		#include "util.h"
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _UTIL_H_
#define _UTIL_H_ 1

/* -------------------------------------------------------------------- *
*g  prototypes
** -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- *
*g  file types
** -------------------------------------------------------------------- */
#define file_html  	1
#define file_plain	2
#define file_special 	4
#define file_dir   	8
#define file_gif   	16
#define file_executable	32
#define file_no_access 	64

#define file_regular (file_html | file_plain)

/* -------------------------------------------------------------------- *
*g  prototypes
** -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- *
*p  procedure-name:	get_file
**
**  purpose:		extracts file (plus opt. path) from url.
**			strips of prefix and anchor.
** -------------------------------------------------------------------- *
**  args:		filename and opt. anchor in a '\0' terminated
**			string.  format: "[file:]<file>[#<anchor>]".
**  return type:	char* (allocated). caller is responsible for
**			freeing the returned memory (if != NULL).
** -------------------------------------------------------------------- */
char*
get_file (/* i  */ char* url);

/* -------------------------------------------------------------------- *
*p  procedure-name:	get_anchor
**
**  purpose:		returns the anchor from the given url or an
**			empty string if there was no anchor.
** -------------------------------------------------------------------- *
**  args:		filename + opt anchor.
**  returns:		the anchor or "" (\0 terminated).
**			the application must not free the returned ptr.
** -------------------------------------------------------------------- */
char*
get_anchor (/* i  */ char* url);

/* -------------------------------------------------------------------- *
*p  procedure-name:	convert_newlines_to_spaces
**
**  purpose:		removes leading whitespace and converts all
**			newlines with spaces.
**  and:		shows we can fluently deal with pointers :-)
** -------------------------------------------------------------------- *
**  args:		string str
**  return type:	char*
**  precondition:	\0 terminated string must be passed.
**  postcondition:	see purpose. side effect is, that non blank part
**			of str is copied to the beginning of string.
**  error handling.:	assumes \0 at the end of string.
** -------------------------------------------------------------------- */
char*
convert_newlines_to_spaces (/* io */ char*	str);

/* -------------------------------------------------------------------- *
*p  procedure-name:	get_file_and_strip_path
**
**  purpose:		strips the path component from a filename.
** -------------------------------------------------------------------- *
**  return-value:	returns a newly allocated string filename.
**			or null if ref does not contain a filename 
**			or ref is a directory.
**			the caller is responsible to free the returned 
**			string.
** -------------------------------------------------------------------- */
char*
get_file_and_strip_path (/* i  */ char* url);

/* -------------------------------------------------------------------- *
*p  procedure-name:	get_path
**
**  purpose:		returns the path component of filename
** -------------------------------------------------------------------- *
**  precondition:	file must be accessible (for reading).
**
**  return value:	path component of file in a newly allocated 
**			string or NULL if name of file
** -------------------------------------------------------------------- */
char*
get_path (/* i  */ char* filename);

/* -------------------------------------------------------------------- *
*p  procedure-name:	file_type
**
**  purpose:		returns the type of the file `filename'.
**			
**			possible values are:
**			
**			* file_html
**			* file_dir
**			* file_plain
**			* file_gif
**			* file_executable
**			* file_no_access
**			
**			possible more than one attributes belong to a file
**			the caller can test if attribute is true by
**			using the & (and) operator. e.g. 
**			
**			xxx = file_type ("?");
**			if (xxx & file_dir) printf ("? is a dir\n");
** -------------------------------------------------------------------- */
int
file_type (/* i  */ char* filename);

#endif /* !_UTIL_H_ */
/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
