/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/tools/sources/RCS/ic_snns.h,v $
  SHORTNAME      : ic_snns
  SNNS VERSION   : 4.1

  PURPOSE        : Intermediate Code (IC) functions for the SNNS batch 
                   interpreter:
                   function calls to the SNNS-Kernel function interface

  NOTES          : Abbreviations: ST: symbol table
                                  IC: intermediate code

  AUTHOR         : Jens Wieland
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.3 $
  LAST CHANGE    : $Date: 1995/07/20 07:53:57 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/


extern void setInitFunc(arglist_type *arglist);
extern void setLearnFunc(arglist_type *arglist);
extern void setUpdateFunc(arglist_type *arglist);
extern void setPruningFunc(arglist_type *arglist);
extern void setSubPattern(arglist_type *arglist);
extern void setShuffle(arglist_type *arglist);
extern void setSubShuffle(arglist_type *arglist);
extern void setParallelMode(arglist_type *arglist);
extern void setCascadeParams(arglist_type *arglist);

extern void initNet(arglist_type *arglist);
extern void loadNet(arglist_type *arglist);
extern void saveNet(arglist_type *arglist);
extern void saveResult(arglist_type *arglist);
extern void trainNet(arglist_type *arglist);
extern void testNet(arglist_type *arglist);
extern void pruneNet(arglist_type *arglist);
extern void pruneTrainNet(arglist_type *arglist);
extern void pruneNetNow(arglist_type *arglist);
extern void delCandUnits(arglist_type *arglist);

extern void loadPattern(arglist_type *arglist);
extern void setPattern(arglist_type *arglist);
extern void delPattern(arglist_type *arglist);

extern void setSeed(arglist_type *arglist);

