/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/rpc/sources/RCS/kr_coop.c,v $
  SHORTNAME      : kr_coop.c
  SNNS VERSION   : 4.1

  PURPOSE        :
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           :

  CHANGED BY     :
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.4 $
  LAST CHANGE    : $Date: 1995/11/16 07:25:38 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>

#include "kr_typ.h"	 /*  Kernel Types and Constants  */
#include "glob_typ.h"
#include "kr_const.h"	 /*  Constant Declarators for SNNS-Kernel  */
#include "kr_def.h"	 /*  Default Values  */

#include <rpc/rpc.h>
#include "kr_ui_rpc.h"
/*#include "kr_slave.h"*/
#include "ui_rpcsnns.h"
#include "kr_ui_rpc_main.h"

#include "kr_coop.ph"

/*****************************************************************************
  FUNCTION : kr_coopManage

  PURPOSE  : 
  NOTES    : 

  RETURNS  : 
  UPDATE   : 
******************************************************************************/

krui_err kr_coopManage(NetLearnParameters *parameters)
{
#ifdef 0
    int stepSize,i;
    int noOfPattern,startpat,endpat;
    par_learning par;

    noOfPattern = parameters->lastPattern - parameters->firstPattern;
    if(noOfPattern <= 0)
	return(KRERR_NO_ERROR);
    /* First calculate the start- and endpattern of each slave */
    stepSize = (int) (( (float)(noOfPattern) / 
		       ( (float)(m_anzCoopKernels) ) + 0.99999) );

    startpat = parameters->firstPattern;
    endpat = stepSize;
    par.learnFunc = 0;
    par.noOfEpochs = parameters->noOfEpochs;
    for( i = 1 ; i < m_anzCoopKernels ; i++){
	if(startpat >  parameters->lastPattern){
	    /* More slaves then pattern */
	    /* Nothing to do for master */
	    parameters->firstPattern = parameters->lastPattern;
	    /* Mark the rest of the slaves */
	    for ( ;i < m_anzCoopKernels ; i++)
		m_coopKernels[i].status = S_IDLE;
	    return(KRERR_NO_ERROR);
	}
	if(endpat > parameters->lastPattern){
	    /* More slaves then pattern */
	    endpat = parameters->lastPattern;
	}
	par.startpat = startpat;
	par.endpat = endpat;
	par.coop_id = m_coopKernels[i].coop_id; /* set the id of salve */
	startpat = endpat+1;
	endpat = endpat + stepSize;
	if(m_coopKernelsCl[i] == NULL){
	    if((m_coopKernelsCl[i] = clnt_create(m_coopKernels[i].hostaddr
						,SNNSKERNELSLAVEPROG
						,m_coopKernels[i].kernelno
						,"tcp"))== NULL){
		m_coopKernels[i].status = S_ERROR;
		return(RPC_COOP_ERR);
	    }
	    m_coopKernelsCl[i]->cl_auth = authunix_create_default();
	}
#ifdef DEBUG
	printf("Learning Patterns from %d to %d at SLAVE %s with ID %d\n"
	       ,par.startpat,par.endpat
	       ,m_coopKernels[i].host,m_coopKernels[i].coop_id);
#endif
	if(sl_start_learning_32(&par,m_coopKernelsCl[i])==NULL){
	    m_coopKernels[i].status = S_ERROR;
	    return(RPC_COOP_NO_RESPONSE);
	}
	m_coopKernels[i].status = S_LEARNING;
	/* Save starttime for loadbalance */
	m_coopKernelsStartT[i].tv_sec = 0L;
	m_coopKernelsStartT[i].tv_usec = 0L;
    }
    parameters->firstPattern = startpat;
    if(parameters->firstPattern > parameters->lastPattern){
	/* Nothing to do for master */
	parameters->firstPattern = parameters->lastPattern;
    }
    m_coopKernels[0].status = S_LEARNING;
#ifdef DEBUG
    printf("Learning Patterns from %d to %d Local\n"
	   ,parameters->firstPattern, parameters->lastPattern);
#endif
#endif
    return(KRERR_NO_ERROR);
}


#ifdef DEBUG
/*****************************************************************************
  FUNCTION : kr_showCoopConfig

  PURPOSE  : Prints Debug Info
  NOTES    : 

  RETURNS  : 
  UPDATE   : 
******************************************************************************/
void kr_showCoopConfig(void)
{
#ifdef 0
    int i;
    printf("\n");
    for( i = 0 ; i < m_anzCoopKernels ; i++){
	printf("Host: %16s Vers: %7ld ID %3d Status",m_coopKernels[i].host
	       ,m_coopKernels[i].kernelno,m_coopKernels[i].coop_id);
	switch(m_coopKernels[i].status){
	  case S_LEARNING:
	    printf(": Learning\n");
	    break;
	  case S_IDLE:
	    printf(": Idle\n");
	    break;
	  case S_ERROR:
	    printf(": ERROR\n");
	    break;
	  case S_READY:
	    printf(": Ready\n");
	    break;
	}
    }	
    printf("\n");
#endif
}
#endif
