.TH portrait 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
portrait - 2 dimensional phase portrait.
.SH CALLING SEQUENCE
.nf
[]=portrait(f,[odem,xdim,npts,pinit])
.fi
.SH PARAMETERS
.TP
f 
: a Scilab external which gives the field of the dynamical system. Hence 
it can be a macro name which computes the field at time t and point x [y]=f(t,x,[u])
or a list list(f1,u1) where f1 is a macro of type [y]=f1(t,x,u) or a character string.
The macro can be used to simulate a continuous or discrete system and in case 
of discrete system the second parameter must be set to 'discrete'
.TP
.I rest
: The other parameters are optional. If omitted they will be asked interactively
.RS
.TP
odem
: gives the integration method to use. The value "default" can be used, 
otherwise see ode for a complete set of possibilities
.TP
npts
:  a vector of size (2,10) [number-of-points,step] gives the step for integration 
and the number of requested points. The solution will be calculated and drawn 
for time=0:step:(step*[number-of-points])
.TP
xdim
: [xmin,xmax,ymin,ymax,zmin,zmax] the boundaries of the graphic frame.
.TP
pinit
: initial values for integration. A set of initial points can be given in a matrix
.nf
      pinit = [x0(1), x1(1),...., xn(1)
               x0(2), x1(2),...., xn(2)
               x0(3), x1(3),...., xn(3)].
.fi
.RE
.SH DESCRIPTION
Interactive integration and display of a 2 dimensional phase portrait
of a dynamical system  dx/dt=f(t,x,[u]) (where u is an optional parameter )
.SH EXAMPLE
.nf
a=rand(2,2)
deff('[ydot]=l_s(t,y)','ydot=a*y')
portrait(l_s)
.fi
.SH SEE ALSO
ode

