.TH successors 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
successors - head nodes of outgoing arcs of a node
.SH CALLING SEQUENCE
.nf
a = successors(i,g)
.fi
.SH PARAMETERS
.TP 2
i
: integer 
.TP 2
g
: graph list 
.TP 2
a
: row vector of integers
.SH DESCRIPTION
\fVsuccessors\fR returns the row vector of the numbers of the head nodes of 
the outgoing arcs from node i for a directed graph \fVg\fR .
.SH EXAMPLE
.nf
ta=[1  6  2  4  7  5  6  8  4  3  5  1];
he=[2  1  3  6  4  8  8  7  2  7  3  5];
g=make_graph('foo',1,8,ta,he);
g('node_x')=[285  284  335  160  405  189  118  45];
g('node_y')=[266  179   83  176  368  252  64  309];
show_graph(g);
a=successors(6,g)
show_nodes(a);
.fi
.SH SEE ALSO
neighbors, predecessors
