.TH proj 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
proj - projection
.SH CALLING SEQUENCE
.nf
P = proj(X1,X2)  
.fi
.SH PARAMETERS
.TP 12
X1,X2
: two real matrices with equal number of columns
.TP
P
: real projection matrix (\fVP^2=P\fR)
.SH DESCRIPTION
\fVP\fR is the projection on \fVX2\fR parallel to \fVX1\fR.
.SH EXAMPLE
.nf
X1=rand(5,2);X2=rand(5,3);
P=proj(X1,X2);
norm(P^2-P,1)
trace(P)    // This is dim(X2)
[Q,M]=fullrf(P);
svd([Q,X2])   // span(Q) = span(X2)
.fi
.SH SEE ALSO
projspec, orth, fullrf
.SH AUTHOR
F. D.


