.TH colcomp 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
kernel - kernel, nullspace
.SH CALLING SEQUENCE
.nf
W=kernel(A [,tol,[,flag])
.fi
.SH PARAMETERS
.TP 10
A
: full real or complex matrix or real sparse matrix
.TP 10
flag
: character string \fV'svd'\fR (default) or \fV'qr'\fR
.TP 10
tol
:
real number
.TP
W
: full column rank matrix 
.SH DESCRIPTION
\fVW=kernel(A)\fR returns the kernel (nullspace) of \fVA\fR.
.LP
\fVflag\fR and \fVtol\fR are optional parameters: \fVflag = 'qr'\fR 
or \fV'svd'\fR (default is \fV'svd'\fR).
.LP
\fVtol\fR = tolerance parameter (of order \fV%eps\fR as default value).
.SH EXAMPLE
.nf
A=rand(3,1)*rand(1,3);
A*kernel(A)
A=sparse(A);
clean(A*kernel(A))
.fi
.SH SEE ALSO
colcomp, fullrf, fullrfk, linsolve
.SH AUTHOR
F.D.

