.TH xgetmouse  "September  1994" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
xgetmouse - get current position of the mouse
.SH CALLING SEQUENCE
.nf
rep=xgetmouse([flag])
.fi
.SH PARAMETERS
.TP 10
rep
: a three vector: [x,y,ibutton] 
.TP
flag
: an integer. If present, the click event queue is not cleared when entering xclick
.SH DESCRIPTION
If the mouse is located in the current graphic window xgetmouse returns
in rep the current mouse position (x,y) and the value ibutton. 
The ibutton value indicate the button action at this point
 if ibutton==-1 then no button clicked
 if ibutton==0,1 or 2 then the left, middle or right button clicked

If the mouse is not located in the current graphic window xgetmouse waits
.SH EXAMPLE
.nf
xselect();xbasc(); xsetech([0 0 1 1],[0 0 100 100])
xset('alufunction',6)
xtitle(' drawing a rectangle ');
[b,x0,y0]=xclick();rep=[x0,y0,-1];x=x0;y=y0
xrect(x0,y0,x-x0,y-y0);
while rep(3)==-1 then
    rep=xgetmouse(0);
    xrect(x0,y0,x-x0,y0-y);
    x=rep(1);y=rep(2);
    xrect(x0,y0,x-x0,y0-y);
end
xset('alufunction',3)
.fi
.SH SEE ALSO
locate, xclick
.SH AUTHOR
S. Steer




