.TH xget 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
xget - gets current values of the graphic context
.SH CALLING SEQUENCE
.nf
[x1]=xget(str [,flag])
xget()
.fi
.SH PARAMETERS
.TP 10
str
: string
.TP
flag
: optional. Set to 1 gives a verbose mode
.SH DESCRIPTION
this function is used to get values from the graphic context
on the topic specified by the string \fVstr\fR. When called 
no arguments, a choice menu is created showing the current values and 
changes can be performed through toggle buttons 
.TP
number=xget("alufunction")
: used to get the logical function number used for drawing.
.RS
.TP
 0
: function  " 0 ",
.TP
 1
: function " src AND dst "
.TP
 2
: function " src AND NOT dst "
.TP
 3
: function " src ", (Default value)
.TP
 4
: function " NOT src AND dst "
.TP
 5
: function " dst ",
.TP
 6
: function " src XOR dst ",
.TP
 7
: function " src OR dst ",
.TP
 8
: function " NOT src AND NOT dst ",
.TP
 9
: function " NOT src XOR dst ",
.TP
10
: function " NOT dst ",
.TP
11
: function " src OR NOT dst ",
.TP
12
: function " NOT src ",
.TP
13
: function " NOT src OR dst ",
.TP
14
: function " NOT src OR NOT dst ",
.TP
15
: function " 1 ";
.RE
str=xset("auto clear")
: to get the auto clear status (\fV"on"\fR or \fV"off"\fR).
.TP
color=xget("background")
: to get the background color of the current graphic window.
.TP
rect=xget("clipping") 
:  get the clipping
zone rectangle rect=[x,y,w,h] (Upper-Left point Width Height).
.TP
cmap=xget("colormap")
: get the colormap used for the current graphics window as a m x 3
  RGB matrix
.TP
dash=xget("dashes")
: get the dash style dash=[dash_number,v]
  v contains the definition of the dash
.TP
font=xget("font")
: get font=[fontid,fontsize] the current font and its current size.
.TP
color=xget("foreground")
: to fix the foreground color of the current graphic window.
.TP
str=xget("fpf")
: to get the floating point format for number display in 
contour functions. Note that \fVstr==''\fR when default format is used.
.TP
color=xget("hidden3d")
: set the color number for ``hidden'' faces in plot3d.
.TP
pat=xget("lastpattern")
the id of the last available pattern or color, with the current colormap of 
the current window. In fact \fVpat+1\fR and \fVpat+2\fR are also available and
stand respectively for black and white pattern. 
.TP
type=xget("line mode");
This function is used to get the line drawing mode. 
type=1 :Absolute mode,type=0 relative mode
(Warning : the mode type=0 is buged )
.TP
mark=xget("mark")
: mark=[markid,marksize] the current mark and current mark size.
.TP
pat=xget("pattern")
: to get the current pattern or the current colo. \fVpat\fR is an integer 
in the range \fV[1,last]\fR. When one use a black and white Scilab, 0 is used for black filling and 
last for white. The value of \fVlast\fR can be obtained with \fVxget("lastpattern")\fR. 
.TP
value=xget("thickness")
: get the thickness of lines in pixel  ( 0 and 1 have the same meaning : 1 pixel thick)
.TP
dim=xget("wdim")
: dim=[width,height]  the width and height of the current graphic window.
.TP
pos=xget("wpos",x,y);
: pos=[x,y] the position of the upper left point of the graphic window.
.TP
win=xget("window")
Get the current window to the window \fVwin\fR 
.TP
flag=xget("use color")
if flag=1 then xset("pattern",.) or xset("dashes",.) will be used so
as to change the default color for drawing or for filling patterns. 
If flag=0 then we switch back to the gray and dashes mode.
.SH SEE ALSO
xset, colormap
.SH REFERENCE
X11 documentation
.SH AUTHOR
J.Ph.C.
