.TH "mtlb_fftshift" 2 " June 6th 1997" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
mtlb_fftshift - Move zeroth lag to center of spectrum
.sp
Author: Paulo Goncalves
.sp
 Move zeroth lag to center of spectrum. Shift FFT.  For vectors
MTLB_FFTSHIFT(X) returns a vector with the left and right halves swapped.
For matrices, MTLB_FFTSHIFT(X) swaps the upper and the lower halves. 
.sp
.sp
.SH Usage
.sp
.ft CR
.nf
y = mtlb_fftshift(x) ;
.fi 
.ec
.ft P
.sp
.SH Input parameters


.RS

.TP
o 
\fBx\fP : Real or complex valued matrix \f(CR[\fPrx,cx\f(CR]\fP
.RE

.SH Output parameters


.RS

.TP
o 
\fBy\fP : Real or complex valued matrix \f(CR[\fPrx,cx\f(CR]\fP
.RE

.SH See also:
fft
.SH Example:
\fI Matrix synthesis: \fP 
.sp
.ft CR
.nf
t = linspace( 0,1,128 ) ;
x = sin( 2*%pi*t*16 ) ;
SpectX = abs( fft( x,-1 ) ) ;
.fi 
.ec
.ft P
.sp
\fI FFT-SHIFT\fP 
.sp
.ft CR
.nf
xsetech([0 0 0.5 1]) ; plot2d( Freq,SpectX ) ; 
SwapSpectX = mtlb_fftshift( SpectX ) ;
Freq = linspace( -0.5,0.5,128 ) ;
xsetech([0.5 0 0.5 1]) ; plot2d( Freq,SwapSpectX )
.fi 
.ec
.ft P
.sp
