.TH "McCulloch" 2 " 1 April 1997" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
McCulloch - Stable law parameters estimation (McCulloch method)
.sp
Author: Lotfi Belkacem
.sp
This routine estimates parameters of a  \fIstable law\fP using the \fIMc-Culloch\fP (1985) method. 
.sp
.sp
.SH Usage
\f(CR[\fPparam,sd_param\f(CR]\fP=McCulloch(data)
.SH Input parameters


.RS

.TP
o 
\fBdata\fP : real vector \f(CR[\fPsize,1\f(CR]\fP 
corresponding to the data sample.
.RE

.SH Output parameters


.RS

.TP
o 
\fBparam\fP : real vector \f(CR[\fP4,1\f(CR]\fP 
corresponding to the four estimated parameters  of the fited stable law.
the order is respectively alpha (characteristic exponent), 
beta (skewness parameter), mu (location parameter), gamma (scale parameter) 

.TP
o 
\fBsd_param\fP : real vector \f(CR[\fP4,1\f(CR]\fP 
corresponding to estimated standard deviation of the four previous parameters.
.RE

.SH Example
\f(CR[\fPproc1.5,inc1.5\f(CR]\fP=sim_stable(1.5,0,0,1,10000);
generates a standard 1.5-stable motion.
\f(CR[\fPparam,sd_param\f(CR]\fP=McCulloch(inc1.5);
estimates parameters of the previous simutated 1.5-stable random variable inc1.5 To visualize the estimates parameters or their sd-deviations use respectively  param or sd_param.
alpha=param(1), beta=param(2), mu=param(3), gamma=param(4).
sd_alpha=sd_param(1), sd_alphabeta=sd_param(2), sd_alphamu=sd_param(3), sd_gamma=sd_param(4).
.SH Remarque
Skewness parameter and its sd-deviation estimations are not very accurate.
Specially when the characteristic exponent is arround 2. 
