.TH TOEPLITZ 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
toeplitz - toeplitz matrix
.SH CALING SEQUENCE
.nf
A=toeplitz(c [,r]) 
.fi
.fi
.SH PARAMETERS
.TP 10
a,c,r
: constant, polynomial or character chain matrices 
.SH DESCRIPTION
returns the Toeplitz  matrix 
whose first  row is \fVr\fR and first column is  \fVc\fR.
\fVc(1)\fR  must be equal to \fVr(1)\fR.  \fVtoeplitz(c)\fR returns the
symmetric Toeplitz matrix.
.SH EXAMPLE
.nf
A=toeplitz(1:5);
//
T=toeplitz(1:5,1:2:7);T1=[1 3 5 7;2 1 3 5;3 2 1 3;4 3 2 1;5 4 3 2];
T-T1
//
s=poly(0,'s');
t=toeplitz([s,s+1,s^2,1-s]);
t1=[s,1+s,s*s,1-s;1+s,s,1+s,s*s;s*s,1+s,s,1+s;1-s,s*s,1+s,s]
t-t1
//
t=toeplitz(['1','2','3','4']);
t1=['1','2','3','4';'2','1','2','3';'3','2','1','2';'4','3','2','1']
.fi
.SH SEE ALSO
matrix

