.TH st_ility 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
st_ility - stabilizability test
.SH CALLING SEQUENCE
.nf
[ns, [nc, [,U [,Slo] ]]]=st_ility(Sl [,tol])
.fi
.SH PARAMETERS
.TP 10
Sl 
: \fVsyslin\fR list (linear system)
.TP
ns
:  integer (dimension of stabilizable subspace)
.TP
nc
:  integer (dimension of controllable subspace \fVnc <= ns\fR)
.TP
U 
: basis such that its \fVns\fR (resp. \fVnc\fR) first components span
the stabilizable (resp. controllable) subspace
.TP
Slo
: a linear system (\fVsyslin\fR list)
.TP
tol
: threshold for controllability detection (see contr)
.SH DESCRIPTION
\fV Slo=( U'*A*U, U'*B, C*U, D, U'*x0 )\fR (\fVsyslin\fR list)
displays the stabilizable form of \fVSl\fR. Stabilizability means
\fVns=nx\fR (dim. of \fVA\fR matrix).
.nf
         [*,*,*]            [*]
U'*A*U = [0,*,*]     U'*B = [0]
         [0,0,*]            [0]
.fi
where \fV (A11,B1) \fR (dim(A11)= \fVnc\fR) is controllable and \fVA22\fR 
(dim(A22)=\fVns-nc\fR) is stable.
"Stable" means real part of eigenvalues negative for a continuous
linear system, and magnitude of eigenvalues lower than one for a
discrete-time system (as defined by \fVsyslin\fR).
.SH EXAMPLE
.nf
A=diag([0.9,-2,3]);B=[0;0;1];Sl=syslin('c',A,B,[]);
[ns,nc,U]=st_ility(Sl);
U'*A*U
U'*B
[ns,nc,U]=st_ility(syslin('d',A,B,[]));
U'*A*U
U'*B
.fi
.SH SEE ALSO
dt_ility, contr, stabil, ssrand
.SH AUTHOR
S. Steer INRIA 1988
