/*
*
* Wrapper to exec /usr/lib/xfmail/mailbox - Matt Ryan
*
*/
#include <sys/param.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>

#define EXEC "/usr/lib/xfmail/mailbox"
#define NAME "mailbox"

#define ARGLEN 10

#define MBOX_CREATE 1
#define MBOX_LOCK 2
#define MBOX_UNLOCK 3

int debian_mbox_op(char *file, int op)
{
	char mbox[MAXPATHLEN + 1], arg[ARGLEN +1];
	int status, retval;
	pid_t foo, bar;

	(void)strncpy(mbox, file, MAXPATHLEN);
	switch(op) {
		case MBOX_CREATE:	(void)strncpy(arg, "--create", ARGLEN);
					break;

		case MBOX_LOCK:		(void)strncpy(arg, "--lock", ARGLEN);
					break;

		case MBOX_UNLOCK:	(void)strncpy(arg, "--unlock", ARGLEN);
					break;
	}

#ifdef LOCK_DEBUG
	(void)fprintf(stderr,
		"Debian - execing: mailbox --mbox %s %s\n", mbox, arg);
#endif

	switch((foo = fork())) {
		case -1:	/* Cannot fork process */
				return(1); break;

		case 0:	/* Forked OK - Now exec program */
			(void)close(fileno(stdin));
			(void)close(fileno(stdout));
			(void)close(fileno(stderr));

			(void)execl(EXEC, NAME, "--mbox", mbox, arg, NULL);
			break;
	}
	while(((bar = wait(&status)) != foo) && (bar != -1));

	if(retval = WEXITSTATUS(status)) {
		errno = retval; return(1);
	}

	return(0);
}

