-----------------------------------------------------------------------------
-- Lazy State Thread module
-- 
-- This library provides support for both lazy and strict state threads,
-- as described in the PLDI '94 paper by John Launchbury and Simon Peyton
-- Jones.  In addition to the monad ST, it also provides mutable
-- variables STRef and mutable arrays STArray.  As the name suggests, the
-- monad ST instance is lazy.
--
-- Suitable for use with Hugs 1.4.
-----------------------------------------------------------------------------

module LazyST 
    	( ST
        , unsafeInterleaveST
	, fixST
	-- instance Monad (ST s)
	-- instance Functor (ST s)
	, STRef
	  -- instance Eq (STRef s a)
	, newSTRef
	, readSTRef
	, writeSTRef 
        , STArray
          -- instance Eq (STArray s ix elt)
        , newSTArray
        , boundsSTArray
        , readSTArray
        , writeSTArray
        , thawSTArray
        , freezeSTArray
        , unsafeFreezeSTArray
        , Ix
	-- as the GHC copy says, "ST is one, so you'll likely need this"
	, module Monad
	) where

import STBase
import Monad   

instance Functor (ST s) where
    map f xs = [ f x | x <- xs ]

instance Monad (ST s) where
    (>>=)  = thenLazyST
    return = returnST

-----------------------------------------------------------------------------
