module GraphicsText(
	BkMode(..), 
	Alignment, HAlign(..), VAlign(..),
	text,
	withBkMode, withTextColor, withBkColor, withTextAlignment
	) where

import GraphicsTypes
import GraphicsUtilities(bracket_)
import qualified Win32
import Prelude
import Bits

----------------------------------------------------------------

type Alignment = (HAlign, VAlign)

-- names have a tick to distinguish them from Prelude names (blech!)
data HAlign = Left' | Center   | Right'
data VAlign = Top   | Baseline | Bottom

data BkMode = Opaque | Transparent

text              :: Point     -> String  -> Picture
withTextColor     :: RGB       -> Picture -> Picture
withTextAlignment :: Alignment -> Picture -> Picture
withBkColor       :: RGB       -> Picture -> Picture
withBkMode        :: BkMode    -> Picture -> Picture

----------------------------------------------------------------

bkMode :: BkMode -> Win32.BackgroundMode
bkMode Opaque      = Win32.oPAQUE
bkMode Transparent = Win32.tRANSPARENT

hAlign :: HAlign -> Win32.TextAlignment
hAlign Left'    = Win32.tA_LEFT       
hAlign Center  	= Win32.tA_CENTER     
hAlign Right'   = Win32.tA_RIGHT      
               
vAlign :: VAlign -> Win32.TextAlignment
vAlign Top     	= Win32.tA_TOP        
vAlign Baseline	= Win32.tA_BASELINE   
vAlign Bottom  	= Win32.tA_BOTTOM     

-- ToDo: add an update mode for these constants
-- (not required at the moment since we always specify exactly where
-- the text is to go)
-- tA_NOUPDATECP :: TextAlignment
-- tA_UPDATECP   :: TextAlignment

text (x,y) s = \ hdc -> 
  Win32.textOut hdc (fromDimension x) (fromDimension y) s

withTextColor (RGB r g b) p = \ hdc ->
  bracket_ (Win32.setTextColor hdc (Win32.rgb r g b)) 
           (Win32.setTextColor hdc) 
           (p hdc)

withBkColor (RGB r g b) p = \ hdc ->
  bracket_ (Win32.setBkColor hdc (Win32.rgb r g b)) 
	   (Win32.setBkColor hdc) 
           (p hdc)

withBkMode mode p = \ hdc ->
  bracket_ (Win32.setBkMode hdc (bkMode mode)) 
           (Win32.setBkMode hdc) 
           (p hdc)

withTextAlignment (ha, va) p = \ hdc ->
  bracket_ (Win32.setTextAlign hdc (hAlign ha .|. vAlign va)) 
	   (Win32.setTextAlign hdc) 
           (p hdc)

----------------------------------------------------------------
