module GraphicsColor
	( Color(..)
	, colorTable
	, withColor
	) where

import GraphicsTypes
import GraphicsPicture(withRGB)
import Ix(Ix)
import Array(Array,array,(!))

----------------------------------------------------------------
-- The interface
----------------------------------------------------------------

-- Paul wants me to use ROYGBIV - but I don't know what Indigo is
-- and I want Black and White
data Color 
  = Black
  | Blue
  | Green 
  | Cyan
  | Red 
  | Magenta
  | Yellow
  | White
 deriving (Eq, Ord, Bounded, Enum, Ix, Show, Read)

colorList  :: [(Color, RGB)]
colorTable :: Array Color RGB
withColor  :: Color -> Picture -> Picture

----------------------------------------------------------------
-- The implementation
----------------------------------------------------------------

colorList =
  [ (Black   , RGB   0   0   0)
  , (Blue    , RGB   0   0 255)
  , (Green   , RGB   0 255   0)
  , (Cyan    , RGB   0 255 255)
  , (Red     , RGB 255   0   0)
  , (Magenta , RGB 255   0 255)
  , (Yellow  , RGB 255 255   0)
  , (White   , RGB 255 255 255)
  ]

colorTable = array (minBound, maxBound) colorList

withColor c = withRGB (colorTable ! c)

----------------------------------------------------------------
-- The end
----------------------------------------------------------------
