module Polygon(
	Poly, 
	vecs, vecsOf, colorOf,
        maxx, maxy, minx, miny,
        close, map, set_Color
	) where
import Prelude hiding (Functor(map))
import Color(Color)
import Vector(Vec)

{-
   The basis of all the images is the Poly, which is a tuple of a color
   and a list of points. This is displayed as a polygon of that color. The 
   form is a line drawn to each of the points, in order.

   ADRNotes: 
   1) These are often (but not always) closed.
   2) The vector list is never empty!
   3) The vector list is always finite.
-}
type Poly = (Color,[Vec]) in
	vecs, vecsOf, colorOf,
	close, set_Color, map, 
	maxx, minx, maxy, miny

vecs :: Color -> [Vec] -> Poly
vecs c vs = (c, vs)

vecsOf :: Poly -> [Vec]
vecsOf (c,vs) = vs

colorOf :: Poly -> Color
colorOf (c,vs) = c

-- not needed
-- make sure a polygon is closed
close :: Poly -> Poly
close p@(c, vs)
  | null vs   = p
  | v1 == vn  = p
  | otherwise = (c, vn : vs)
  -- overkill: | otherwise = (c, vs ++ tail (reverse vs))
 where
  v1 = head vs
  vn = last vs

set_Color :: Color -> Poly -> Poly
set_Color c (_,vs) = (c, vs)

map :: (Vec -> Vec) -> (Poly -> Poly)
map f (c, vs) = (c, Prelude.map f vs)

  --these functions find the max and min x and y coordinates of a Poly
maxx :: Poly -> Int
maxx (c, vs) = maximum (Prelude.map fst vs)

minx :: Poly -> Int
minx (c, vs) = minimum (Prelude.map fst vs)
    
maxy :: Poly -> Int
maxy (c, vs) = maximum (Prelude.map snd vs)
    
miny :: Poly -> Int
miny (c, vs) = minimum (Prelude.map snd vs)


