module Picture (
	Pic,
	maxx,minx,maxy,miny,
	null, poly, polys, polysOf, overlay, map, 
	close, ht, wid, orig,
	put, over, above, beside,
	beside2,
	scale, scale_rel, mov, rot, twist,
	flipx, flipy, flip, {- flock, -}
	set_Color,
	to_orig,
	movto
        ) where

import Prelude hiding (null, flip, Functor(map))
import Color(
	Color
	)
import Vector(
	Vec(..), vplus, vmin, flipx_Vec, flipy_Vec, flip_Vec, vtovf, vftov
	)
import Polygon(Poly)
import qualified Polygon as Poly
{-	
	(
        maxx, maxy, minx, miny,
        close, map, set_Color
        )
-}
import Utility(
	power
	)

{-
  A list of Poly's is a Pic, or picture. 
  Each picture is a single  frame of a movie. 
  Note that empty pictures are possible but that pictures are always finite.
-}
type Pic = [Poly] in
	null, poly, polys, polysOf,
	close, set_Color, map, 
	maxx, minx, maxy, miny,
	overlay

null :: Pic
null = []

poly :: Color -> [Vec] -> Pic
poly c p = [Poly.vecs c p]

polys :: [Poly] -> Pic
polys p = p

polysOf :: Pic -> [Poly]
polysOf p = p

-- not needed
  -- closePic makes sure that the polygon is closed
close:: Pic -> Pic
close = Prelude.map Poly.close

  -- changes the color of the Pic
set_Color:: Color -> Pic -> Pic
set_Color c = Prelude.map (Poly.set_Color c)

  -- The following maps a given function over the Vector-list of each Polygon:
map:: (Vec -> Vec) -> (Pic -> Pic)
map f p = Prelude.map (Poly.map f) p


-- ADRNote: maxx, ht, origin, etc are not invariant under rotation

  --these functions find the max and min x and y coordinates of a Pic
maxx :: Pic -> Int
maxx p = foldr max 0 (Prelude.map Poly.maxx p)
				      
minx :: Pic -> Int		      
minx p = foldr min 0 (Prelude.map Poly.minx p)
				      
maxy :: Pic -> Int		      
maxy p = foldr max 0 (Prelude.map Poly.maxy p)
				      
miny :: Pic -> Int		      
miny p = foldr min 0 (Prelude.map Poly.miny p)


  -- these functions find the height, width and origin (= centre) of a Pic
ht :: Pic -> Int
ht p = maxy p - miny p

wid :: Pic -> Int
wid p = maxx p - minx p

orig:: Pic -> Vec
orig p = (x, y)
 where
  x = (maxx p + minx p) `div` 2
  y = (maxy p + miny p) `div` 2 


-- THE GEOMETRIC TRANSFORMATIONS:

  -- moves a Pic by the vector amount
mov:: Vec -> Pic -> Pic
mov v = map (vplus v)

  -- moves a Pic to the vector
movto:: Vec -> Pic -> Pic
movto v p = mov (vmin v (orig p)) p

  -- moves the origin of the Pic to the lower left side of the Pic
to_orig:: Pic -> Pic
to_orig p = mov (-mx,-my) p
 where 
  mx = minx p
  my = miny p


  -- scales the Pic by (r/11) relative to (dx, dy).
scale_rel :: Vec -> Int -> Pic -> Pic
scale_rel (dx, dy) r = map (scalep r)
 where 
  scalep r (v1,v2) = (((r*(v1-dx))+dx) `div` 11, ((r*(v2-dy))+dy) `div` 11)

  -- scales the Pic by (r/11) relative to its origin
scale :: Int -> Pic -> Pic
scale r p = scale_rel (orig p) r p


  -- rotates the Pic about the Vector by theta
rot :: Vec -> Float -> Pic -> Pic
rot centre theta = map rotp
 where 
  c = cos theta
  s = sin theta

  rotp vec = centre `vplus` vftov (u * c - v * s, u * s + v * c)
   where (u,v) = vtovf (vec `vmin` centre)

--ADRNote: this changes its "origin"
  -- rotates a Pic about its origin by theta
twist :: Float -> Pic -> Pic
twist theta p = rot (orig p) theta p

  -- flips the Pic about the line x=n (resp. y=n)
flipx, flipy :: Int -> Pic -> Pic 
flipx n = map (flipx_Vec n)
flipy n = map (flipy_Vec n)

  -- flips (rotates) the Pic about its own origin.
flip:: Pic -> Pic
flip p = map (flip_Vec (orig p)) p


-- PICTURE COMBINING OPERATIONS:
  
  -- overlay just takes 2 Pics and puts them together into one
overlay:: Pic -> Pic -> Pic
overlay p q = p ++ q

-- ADRNote: I don't understand the rationale in using the "origins"
-- of these various pictures

  -- put overlays the Pics, offsetting the first Pic by a vector
  -- amount from the origin of the second
put :: Vec -> Pic -> Pic -> Pic
put v p q = overlay
                     (movto (orig q `vplus` v) p )
                     q

  -- over puts one Pic directly on top of the other
over:: Pic -> Pic -> Pic
over p q = put (0,0) p q

  -- above puts the first Pic on top of the second
above:: Pic -> Pic -> Pic
above p q = put (0,(ht p + ht q) `div` 2) p q

  -- beside puts the first Pic beside the second. The width of
  -- the Pic is defined as the max x minus the min x, so a moving
  -- figure will stand still in this implementation
beside:: Pic -> Pic -> Pic
beside p q = put (((wid q)+(wid p)) `div` 2, 0) p q

  -- beside2 puts the first Pic beside the second, without 
  -- shifting to the width of the Pic. It uses the absolute coordinates.
beside2:: Pic -> Pic -> Pic
beside2 p q = put (wid q, 0) p q
     where put v p q = overlay (mov v p) q

  -- copies the Pic into another Pic n*n times in an n by n array pattern
flock :: Int -> Pic -> Pic
flock 1 p = p
flock (n+2) p = beside (flock (n-1) p) (row n p)
                    where row n p = power n (above p) null


