module Demos(main1, main2) where

import Display(displaym)
import Movie(Movie, rOVERLAY, rBESIDE2, picsOf, mkMovie)
import qualified Movie as M
import Behaviour(Behaviour)
import qualified Behaviour as B 
import Color(Color(..))
import Seafigs
import Screen(center, botm)
import Utility(osc)
import Picture(Pic)
import qualified Picture as Pic
import Shapes
import Defaults
import Vector(Vec)
import Inbetween

import System(getEnv)

-- planets rotating round sun
main1 _ = getEnv "DISPLAY" >>= \ host -> 
       displaym host 60 planet_scene
 where
  planet_scene:: Movie
  planet_scene = rOVERLAY
		   [B.apply (B.bpar (B.set_Color (repeat Yellow)) (B.movto (repeat center))) orb,
		    planets (pi/40.0) (pi/10.0) 450 80 RoyalBlue LightBlue,
		    planets (pi/20.0) (pi/8.0) 300 50 Brown Black,
		    planets (pi/10.0) (pi/4.0) 150 40 Green Red
		   ]

  planets:: Float -> Float -> Int -> Int -> Color -> Color -> Movie
  planets i1 i2 r1 r2 c1 c2 
    = rOVERLAY [ f1 `B.apply` earth, B.bpar f1 f2 `B.apply` moon ]
   where 
    f1    = B.circ_mov (fromIntegral r1) i1
    f2    = B.circ_mov (fromIntegral r2) i2
    earth = M.repeat (Pic.mov center (box c1 30 30))
    moon  = M.repeat (Pic.mov center (box c2 15 15))

  orb :: Movie
  orb = M.repeat (circ Red 50 10)

-- birds
main2 _ = getEnv "DISPLAY" >>= \ host -> 
          displaym host 30 bird
 where
  bird :: Movie
  --bird = osc [bird1,bird2]
  bird = rOVERLAY
	   [B.apply (B.bPar [right,right,right,right]) bm1,
	    B.apply (B.bPar [up,right,right,right]) bm2]
	   where bm1 = M.repeat bird1
		 bm2 = M.repeat bird2

  bird1 = Pic.poly Black b1
	  where b1 = [(0,90),(20,100),(30,110),(40,110),(50,100),(110,120),
		      (130,100),(120,90),(80,90),(0,90),
		      (80,90),(90,70),(140,50),(120,90),(80,90),
		      (80,90),(70,70),(80,60),(90,70)]

  bird2 = Pic.poly Red b2
	  where b2 = [(0,60),(20,70),(30,80),(40,80),(50,70),(110,70),
		      (140,30),(110,35),(100,35),(70,50),(50,60),(0,60),
		      (70,50),(100,90),(150,100),(120,60),(110,35),
		      (70,50),(65,100),(85,115),(97,86)]

{-
-- bits of the seaside in isolation
main3 _ = getEnv "DISPLAY" >>= \ host -> 
          displaym host 30 trans
 where
  trans :: Movie
  trans = manright++change++gull2

  manright :: Movie
  manright =  mkMovie $ mirrorx (take 10 (picsOf (B.apply left (man ()))))

  gull2 :: Movie
  gull2 = B.apply (B.bPar [right,up,huge,huge,huge,(B.mov (repeat (275,0)))]) (gull ())

  change :: Movie
  change = inbetween 5  manf1 gull1
		where gull1 = head gull2
		      manf1 = last manright

  mirrorx :: [Pic] -> [Pic]
  mirrorx ps = map (Pic.flipx x) ps 
		where (x,_) = orig_Pics ps

  orig_Pics :: [Pic] -> Vec
  orig_Pics m = ((x2-x1) `div` 2, (y2-y1) `div` 2)
		    where x2 = foldr1 max (map Pic.maxx m)
			  x1 = foldr1 min (map Pic.minx m)
			  y2 = foldr1 max (map Pic.maxy m)
			  y1 = foldr1 min (map Pic.miny m)
-}

-- seaside scene
main4 _ = getEnv "DISPLAY" >>= \ host -> 
          displaym host 30 seaside
 where
  seaside :: Movie
  seaside = rOVERLAY [blue_sky (),
		    B.apply (B.bPar [up,cw,B.movto (repeat botm)]) (sun ()),
		    B.apply right (clouds ()),
		    B.apply (B.bPar [right,bigger]) (gull ()),
		    B.apply (B.bPar [right,right,bigger]) (gull ()),
		    B.apply (B.bPar [up,up,right,bigger]) (gull ()),
		    B.apply (B.bPar [up,right,right,right]) (gull ()),
		    windm,
		    B.apply (B.mov (repeat botm)) (palm ()),
		    man_and_vm
		   ]
  man_and_vm = rBESIDE2 [manfig, vm ()]
  manfig = B.apply left (B.apply (B.mov (repeat (700,0))) (man ()))
  windm = B.apply (B.mov (repeat (500,0))) (windmill ())


test = getEnv "DISPLAY" >>= \ host -> 
       displaym host 1 (M.repeat (Pic.poly Red [(0,0),(100,100), (100,0)]))
