/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgMarrHil.c                                                  */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:48 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "MarrHil"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1,*lap,*gradmag;
  int width,height,x,y,bit;
  it_float *ptr1,*ptr2,*r0_ptr,*r1_ptr,*r2_ptr;
  int i,v_x,v_y,v_width,v_height,y_end,x_end;
  double val,grx,gry,sum,min,max,centre;
  float aa,bb,cc,dd,ee;

  IFHELP
    {
      fprintf(stderr,"img%s - Carry out Marr-Hildreth edge detection\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }

  imgStart(PRGNAME);

  /* Loop for all images */
  do {
    /* Load float image */
    in1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(in1==NULL)
      ERROR("can't import image file");

    /* Create new image */
    width=in1->width;
    height=in1->height;
    v_x=in1->valid_x+1;
    v_y=in1->valid_y+1;
    v_width=in1->valid_width-2;
    v_height=in1->valid_height-2;
    x_end=v_x+v_width;
    y_end=v_y+v_height;

    lap=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(lap==NULL)
      ERROR("out of memory");
    gradmag=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(gradmag==NULL)
      ERROR("out of memory");

    /* Compute Laplacian and gradient magnitude */
    for(y=v_y;y<y_end;y++)
      {
	r0_ptr=im_float_row(in1,y-1)+v_x;
	r1_ptr=im_float_row(in1,y)+v_x-1;
	r2_ptr=im_float_row(in1,y+1)+v_x;
	ptr1=im_float_row(lap,y)+v_x;
	ptr2=im_float_row(gradmag,y)+v_x;
	for(x=0;x<v_width;x++)
	  {
	    sum= *r0_ptr++;
	    gry=sum;
	    val= *r2_ptr++;
	    sum+=val;
	    gry-=val;
	    val= *r1_ptr++;
	    sum+=val;
	    grx=val;
	    centre=(*r1_ptr++);
	    val= *r1_ptr--;
	    sum+=val;
	    grx-=val;
	    sum-= (4.0*centre);
	    *ptr1++ =sum;
	    *ptr2++ =sqrt(grx*grx+gry*gry)*0.5;
	  }
      }
    i_destroy_image(in1);

    /* Carry out zero-crossing detection, zeroing non-edge points in gradmag */
    v_y++;
    v_x++;
    y_end--;
    x_end--;
    for(y=v_y;y<y_end;y++)
      for(x=v_x;x<x_end;x++)
	{
	  bit=0;
	  aa=im_float_value(lap,x,y-1);
	  bb=im_float_value(lap,x-1,y);
	  cc=im_float_value(lap,x,y);
	  dd=im_float_value(lap,x+1,y);
	  ee=im_float_value(lap,x,y+1);
	  
	  /* Do a test to see if + centre, - elsewhere */
	  if(cc>0.0 && (aa<0.0 || bb<0.0 || dd<0.0 || ee<0.0))
	    bit=1;
	  if(cc==0.0)
	    {
	      /* Do a + shaped test for -0+ or +0- sequences */
	      if(aa>0.0 && ee<0.0 || aa<0.0 && ee>0.0 ||
		 bb>0.0 && dd<0.0 || bb<0.0 && dd>0.0)
		bit=1;
	      else
		{
		  /* Do a diagonal test */
		  aa=im_float_value(lap,x-1,y+1);
		  bb=im_float_value(lap,x+1,y+1);
		  dd=im_float_value(lap,x-1,y-1);
		  ee=im_float_value(lap,x+1,y-1);
		  if(aa>0.0 && ee<0.0 || aa<0.0 && ee>0.0 ||
		     bb>0.0 && dd<0.0 || bb<0.0 && dd>0.0)
		    bit=1;
		}
	    }
	  if(bit==0)
	    im_float_value(gradmag,x,y)=0.0;
	}

    i_destroy_image(lap);

    /* Compute min and max values then export */
    imgInitMinMax(min,max);
    for(y=v_y;y<y_end;y++)
      {
	ptr1=im_float_row(gradmag,y)+v_x;
	for(x=v_x;x<x_end;x++)
	  {
	    val= *ptr1++;
	    if(val>max) max=val;
	    if(val<min) min=val;
	  }
      }
    gradmag->min_value=min;
    gradmag->max_value=max;
    i_set_valid_region(gradmag,v_x,v_y,v_width-2,v_height-2);

    i_write_image_file(stdout,gradmag,IF_BINARY);
    i_destroy_image(gradmag);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
