/* 
 * update_display_pseudo.c
 *
 * routines to perform the refresh of an XImage
 * this file contains the special cases for 8bpp psuedo color displays.
 */
#ifdef x11
#define __UPDATE_DSP_PSEUDO_C_

#include "xmame.h"

void do_update_pseudo_dirty_scale1(void) {
	char *src_pt, *dest_pt;
	int line;
	for (line=0; line<visual_height; line++)
	{
	   dest_pt = scaled_buffer_ptr + line*visual_width + dirty_lines[line].x;
	   for (src_pt=dirty_lines[line].start; src_pt<dirty_lines[line].end; src_pt++, dest_pt++)
	      *dest_pt = (char)xpixel[0xff & *src_pt];
	}   
	osd_refresh_dirty_screen();
}

void do_update_pseudo_scale1(void) {
   long *end, *spt;
   long *dpt   =(long *)copybuffer;
   char *dpypt = scaled_buffer_ptr;
   int line, update=0;
   for (line=visual.min_y; line<=visual.max_y; line++)
   {
      spt=(long *)( (char *)bitmap->line[line] + visual.min_x);
      end=(long *)( (char *)bitmap->line[line] + visual.min_x + visual_width );
      for (;spt<end;spt++,dpt++,dpypt+=sizeof(long))
      {
         if (*spt!=*dpt) {
            *dpypt    =xpixel[0xff & *((char *)spt  )];
            *(dpypt+1)=xpixel[0xff & *((char *)spt+1)];
            *(dpypt+2)=xpixel[0xff & *((char *)spt+2)];
            *(dpypt+3)=xpixel[0xff & *((char *)spt+3)];
#ifdef linux_alpha  /* 64bit machines, */
            *(dpypt+4)=xpixel[0xff & *((char *)spt+4)];
            *(dpypt+5)=xpixel[0xff & *((char *)spt+5)];
            *(dpypt+6)=xpixel[0xff & *((char *)spt+6)];
            *(dpypt+7)=xpixel[0xff & *((char *)spt+7)];
#endif
            *dpt=*spt;
            update++;
         }
      }
   }
   if (update) osd_refresh_screen();
}

void do_update_pseudo_generic(void) {
   int i, line;
   int x,y,px,py;
   long color;
   char *dpypt;
   long *spt, *end;
   long *dpt=(long *)copybuffer;
   for (line=visual.min_y, y=0; line<=visual.max_y; line++, y++)
   {
      spt=(long *)( (char *)bitmap->line[line] + visual.min_x);
      end=(long *)( (char *)bitmap->line[line] + visual.min_x + visual_width );
      for (x=0;spt<end;spt++,dpt++,x+=sizeof(long)) {
         if (*spt!=*dpt) {
            for (i=0;i<sizeof(long);i++)
            {
               if ( *((char *)spt+i) == *((char *)dpt+i) ) continue;
               /* now perform a byte-by-byte search in current long pt */
               color=xpixel[0xff & *((char *)spt+i)];
               dpypt=scaled_buffer_ptr + heightscale*y*image->bytes_per_line + (x+i)*widthscale;
               for(py=0;py<heightscale;py++) 
                  for(px=0;px<widthscale;px++) 
                     *(dpypt+py*image->bytes_per_line+px)=color;
            } /* for i */
            *dpt=*spt;
         } /* if long is not equal */
      } /* for buffer */
   } /* for line */
   osd_refresh_screen();
}

void do_update_pseudo_dirty_generic(void) {
    char *pt;
    char *dpt,*auxpt;
    int line;
    int i;
    for (line=0; line<visual_height; line++) {
       if( ! dirty_lines[line].start ) continue;
       dpt = auxpt = scaled_buffer_ptr + heightscale*line*image->bytes_per_line + widthscale*dirty_lines[line].x;
       for(pt=dirty_lines[line].start;pt<dirty_lines[line].end;pt++,dpt+=widthscale)
	   for(i=0;i<widthscale;i++) *(dpt+i)=(char)xpixel[0xff & *pt];
       /* and now perform a memcpy to next lines */
       for (i=1;i<heightscale;i++)
           memcpy(auxpt+i*image->bytes_per_line,auxpt,widthscale*(dirty_lines[line].end-dirty_lines[line].start));
    }
    osd_refresh_dirty_screen();
}

void do_update_pseudo_dirty_scale2(void) {
    char *pt;
    char *dpt,*auxpt;
    int line;
    for (line=0; line<visual_height; line++) {
       if( ! dirty_lines[line].start ) continue;
       dpt = auxpt =
	    scaled_buffer_ptr + 2*line*image->bytes_per_line + 2*dirty_lines[line].x;
       for(pt=dirty_lines[line].start;pt<dirty_lines[line].end;pt++,dpt+=2) {
	   *dpt    =(char)xpixel[0xff & *pt];
	   *(dpt+1)=(char)xpixel[0xff & *pt];
       }
       /* and now perform a memcpy to next line */
       memcpy(auxpt+image->bytes_per_line,auxpt,2*(dirty_lines[line].end-dirty_lines[line].start));
    }
    osd_refresh_dirty_screen();
}

void do_update_pseudo_scale2(void) {
   int i,line;
   int x,y;
   long color;
   char *dpypt;
   long *spt, *end;
   long *dpt=(long *)copybuffer;
   for (line=visual.min_y, y=0; line<=visual.max_y; line++, y++)
   {
      spt=(long *)( (char *)bitmap->line[line] + visual.min_x);
      end=(long *)( (char *)bitmap->line[line] + visual.min_x + visual_width );
      for (x=0;spt<end;spt++,dpt++,x+=sizeof(long)) {
         if (*spt!=*dpt) {
            for (i=0;i<sizeof(long);i++) {
               if ( *((char *)spt+i) == *((char *)dpt+i) ) continue;
               /* now perform a byte-by-byte search in current long pt */
               color=xpixel[0xff & *((char *)spt+i)];
               dpypt=scaled_buffer_ptr + ((y*image->bytes_per_line + x + i) << 1);
               /* and draw pixel in image */
               *dpypt=color;*(dpypt+1)=color; 
               dpypt+=image->bytes_per_line;
               *dpypt=color; *(dpypt+1)=color;
            } /* for i */
            *dpt=*spt; /* mark long as updated */
         } /* if long is not equal */
      } /* for buffer */
   } /* for line */
   osd_refresh_screen();
}

void do_update_pseudo_dirty_scale3(void)
{
    char *pt;
    char *dpt,*auxpt;
    int line;
    for (line=0; line<visual_height; line++) {
       if( ! dirty_lines[line].start ) continue;
       dpt = auxpt =
	    scaled_buffer_ptr + 3*line*image->bytes_per_line + 3*dirty_lines[line].x;
       for(pt=dirty_lines[line].start;pt<dirty_lines[line].end;pt++,dpt+=3) {
	   *dpt    =(char)xpixel[0xff & *pt];
	   *(dpt+1)=(char)xpixel[0xff & *pt];
	   *(dpt+2)=(char)xpixel[0xff & *pt];
       }
       /* and now perform a memcpy to next line */
       memcpy(auxpt+image->bytes_per_line,auxpt,3*(dirty_lines[line].end-dirty_lines[line].start));
       memcpy(auxpt+2*image->bytes_per_line,auxpt,3*(dirty_lines[line].end-dirty_lines[line].start));
    }
    osd_refresh_dirty_screen();
}

void do_update_pseudo_scale3(void)
{
   int i,line;
   int x,y;
   long color;
   char *dpypt;
   long *spt, *end;
   long *dpt=(long *)copybuffer;
   for (line=visual.min_y, y=0; line<=visual.max_y; line++, y++)
   {
      spt=(long *)( (char *)bitmap->line[line] + visual.min_x);
      end=(long *)( (char *)bitmap->line[line] + visual.min_x + visual_width );
      for (x=0;spt<end;spt++,dpt++,x+=sizeof(long)) {
         if (*spt!=*dpt) {
            for (i=0;i<sizeof(long);i++) {
               if ( *((char *)spt+i) == *((char *)dpt+i) ) continue;
               /* now perform a byte-by-byte search in current long pt */
               color=xpixel[0xff & *((char *)spt+i)];
               dpypt=scaled_buffer_ptr + 3*(y*image->bytes_per_line + x + i);
               /* and draw pixel in image */
               *dpypt=color;*(dpypt+1)=color; *(dpypt+2)=color;
               dpypt+=image->bytes_per_line;
               *dpypt=color;*(dpypt+1)=color; *(dpypt+2)=color;
               dpypt+=image->bytes_per_line;
               *dpypt=color;*(dpypt+1)=color; *(dpypt+2)=color;
            } /* for i */
            *dpt=*spt; /* mark long as updated */
         } /* if long is not equal */
      } /* for buffer */
   } /* for line */
   osd_refresh_screen();
}

#endif /* ifdef x11 */
