#ifndef __SOUND_H_
#define __SOUND_H_

#ifdef __SOUND_C_
#define EXTERN
#else
#define EXTERN extern
#endif

/* audio related stuff */
#define AUDIO_SAMPLE_FREQ	(22050) /* used by solaris.c */
#define AUDIO_SAMPLE_LOWFREQ	(8000) /* used by solaris.c */
#define AUDIO_SAMPLE_BITS	(8) 
#define AUDIO_BUFSIZE_BITS	(8)
#define AUDIO_NUM_VOICES	(16)

/* ideally should be set to some whole divider of the system timer,
   since the system timer of most unix systems has a freq of 100 we use 50 */
#ifndef AUDIO_TIMER_FREQ
#define AUDIO_TIMER_FREQ	(50)
#endif

/* the +1 is gone now although newer oss versions still do strange things,
   but that's autoqueried now */
#define AUDIO_BUFF_SIZE (num_frags*frag_size)

#if ( defined linux || defined irix ) && defined USE_TIMER
#warning "You'll get better sound by disable of USE_TIMER makefile.unix feature"
/* #undef USE_TIMER */
#endif

typedef struct sample_t
{
	int loop_stream;
	float vol;
	float freq_fac;
	signed char *end_data_pt;
	signed char *data;
	size_t datasize;
	struct sample_t *next_sample;
}SAMPLE_T;

typedef struct voice_t
{
	signed char *current_data_pt;
	float pos_frac;
	SAMPLE_T *sample;
}VOICE_T;

EXTERN	int	   	audio_fd;
EXTERN	int	   	audio_timer_freq; 

#undef EXTERN
#endif
