/* 
 * update_display.c
 * routines to perform dirty marking and misc side routines.
 */
#ifdef x11
#define __DIRTY_C_

#include "xmame.h"

void osd_mark_dirty(int sx,int sy, int ex, int ey, int ui)
{
	int line;
	int real_width;
	char *spt,*ept;
	
	if (use_layer)
	{
	   layer_mark_rectangle_dirty_norotate(Machine->dirtylayer,sx,ex,sy,ey);
	   return;
	}
	
	if (use_dirty)
	{
	   if (sx < visual.min_x) sx=visual.min_x;
	   if (sy < visual.min_y) sy=visual.min_y;
	   if (ex > visual.max_x) ex=visual.max_x;
	   if (ey > visual.max_y) ey=visual.max_y;
	   /* calculate pointers */
	   spt = (char *)bitmap->line[sy] + sx;
	   ept = (char *)bitmap->line[sy] + ex+1;
	   /* make first visible line line 0 */
	   sy -= visual.min_y;
	   ey -= visual.min_y;
	   /* make first visible column column 0 */
	   sx -= visual.min_x;
	   /* calculate real bitmap width */
	   real_width = ((bitmap->width + 7) & ~7) + 16;
	   
	   for (line=sy; line<=ey; line++, spt+=real_width, ept+=real_width)
	   {
	       /* if start=0 this line hasn't been marked before, don't do 
	          this check for x even is x=0 the line can still be marked 
	          before (BugFix). */
	       if ( !dirty_lines[line].start )
	       {
	          dirty_lines[line].start = spt;
	          dirty_lines[line].x     = sx;
	          dirty_lines[line].end   = ept;
	       }
	       else
	       { 
	          if ( spt < dirty_lines[line].start) dirty_lines[line].start = spt;
	          if ( ept > dirty_lines[line].end  ) dirty_lines[line].end   = ept;
	          if ( sx  < dirty_lines[line].x    ) dirty_lines[line].x     = sx;
	       }
	   }
	}
}

void merge_dirty(void)
{
   struct dirty_line *temp;
   int i;
   
   /* merge this frame's dirty lines, with the last one's (old),
      store the result in the old one's since these aren't needed
      anymore */
      
   for (i=0; i<visual_height; i++)
      /* no need to do anything if current line not dirty */
      if (dirty_lines[i].start)
      {
         /* both current and old line are dirty */
         if(old_dirty_lines[i].start)
         {
            if (dirty_lines[i].start < old_dirty_lines[i].start)
            {
               old_dirty_lines[i].start = dirty_lines[i].start;
               old_dirty_lines[i].x     = dirty_lines[i].x;
            }
            if (dirty_lines[i].end   > old_dirty_lines[i].end)
               old_dirty_lines[i].end   = dirty_lines[i].end;
         }
         else
            old_dirty_lines[i]=dirty_lines[i];
      }
   
   /* now swap dirty_buffers */
   temp            = old_dirty_lines;
   old_dirty_lines = dirty_lines;
   dirty_lines     = temp;
}

extern short layer_dirty_shift;

/* copy the dirty info in the layer system to our own dirty_lines */
void copy_dirty_layer_to_dirty(void)
{
   int i,j;
   int block, start, end = 0;
   char *spt = (char *)bitmap->line[visual.min_y];
   /* calculate real bitmap width */
   int real_width = ((bitmap->width + 7) & ~7) + 16;
   
   for (i=0; i<visual_height; i++, spt+=real_width)
   {
      block = ((i + visual.min_y) >> 3) << layer_dirty_shift;
      for (j=0, start=-1; j<bitmap->width; j+=8, block++)
      {
         if (Machine->dirtylayer->dirty[block])
         {
           if (start == -1)
           {
              start = j;
              end   = j;
           }
           else
              end   = j;
         }
      }
      
      if (start != -1)
      {
         end += 8;
         if (start < visual.min_x) start = visual.min_x;
         if (end   > visual.max_x) end   = visual.max_x;
         dirty_lines[i].start = spt + start;
         dirty_lines[i].end   = spt + end;
         dirty_lines[i].x     = start - visual.min_x;;
      }
   }
   
   layer_mark_all_dirty(Machine->dirtylayer, MARK_ALL_CLEAN);
}

#endif /* ifdef x11 */
