/*
 * Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 *
 * (c) Copyright 1996, 1997, 1998 Gary Henderson (gary@daniver.demon.co.uk) and
 *                                Jerremy Koot (jkoot@snes9x.com)
 *
 * Super FX C emulator code 
 * (c) Copyright 1997, 1998 Ivar (Ivar@snes9x.com) and
 *                          Gary Henderson.
 * Super FX assembler emulator code (c) Copyright 1998 zsKnight and _Demo_.
 *
 * DSP1 emulator code (c) Copyright 1998 Ivar, _Demo_ and Gary Henderson.
 * DOS port code contains the works of other authors. See headers in
 * individual files.
 *
 * Snes9x homepage: www.snes9x.com
 *
 * Permission to use, copy, modify and distribute Snes9x in both binary and
 * source form, for non-commercial purposes, is hereby granted without fee,
 * providing that this license information and copyright notice appear with
 * all copies and any derived work.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event shall the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Snes9x is freeware for PERSONAL USE only. Commercial users should
 * seek permission of the copyright holders first. Commercial use includes
 * charging money for Snes9x or software derived from Snes9x.
 *
 * The copyright holders request that bug fixes and improvements to the code
 * should be forwarded to them so everyone can benefit from the modifications
 * in future versions.
 *
 * Super NES and Super Nintendo Entertainment System are trademarks of
 * Nintendo Co., Limited and its subsidiary companies.
 */

#ifndef _sa1_h_
#define _sa1_h_

#define AL A.B.l
#define AH A.B.h
#define XL X.B.l
#define XH X.B.h
#define YL Y.B.l
#define YH Y.B.h
#define SL S.B.l
#define SH S.B.h
#define DL D.B.l
#define DH D.B.h
#define PL P.B.l
#define PH P.B.h

#define SA1ClearCarry() (SA1._Carry = 0)
#define SA1SetCarry() (SA1._Carry = 1)
#define SA1SetZero() (SA1._Zero = 0)
#define SA1ClearZero() (SA1._Zero = 1)
#define SA1SetIRQ() (SA1.PL |= IRQ)
#define SA1ClearIRQ() (SA1.PL &= ~IRQ)
#define SA1SetDecimal() (SA1.PL |= Decimal)
#define SA1ClearDecimal() (SA1.PL &= ~Decimal)
#define SA1SetIndex() (SA1.PL |= IndexFlag)
#define SA1ClearIndex() (SA1.PL &= ~IndexFlag)
#define SA1SetMemory() (SA1.PL |= MemoryFlag)
#define SA1ClearMemory() (SA1.PL &= ~MemoryFlag)
#define SA1SetOverflow() (SA1._Overflow = 1)
#define SA1ClearOverflow() (SA1._Overflow = 0)
#define SA1SetNegative() (SA1._Negative = 0x80)
#define SA1ClearNegative() (SA1._Negative = 0)

#define SA1CheckZero() (SA1._Zero == 0)
#define SA1CheckCarry() (SA1._Carry)
#define SA1CheckIRQ() (SA1.PL & IRQ)
#define SA1CheckDecimal() (SA1.PL & Decimal)
#define SA1CheckIndex() (SA1.PL & IndexFlag)
#define SA1CheckMemory() (SA1.PL & MemoryFlag)
#define SA1CheckOverflow() (SA1._Overflow)
#define SA1CheckNegative() (SA1._Negative & 0x80)
#define SA1CheckEmulation() (SA1.P.W & Emulation)

#define SA1ClearFlags(f) (SA1.P.W &= ~(f))
#define SA1SetFlags(f)   (SA1.P.W |=  (f))
#define SA1CheckFlag(f)  (SA1.PL & (f))

typedef union
{
#ifdef LSB_FIRST
    struct { uint8 l,h; } B;
#else
    struct { uint8 h,l; } B;
#endif
    uint16 W;
} pair;

struct SRegisters{
    uint8  PB;
    uint8  DB;
    pair   P;
    pair   A;
    pair   D;
    pair   S;
    pair   X;
    pair   Y;
    uint16 PC;
};

EXTERN_C struct SRegisters Registers;

#endif
