# define Y_NL 257
# define Y_INT 258
# define Y_ID 259
# define Y_REG 260
# define Y_FP_REG 261
# define Y_STR 262
# define Y_FP 263
# define Y_ABS_D_OP 264
# define Y_ABS_S_OP 265
# define Y_ADDIU_OP 266
# define Y_ADDI_OP 267
# define Y_ADDU_OP 268
# define Y_ADD_D_OP 269
# define Y_ADD_OP 270
# define Y_ADD_S_OP 271
# define Y_ANDI_OP 272
# define Y_AND_OP 273
# define Y_BC0F_OP 274
# define Y_BC0T_OP 275
# define Y_BC1F_OP 276
# define Y_BC1T_OP 277
# define Y_BC2F_OP 278
# define Y_BC2T_OP 279
# define Y_BC3F_OP 280
# define Y_BC3T_OP 281
# define Y_BEQ_OP 282
# define Y_BGEZAL_OP 283
# define Y_BGEZ_OP 284
# define Y_BGTZ_OP 285
# define Y_BLEZ_OP 286
# define Y_BLTZAL_OP 287
# define Y_BLTZ_OP 288
# define Y_BNE_OP 289
# define Y_BREAK_OP 290
# define Y_CFC0_OP 291
# define Y_CFC1_OP 292
# define Y_CFC2_OP 293
# define Y_CFC3_OP 294
# define Y_COP0_OP 295
# define Y_COP1_OP 296
# define Y_COP2_OP 297
# define Y_COP3_OP 298
# define Y_CTC0_OP 299
# define Y_CTC1_OP 300
# define Y_CTC2_OP 301
# define Y_CTC3_OP 302
# define Y_CVT_D_S_OP 303
# define Y_CVT_D_W_OP 304
# define Y_CVT_S_D_OP 305
# define Y_CVT_S_W_OP 306
# define Y_CVT_W_D_OP 307
# define Y_CVT_W_S_OP 308
# define Y_C_EQ_D_OP 309
# define Y_C_EQ_S_OP 310
# define Y_C_F_D_OP 311
# define Y_C_F_S_OP 312
# define Y_C_LE_D_OP 313
# define Y_C_LE_S_OP 314
# define Y_C_LT_D_OP 315
# define Y_C_LT_S_OP 316
# define Y_C_NGE_D_OP 317
# define Y_C_NGE_S_OP 318
# define Y_C_NGLE_D_OP 319
# define Y_C_NGLE_S_OP 320
# define Y_C_NGL_D_OP 321
# define Y_C_NGL_S_OP 322
# define Y_C_NGT_D_OP 323
# define Y_C_NGT_S_OP 324
# define Y_C_OLT_D_OP 325
# define Y_C_OLT_S_OP 326
# define Y_C_OLE_D_OP 327
# define Y_C_OLE_S_OP 328
# define Y_C_SEQ_D_OP 329
# define Y_C_SEQ_S_OP 330
# define Y_C_SF_D_OP 331
# define Y_C_SF_S_OP 332
# define Y_C_UEQ_D_OP 333
# define Y_C_UEQ_S_OP 334
# define Y_C_ULT_D_OP 335
# define Y_C_ULT_S_OP 336
# define Y_C_ULE_D_OP 337
# define Y_C_ULE_S_OP 338
# define Y_C_UN_D_OP 339
# define Y_C_UN_S_OP 340
# define Y_DIVU_OP 341
# define Y_DIV_D_OP 342
# define Y_DIV_OP 343
# define Y_DIV_S_OP 344
# define Y_JALR_OP 345
# define Y_JAL_OP 346
# define Y_JR_OP 347
# define Y_J_OP 348
# define Y_LBU_OP 349
# define Y_LB_OP 350
# define Y_LHU_OP 351
# define Y_LH_OP 352
# define Y_LUI_OP 353
# define Y_LWC0_OP 354
# define Y_LWC1_OP 355
# define Y_LWC2_OP 356
# define Y_LWC3_OP 357
# define Y_LWL_OP 358
# define Y_LWR_OP 359
# define Y_LW_OP 360
# define Y_MFC0_OP 361
# define Y_MFC1_OP 362
# define Y_MFC2_OP 363
# define Y_MFC3_OP 364
# define Y_MFHI_OP 365
# define Y_MFLO_OP 366
# define Y_MOV_D_OP 367
# define Y_MOV_S_OP 368
# define Y_MTC0_OP 369
# define Y_MTC1_OP 370
# define Y_MTC2_OP 371
# define Y_MTC3_OP 372
# define Y_MTHI_OP 373
# define Y_MTLO_OP 374
# define Y_MULTU_OP 375
# define Y_MULT_OP 376
# define Y_MUL_D_OP 377
# define Y_MUL_S_OP 378
# define Y_NEG_D_OP 379
# define Y_NEG_S_OP 380
# define Y_NOR_OP 381
# define Y_ORI_OP 382
# define Y_OR_OP 383
# define Y_PFW_OP 384
# define Y_RFE_OP 385
# define Y_SB_OP 386
# define Y_SH_OP 387
# define Y_SLLV_OP 388
# define Y_SLL_OP 389
# define Y_SLTIU_OP 390
# define Y_SLTI_OP 391
# define Y_SLTU_OP 392
# define Y_SLT_OP 393
# define Y_SRAV_OP 394
# define Y_SRA_OP 395
# define Y_SRLV_OP 396
# define Y_SRL_OP 397
# define Y_SUBU_OP 398
# define Y_SUB_D_OP 399
# define Y_SUB_OP 400
# define Y_SUB_S_OP 401
# define Y_SWC0_OP 402
# define Y_SWC1_OP 403
# define Y_SWC2_OP 404
# define Y_SWC3_OP 405
# define Y_SWL_OP 406
# define Y_SWR_OP 407
# define Y_SW_OP 408
# define Y_SYSCALL_OP 409
# define Y_TLBP_OP 410
# define Y_TLBR_OP 411
# define Y_TLBWI_OP 412
# define Y_TLBWR_OP 413
# define Y_XORI_OP 414
# define Y_XOR_OP 415
# define Y_ABS_POP 416
# define Y_BAL_POP 417
# define Y_BEQZ_POP 418
# define Y_BGEU_POP 419
# define Y_BGE_POP 420
# define Y_BGTU_POP 421
# define Y_BGT_POP 422
# define Y_BLEU_POP 423
# define Y_BLE_POP 424
# define Y_BLTU_POP 425
# define Y_BLT_POP 426
# define Y_BNEZ_POP 427
# define Y_B_POP 428
# define Y_LA_POP 429
# define Y_LD_POP 430
# define Y_LI_POP 431
# define Y_LI_D_POP 432
# define Y_LI_S_POP 433
# define Y_L_D_POP 434
# define Y_L_S_POP 435
# define Y_MFC1_D_POP 436
# define Y_MTC1_D_POP 437
# define Y_MOVE_POP 438
# define Y_MULOU_POP 439
# define Y_MULO_POP 440
# define Y_MUL_POP 441
# define Y_NEGU_POP 442
# define Y_NEG_POP 443
# define Y_NOP_POP 444
# define Y_NOT_POP 445
# define Y_REMU_POP 446
# define Y_REM_POP 447
# define Y_ROL_POP 448
# define Y_ROR_POP 449
# define Y_SD_POP 450
# define Y_SEQ_POP 451
# define Y_SGEU_POP 452
# define Y_SGE_POP 453
# define Y_SGTU_POP 454
# define Y_SGT_POP 455
# define Y_SLEU_POP 456
# define Y_SLE_POP 457
# define Y_SNE_POP 458
# define Y_S_D_POP 459
# define Y_S_S_POP 460
# define Y_ULHU_POP 461
# define Y_ULH_POP 462
# define Y_ULW_POP 463
# define Y_USH_POP 464
# define Y_USW_POP 465
# define Y_ALIAS_DIR 466
# define Y_ALIGN_DIR 467
# define Y_ASCII_DIR 468
# define Y_ASCIIZ_DIR 469
# define Y_ASM0_DIR 470
# define Y_BGNB_DIR 471
# define Y_BYTE_DIR 472
# define Y_COMM_DIR 473
# define Y_DATA_DIR 474
# define Y_DOUBLE_DIR 475
# define Y_ENDB_DIR 476
# define Y_ENDR_DIR 477
# define Y_END_DIR 478
# define Y_ENT_DIR 479
# define Y_ERR_DIR 480
# define Y_EXTERN_DIR 481
# define Y_FILE_DIR 482
# define Y_FLOAT_DIR 483
# define Y_FMASK_DIR 484
# define Y_FRAME_DIR 485
# define Y_GLOBAL_DIR 486
# define Y_HALF_DIR 487
# define Y_K_TEXT_DIR 488
# define Y_K_DATA_DIR 489
# define Y_LABEL_DIR 490
# define Y_LCOMM_DIR 491
# define Y_LIVEREG_DIR 492
# define Y_LOC_DIR 493
# define Y_MASK_DIR 494
# define Y_NOALIAS_DIR 495
# define Y_OPTIONS_DIR 496
# define Y_RDATA_DIR 497
# define Y_REPEAT_DIR 498
# define Y_SDATA_DIR 499
# define Y_SET_DIR 500
# define Y_SPACE_DIR 501
# define Y_STRUCT_DIR 502
# define Y_TEXT_DIR 503
# define Y_VERSTAMP_DIR 504
# define Y_VREG_DIR 505
# define Y_WORD_DIR 506

# line 292 "parser.y"
#include <stdio.h>

#include "spim.h"
#include "spim-utils.h"
#include "inst.h"
#include "mem.h"
#include "reg.h"
#include "sym-tbl.h"
#include "data.h"
#include "scanner.h"
#include "parser.h"


/* return (0) */
#define LINE_PARSE_DONE YYACCEPT

/* return (1) */
#define FILE_PARSE_DONE YYABORT

typedef struct ll
{
  label *head;
  struct ll *tail;
} label_list;


/* Exported Variables: */

int data_dir;			/* Non-zero means item in data segment */

int text_dir;			/* Non-zero means item in text segment */


/* Local functions: */

#ifdef __STDC__
static imm_expr *branch_offset (int n_inst);
static void clear_labels (void);
static label_list *cons_label (label *head, label_list *tail);
static void div_inst (int op, int rd, int rs, int rt, int const_divisor);
static void mult_inst (int op, int rd, int rs, int rt);
static void nop_inst (void);
static void set_eq_inst (int op, int rd, int rs, int rt);
static void set_ge_inst (int op, int rd, int rs, int rt);
static void set_gt_inst (int op, int rd, int rs, int rt);
static void set_le_inst (int op, int rd, int rs, int rt);
static void store_word_data (int value);
static void trap_inst (void);
#else
static imm_expr *branch_offset ();
static void clear_labels ();
static label_list *cons_label ();
static void div_inst ();
static void mult_inst ();
static void nop_inst ();
static void set_eq_inst ();
static void set_ge_inst ();
static void set_gt_inst ();
static void set_le_inst ();
static void store_word_data ();
static void trap_inst ();
#endif


/* Local variables: */

static int null_term;		/* Non-zero means string terminate by \0 */

static void (*store_op) ();	/* Function to store items in an EXPR_LST */

static label_list *this_line_labels = NULL; /* List of label for curent line */

static int noat_flag = 0;	/* Non-zero means program can use $1 */

static char *input_file_name;	/* Name of file being parsed */



#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 2042 "parser.y"


/* Maintain and update the address of labels for the current line. */

#ifdef __STDC__
void
fix_current_label_address (mem_addr new_addr)
#else
void
fix_current_label_address (new_addr)
     mem_addr new_addr;
#endif
{
  label_list *l;

  for (l = this_line_labels; l != NULL; l = l->tail)
    {
      l->head->addr = new_addr;
    }
  clear_labels ();
}


#ifdef __STDC__
static label_list *
cons_label (label *head, label_list *tail)
#else
static label_list *
cons_label (head, tail)
     label *head;
     label_list *tail;
#endif
{
  label_list *c = (label_list *) malloc (sizeof (label_list));

  c->head = head;
  c->tail = tail;
  return (c);
}


#ifdef __STDC__
static void
clear_labels (void)
#else
static void
clear_labels ()
#endif
{
  label_list *n;

  for ( ; this_line_labels != NULL; this_line_labels = n)
    {
      resolve_label_uses(this_line_labels->head);
      n = this_line_labels->tail;
      free (this_line_labels);
    }
}


/* Operations on op codes. */

#ifdef __STDC__
int
op_to_imm_op (int opcode)
#else
int
op_to_imm_op (opcode)
     int opcode;
#endif
{
  switch (opcode)
    {
    case Y_ADD_OP: return (Y_ADDI_OP);
    case Y_ADDU_OP: return (Y_ADDIU_OP);
    case Y_AND_OP: return (Y_ANDI_OP);
    case Y_OR_OP: return (Y_ORI_OP);
    case Y_XOR_OP: return (Y_XORI_OP);
    case Y_SLT_OP: return (Y_SLTI_OP);
    case Y_SLTU_OP: return (Y_SLTIU_OP);
    case Y_SLLV_OP: return (Y_SLL_OP);
    case Y_SRAV_OP: return (Y_SRA_OP);
    case Y_SRLV_OP: return (Y_SRL_OP);
    default: fatal_error ("Can't convert op to immediate op\n"); return (0);
    }
}


#ifdef __STDC__
int
imm_op_to_op (int opcode)
#else
int
imm_op_to_op (opcode)
     int opcode;
#endif
{
  switch (opcode)
    {
    case Y_ADDI_OP: return (Y_ADD_OP);
    case Y_ADDIU_OP: return (Y_ADDU_OP);
    case Y_ANDI_OP: return (Y_AND_OP);
    case Y_ORI_OP: return (Y_OR_OP);
    case Y_XORI_OP: return (Y_XOR_OP);
    case Y_SLTI_OP: return (Y_SLT_OP);
    case Y_SLTIU_OP: return (Y_SLTU_OP);
    case Y_J_OP: return (Y_JR_OP);
    case Y_LUI_OP: return (Y_ADDU_OP);
    case Y_SLL_OP: return (Y_SLLV_OP);
    case Y_SRA_OP: return (Y_SRAV_OP);
    case Y_SRL_OP: return (Y_SRLV_OP);
    default: fatal_error ("Can't convert immediate op to op\n"); return (0);
    }
}


#ifdef __STDC__
static void
nop_inst (void)
#else
static void
nop_inst ()
#endif
{
  r_type_inst (Y_OR_OP, 0, 0, 0);
}


#ifdef __STDC__
static void
trap_inst (void)
#else
static void
trap_inst ()
#endif
{
  r_type_inst (Y_BREAK_OP, 0, 0, 0);
}


#ifdef __STDC__
static imm_expr *
branch_offset (int n_inst)
#else
static imm_expr *
branch_offset (n_inst)
     int n_inst;
#endif
{
  return (const_imm_expr (n_inst << 2)); /* Later shifted right 2 places */
}


#ifdef __STDC__
static void
div_inst (int op, int rd, int rs, int rt, int const_divisor)
#else
static void
div_inst (op, rd, rs, rt, const_divisor)
     int op, rd, rs, rt, const_divisor;
#endif
{
  if (rd != 0 && !const_divisor)
    {
      i_type_inst_free (Y_BNE_OP, 0, rt, branch_offset (2));
      trap_inst ();
    }
  if (op == Y_DIV_OP || op == Y_REM_POP)
    r_type_inst (Y_DIV_OP, 0, rs, rt);
  else
    r_type_inst (Y_DIVU_OP, 0, rs, rt);
  if (rd != 0)
    {
      if (op == Y_DIV_OP || op == Y_DIVU_OP)
	r_type_inst (Y_MFLO_OP, rd, 0, 0);
      else
	r_type_inst (Y_MFHI_OP, rd, 0, 0);
    }
}


#ifdef __STDC__
static void
mult_inst (int op, int rd, int rs, int rt)
#else
static void
mult_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  if (op == Y_MULOU_POP)
    r_type_inst (Y_MULTU_OP, 0, rs, rt);
  else
    r_type_inst (Y_MULT_OP, 0, rs, rt);
  if (op == Y_MULOU_POP && rd != 0)
    {
      r_type_inst (Y_MFHI_OP, 1, 0, 0);	/* Use $at */
      i_type_inst_free (Y_BEQ_OP, 0, 1, branch_offset (2));
      trap_inst ();
    }
  else if (op == Y_MULO_POP && rd != 0)
    {
      r_type_inst (Y_MFHI_OP, 1, 0, 0); /* use $at */
      r_type_inst (Y_MFLO_OP, rd, 0, 0);
      r_sh_type_inst (Y_SRA_OP, rd, rd, 31);
      i_type_inst_free (Y_BEQ_OP, rd, 1, branch_offset (2));
      trap_inst ();
    }
  if (rd != 0)
    r_type_inst (Y_MFLO_OP, rd, 0, 0);
}


#ifdef __STDC__
static void
set_le_inst (int op, int rd, int rs, int rt)
#else
static void
set_le_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  i_type_inst_free (Y_BNE_OP, rs, rt, branch_offset (3));
  i_type_inst_free (Y_ORI_OP, rd, 0, const_imm_expr (1));
  i_type_inst_free (Y_BEQ_OP, 0, 0, branch_offset (2));
  r_type_inst ((op == Y_SLE_POP ? Y_SLT_OP : Y_SLTU_OP), rd, rs, rt);
}


#ifdef __STDC__
static void
set_gt_inst (int op, int rd, int rs, int rt)
#else
static void
set_gt_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  r_type_inst (op == Y_SGT_POP ? Y_SLT_OP : Y_SLTU_OP, rd, rt, rs);
}


#ifdef __STDC__
static void
set_ge_inst (int op, int rd, int rs, int rt)
#else
static void
set_ge_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  i_type_inst_free (Y_BNE_OP, rs, rt, branch_offset (3));
  i_type_inst_free (Y_ORI_OP, rd, 0, const_imm_expr (1));
  i_type_inst_free (Y_BEQ_OP, 0, 0, branch_offset (2));
  r_type_inst (op == Y_SGE_POP ? Y_SLT_OP : Y_SLTU_OP, rd, rt, rs);
}


#ifdef __STDC__
static void
set_eq_inst (int op, int rd, int rs, int rt)
#else
static void
set_eq_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  imm_expr *if_eq, *if_neq;

  if (op == Y_SEQ_POP)
    if_eq = const_imm_expr (1), if_neq = const_imm_expr (0);
  else
    if_eq = const_imm_expr (0), if_neq = const_imm_expr (1);

  i_type_inst_free (Y_BEQ_OP, rs, rt, branch_offset (3));
  /* RD <- 0 (if not equal) */
  i_type_inst_free (Y_ORI_OP, rd, 0, if_neq);
  i_type_inst_free (Y_BEQ_OP, 0, 0, branch_offset (2)); /* Branch always */
  /* RD <- 1 */
  i_type_inst_free (Y_ORI_OP, rd, 0, if_eq);
}


/* Store the value either as a datum or instruction. */

#ifdef __STDC__
static void
store_word_data (int value)
#else
static void
store_word_data (value)
     int value;
#endif
{
  if (data_dir)
    store_word (value);
  else if (text_dir)
    store_instruction (inst_decode (value));
}



#ifdef __STDC__
void
initialize_parser (char *file_name)
#else
void
initialize_parser (file_name)
     char *file_name;
#endif
{
  input_file_name = file_name;
  only_id = 0;
  data_dir = 0;
  text_dir = 1;
}


#ifdef __STDC__
void
yyerror (char *s)
#else
void
yyerror (s)
     char *s;
#endif
{
  error ("spim: (parser) %s on line %d of file %s\n",
	 s, line_no, input_file_name);
  print_erroneous_line ();
}
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	259, 383,
	-2, 12,
-1, 352,
	260, 355,
	-2, 353,
-1, 378,
	259, 383,
	-2, 382,
-1, 482,
	257, 284,
	-2, 370,
-1, 496,
	257, 306,
	-2, 370,
-1, 504,
	257, 329,
	-2, 370,
	};
# define YYNPROD 385
# define YYLAST 879
yytabelem yyact[]={

    11,   411,   483,   410,   479,   473,   482,   240,   239,   154,
   153,   144,   242,   143,   241,   155,   145,   187,   183,   188,
   184,   189,   185,   190,   186,   199,   192,   191,   193,   194,
   196,   195,   200,    28,   231,   232,   233,   234,   486,   558,
   478,   457,   235,   236,   237,   238,   249,   250,   251,   252,
   253,   254,   275,   259,   273,   257,   287,   271,   285,   269,
   286,   270,   282,   266,   284,   268,   288,   272,   277,   261,
   278,   262,   283,   267,   281,   265,   276,   260,   279,   263,
   280,   264,   274,   258,   167,   244,   166,   243,   212,   211,
   210,   209,   112,   111,   114,   113,   123,   120,   126,   121,
   122,   116,   117,   115,   221,   222,   224,   225,   217,   218,
   216,   215,   226,   227,   229,   230,   219,   220,   174,   173,
   246,   245,   256,   255,   163,   156,   147,   119,   141,   129,
   130,   150,   160,   159,   158,   149,   148,   151,   161,   152,
   162,   165,   248,   164,   247,   135,   138,   136,   137,   132,
   133,   131,   142,   366,   412,   487,   419,   157,   146,    30,
   214,   197,   204,   203,   202,   201,   208,   207,   206,   205,
   198,   213,    15,   118,    16,    17,    18,   128,   127,   223,
   228,    34,   172,   171,   170,    32,    31,    29,    33,   169,
   168,    45,    44,   134,   181,   180,   179,   178,   177,   176,
   175,   182,   140,   139,   125,   124,    19,    25,    24,    70,
    71,    72,    73,    74,    75,    76,    77,    78,    80,    82,
    83,    81,    84,    86,    85,    87,    88,    89,    90,    91,
    92,   107,    79,    93,    94,    95,    96,    97,    98,    99,
   101,   100,   102,   103,   104,   105,   106,   108,   109,   110,
   333,   418,   305,   480,   395,   492,   306,   413,   399,   400,
     6,   316,   407,   296,   297,   296,   296,   296,   299,   300,
   296,   296,   412,   312,   506,   312,   312,   501,   519,   317,
   297,   296,   296,   296,   296,   296,   296,   296,   296,   296,
   296,   296,   296,   296,   477,   296,   296,   296,   296,   296,
   296,   517,   436,   297,   297,   340,   393,   417,   341,   352,
   298,   365,   356,   356,   356,   512,   341,   341,   292,   587,
   415,   572,   317,   571,   570,   560,   367,   503,   434,   368,
   438,   364,   441,   443,   313,   373,   502,   500,   499,   498,
   495,   385,   380,   381,   494,   490,   406,   403,   402,   386,
   401,   388,   389,   397,   396,   392,   391,   394,   368,   390,
   404,   398,   368,   368,   349,   353,   384,   382,   379,   475,
   476,   354,   415,   414,   297,   359,   375,   374,   371,   318,
   294,   293,   584,   579,   556,   554,   446,   460,   462,   464,
   466,   589,   588,   290,   496,   355,   291,   564,   311,   304,
   565,   510,   566,   511,   562,     8,   581,   563,   580,   573,
   507,   481,   504,   567,   509,   583,   582,   488,   307,   378,
     7,   310,   493,   314,   315,   289,   484,   458,   505,   408,
   405,   387,   383,   377,   376,   372,   370,   515,   369,    69,
    68,   518,    67,    66,   522,    65,   524,    64,   526,   528,
    63,    62,   530,   532,   534,   536,   538,   540,   357,   358,
    61,    60,   543,    59,   332,   360,   361,   362,   363,   351,
    58,    57,    56,    55,    54,    53,    52,    51,   552,    50,
    49,    48,    47,   553,    46,   555,   553,    43,    42,    41,
   415,   414,   415,   508,    40,    39,    38,    37,    36,   555,
    35,    27,    26,    23,    22,    21,    20,   555,    14,    13,
    12,    10,   568,   569,     9,     5,   342,   343,   344,   345,
   346,   347,   348,   350,     4,     3,     2,   485,     1,     0,
   513,     0,     0,     0,     0,   491,     0,     0,     0,     0,
     0,     0,     0,   497,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   409,     0,     0,     0,   416,     0,   577,   578,     0,
     0,   420,   421,   422,   423,     0,   424,   425,   426,   427,
     0,     0,     0,   447,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   447,   447,   447,   447,   447,
   341,   341,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   317,   317,   474,   474,   474,     0,     0,
     0,     0,   471,   472,     0,     0,     0,     0,     0,     0,
     0,   368,     0,     0,     0,     0,   489,     0,   557,   368,
     0,     0,     0,     0,     0,     0,     0,   368,   454,   455,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   468,     0,     0,     0,   469,
   470,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   447,     0,   447,     0,     0,     0,
   447,   447,     0,   447,     0,   447,   447,     0,     0,   447,
   447,   447,   447,   447,   447,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   341,   341,     0,   341,   341,   341,
   341,   341,   341,   341,   341,   474,     0,     0,     0,     0,
     0,   456,   459,   461,   463,   465,     0,     0,     0,     0,
     0,     0,   368,     0,     0,     0,   559,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   561,     0,     0,
     0,     0,   541,   542,     0,   544,   545,   546,   547,   548,
   549,   550,   551,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   428,   429,   430,   431,   432,   433,
   435,   437,   439,   440,   442,   444,   445,     0,     0,   448,
   449,   450,   451,   452,   453,     0,     0,     0,     0,     0,
     0,     0,     0,   574,     0,   576,   467,     0,     0,     0,
   514,   575,   516,     0,     0,     0,   520,   521,   295,   523,
     0,   525,   527,   585,   586,   529,   531,   533,   535,   537,
   539,     0,     0,   301,   302,   303,     0,     0,   308,   309,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   319,
   320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
   330,   331,     0,   334,   335,   336,   337,   338,   339 };
yytabelem yypact[]={

-10000000,-10000000,  -257,-10000000,  -257,-10000000,   335,-10000000,    59,   124,
   123,-10000000,     4,     8,     4,     4,     4,    -5,    -5,     4,
     4,    -5,     4,     8,     4,     4,    -5,-10000000,   121,-10000000,
     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
-10000000,     4,     4,     4,     4,     4,     4,     4,     4,-10000000,
     8,     4,     4,     4,     8,    -5,    -5,    -5,    -5,    -5,
    51,    68,-10000000,-10000000,-10000000,   120,-10000000,-10000000,   119,   118,
-10000000,-10000000,   110,-10000000,-10000000,-10000000,-10000000,   109,-10000000,   108,
     4,-10000000,-10000000,-10000000,-10000000,   101,    98,    97,    46,-10000000,
    68,    96,    95,-10000000,    68,    68,    92,    90,    89,     4,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,    88,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,   232,-10000000,   232,   -12,-10000000,-10000000,  -107,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,     4,
     4,     4,     4,     4,   114,    44,   114,     4,   114,   114,
     4,     4,     4,-10000000,     4,     4,     4,     4,     4,     4,
-10000000,-10000000,-10000000,-10000000,     4,     4,     4,     4,     4,-10000000,
-10000000,     4,-10000000,-10000000,     8,-10000000,-10000000,-10000000,     8,     8,
    -5,    -5,    -5,    -5,    -5,    34,-10000000,-10000000,-10000000,    -9,
    -9,-10000000,-10000000,    68,-10000000,-10000000,  -108,-10000000,-10000000,-10000000,
    87,    68,    -7,  -108,    86,    82,-10000000,-10000000,-10000000,    68,
    81,    80,    79,    17,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,    78,    69,-10000000,-10000000,-10000000,   234,-10000000,
-10000000,-10000000,    62,-10000000,   358,   272,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,   114,-10000000,    43,-10000000,   232,-10000000,    20,
   114,-10000000,   114,-10000000,   114,   114,-10000000,-10000000,   114,   114,
   114,   114,   114,   114,-10000000,-10000000,-10000000,-10000000,   232,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,    -5,-10000000,-10000000,-10000000,-10000000,-10000000,    -9,-10000000,
   327,    -9,-10000000,   326,    68,-10000000,  -224,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,  -224,-10000000,     4,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,    67,-10000000,-10000000,     4,   364,   357,   372,
    62,    62,    66,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,    65,-10000000,    63,-10000000,-10000000,-10000000,
-10000000,   368,     4,-10000000,     4,    62,    62,   321,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,   367,-10000000,   365,   376,   375,   320,
-10000000,-10000000,     4,     4,    61,   351,   350,-10000000,-10000000,-10000000 };
yytabelem yypgo[]={

     0,   528,   526,   525,   524,   420,   515,   257,   514,   511,
   510,   828,   262,   509,   310,   508,     3,   399,   506,   505,
   504,   398,   503,   502,   261,   501,   464,   500,   386,   498,
   497,   496,   495,   494,   489,   488,   487,   484,   482,   481,
   480,   479,   305,   477,   476,   475,    41,   474,   473,   472,
   471,   470,   469,   463,   461,   460,   395,   451,   450,   447,
   445,   443,     5,   442,   440,   439,   153,   438,    40,   436,
   435,     6,   434,    38,   433,   432,   250,   431,   430,   429,
   428,     1,   427,   252,     4,     2,   426,   419,   417,   405 };
yytabelem yyr1[]={

     0,     2,     1,     3,     3,     4,     4,     4,     5,     5,
     5,     6,     6,     8,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    13,    13,    13,    15,
    18,    18,    19,    19,    19,    20,    20,    20,    20,    20,
    20,    22,    22,    22,    23,    23,    23,    25,    25,    27,
    27,    27,    27,    27,    27,    27,    29,    29,    29,    30,
    30,    30,    30,    30,    30,    30,    31,    31,    31,    32,
    33,    33,    34,    34,    34,    34,    35,    35,    35,    37,
    37,    38,    38,    39,    39,    40,    40,    36,    36,    41,
    41,    41,    41,    41,    41,    41,    41,    43,    43,    43,
    43,    43,    43,    44,    44,    45,    45,    47,    47,    48,
    48,    49,    49,    50,    50,    51,    51,    51,    51,    53,
    53,    54,    54,    55,    55,    57,    57,    58,    58,    58,
    58,    58,    58,    58,    58,    58,    58,    59,    59,    59,
    59,    59,    59,    59,    59,    60,    60,    61,    61,    61,
    61,    61,    61,    61,    61,    63,    63,    63,    63,    63,
    63,    64,    64,    65,    65,    65,    65,    65,    65,    65,
    65,    65,    65,    65,    65,    65,    65,    65,    65,    65,
    65,    65,    65,    65,    65,    65,    65,    65,    65,    65,
    65,    65,    65,    65,    65,     9,     9,    67,     9,    69,
     9,     9,     9,    70,     9,     9,     9,     9,     9,     9,
    72,     9,     9,     9,     9,     9,     9,     9,     9,     9,
    75,     9,     9,     9,     9,    77,     9,     9,     9,     9,
     9,     9,     9,     9,     9,     9,     9,     9,     9,     9,
     9,     9,     9,     9,     9,     9,     9,     9,    78,     9,
    79,    12,    80,    80,    80,    80,    80,    80,    80,    80,
    80,    80,    82,    46,    16,    16,    16,    16,    16,    81,
    81,    81,    11,    26,    28,    52,    56,    21,    76,    17,
    24,    62,    83,    14,    14,    42,    68,    68,    84,    84,
    86,    85,    66,    66,    71,    71,    71,    73,    73,    87,
    74,    88,    88,    89,     7 };
yytabelem yyr2[]={

     0,     1,     4,     4,     2,     5,     7,     0,     5,     5,
     3,     2,     1,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     3,     5,
     3,     7,     7,     7,     7,     7,     9,     9,     7,     9,
     9,     7,     9,     7,     9,     9,     9,     9,     7,     9,
     9,     7,     7,     9,     9,     9,     9,     7,     9,     9,
     9,     9,     9,     9,     9,     9,     9,     9,     9,     9,
     5,     7,     7,     9,     9,     9,     9,     9,     9,     9,
     9,     9,     9,     5,     5,     7,     5,     7,     5,     5,
     7,     7,     7,     9,     7,     7,     7,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     6,     5,     1,     7,     1,
     7,     2,     4,     1,     7,     7,     3,     5,     3,     5,
     1,     7,     4,     4,     2,     4,     6,     7,     3,     6,
     1,     7,     6,     8,     5,     1,     7,     5,     7,     6,
     6,     6,     6,     4,     5,     3,     5,     3,     5,     5,
     5,     5,     3,     5,     3,     5,     6,     8,     1,     6,
     1,     5,     7,     3,     9,     3,     9,     7,     7,     7,
    13,    13,     1,     5,     3,    13,     3,     7,     7,     2,
     7,     5,     2,     2,     2,     2,     2,     2,     3,     2,
     2,     2,     3,     2,     2,     3,     4,     2,     3,     7,
     1,     5,     2,     3,     5,     3,     7,     5,     3,     1,
     5,     2,     1,     1,     5 };
yytabelem yychk[]={

-10000000,    -1,    -2,    -3,    -4,    -6,    -7,    -5,   -89,    -8,
    -9,   257,   -10,   -13,   -15,   429,   431,   432,   433,   463,
   -18,   -19,   -20,   -22,   465,   464,   -23,   -25,   290,   444,
   416,   443,   442,   445,   438,   -27,   -29,   -30,   -31,   -32,
   -33,   -34,   -35,   -36,   449,   448,   -37,   -38,   -39,   -40,
   -41,   -43,   -44,   -45,   -47,   -48,   -49,   -50,   -51,   -53,
   -54,   -55,   -57,   -58,   -59,   -60,   -61,   -63,   -64,   -65,
   466,   467,   468,   469,   470,   471,   472,   473,   474,   489,
   475,   478,   476,   477,   479,   481,   480,   482,   483,   484,
   485,   486,   487,   490,   491,   492,   493,   494,   495,   496,
   498,   497,   499,   500,   501,   502,   503,   488,   504,   505,
   506,   350,   349,   352,   351,   360,   358,   359,   430,   384,
   354,   356,   357,   353,   462,   461,   355,   435,   434,   386,
   387,   408,   406,   407,   450,   402,   404,   405,   403,   460,
   459,   385,   409,   270,   268,   273,   415,   383,   393,   392,
   388,   394,   396,   267,   266,   272,   382,   414,   391,   390,
   389,   395,   397,   381,   400,   398,   343,   341,   447,   446,
   441,   440,   439,   376,   375,   457,   456,   455,   454,   453,
   452,   451,   458,   275,   277,   279,   281,   274,   276,   278,
   280,   284,   283,   285,   286,   288,   287,   418,   427,   282,
   289,   422,   421,   420,   419,   426,   425,   424,   423,   348,
   347,   346,   345,   428,   417,   368,   367,   365,   366,   373,
   374,   361,   362,   436,   363,   364,   369,   370,   437,   371,
   372,   291,   292,   293,   294,   299,   300,   301,   302,   265,
   264,   271,   269,   344,   342,   378,   377,   401,   399,   303,
   304,   305,   306,   307,   308,   380,   379,   312,   340,   310,
   334,   326,   328,   336,   338,   332,   320,   330,   322,   316,
   318,   314,   324,   311,   339,   309,   333,   325,   327,   335,
   337,   331,   319,   329,   321,   315,   317,   313,   323,    -5,
    58,    61,   259,   257,   257,   -11,   -76,   260,   -14,   260,
   261,   -11,   -11,   -11,   -17,   -83,   261,   -17,   -11,   -11,
   -17,   -21,   -76,   -14,   -21,   -21,   -24,   -83,   258,   -11,
   -11,   -11,   -11,   -11,   -11,   -11,   -11,   -11,   -11,   -11,
   -11,   -11,   -26,   -76,   -11,   -11,   -11,   -11,   -11,   -11,
   -42,    -7,   -26,   -26,   -26,   -26,   -26,   -26,   -26,   -42,
   -26,   -52,   -76,   -42,   -14,   -56,   -76,   -56,   -56,   -14,
   -17,   -17,   -17,   -17,   -24,   260,   -66,   258,    -7,   -67,
   -69,   258,   -70,    -7,   258,   258,   -72,   -74,   -87,   258,
    -7,    -7,   258,   -75,   258,   -76,    -7,   -77,    -7,    -7,
   258,   258,   258,   260,    -7,   -66,   258,   258,    -7,   -66,
   -66,   258,   258,   258,   -76,   -78,   258,   -12,   -79,   -12,
   -16,   -81,    40,    -7,   259,   258,   -12,   -16,   263,   263,
   -12,   -12,   -12,   -12,   -12,   -12,   -12,   -12,   -26,   -26,
   -26,   -26,   -26,   -26,   -16,   -26,   258,   -26,   -16,   -26,
   -26,   -16,   -26,   -16,   -26,   -26,   -28,   -76,   -26,   -26,
   -26,   -26,   -26,   -26,   -42,   -42,   -28,   -46,   -82,   -28,
   -46,   -28,   -46,   -28,   -46,   -28,   -46,   -26,   -14,   -14,
   -14,   -24,   -24,   -62,   -83,   -62,   -62,   260,   -68,   -84,
   262,   -68,   -71,   -85,   -86,   -66,   -73,   263,   -88,    -7,
   258,   -66,   262,   -73,   258,   258,   -71,   -66,   258,   258,
   258,   260,   258,   258,   -71,   -80,    40,   -81,   259,   -81,
    43,    45,    43,   258,   -28,   -16,   -28,   258,   -16,   258,
   -28,   -28,   -16,   -28,   -16,   -28,   -16,   -28,   -16,   -28,
   -16,   -28,   -16,   -28,   -16,   -28,   -16,   -28,   -16,   -28,
   -16,   -42,   -42,   -16,   -42,   -42,   -42,   -42,   -42,   -42,
   -42,   -42,   -62,   -84,    58,   -85,    58,   -66,   263,   -76,
   258,   -76,    40,    43,    40,    43,    45,    41,   -81,   -81,
   258,   258,   258,    41,   -76,    -7,   -76,   -81,   -81,    62,
    41,    41,    40,    40,    62,   -76,   -76,   258,    41,    41 };
yytabelem yydef[]={

     1,    -2,    -2,     2,     0,     4,     0,    11,     0,     0,
     0,    10,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    28,     0,    30,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   383,     0,     0,     0,     0,     0,     0,     0,   383,   383,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   383,   277,   279,   281,     0,   283,   383,   286,   288,
   290,   379,     0,   294,   383,   383,   298,     0,   300,     0,
     0,   383,   305,   383,   383,     0,     0,     0,     0,   383,
   383,   315,   317,   383,   383,   383,   322,   324,     0,     0,
   328,    97,    98,    99,   100,   101,   102,   103,   104,   105,
   106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
   116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
   126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
   136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
   146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
   156,   157,   158,   167,   168,   159,   160,   161,   162,   163,
   164,   165,   166,   169,   170,   171,   172,   173,   174,   175,
   176,   177,   178,   179,   180,   181,   182,   183,   184,   185,
   186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
   196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
   206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
   216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
   226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
   236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
   246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
   256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
   266,   267,   268,   269,   270,   271,   272,   273,   274,     3,
     5,     0,   384,     8,     9,   330,   352,   358,   330,   363,
   364,     0,   330,     0,     0,   359,   362,     0,   330,   330,
   330,   330,   357,   330,   330,   330,   330,   360,    29,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   353,     0,     0,     0,     0,     0,     0,
    70,   365,   383,   383,   342,   342,   342,   342,   342,    83,
    84,     0,    -2,    86,     0,    88,   356,    89,     0,     0,
     0,     0,     0,     0,     0,     0,   276,   372,   373,     0,
     0,   282,   370,   383,   287,   289,     0,   292,    -2,   293,
   295,   383,     0,     0,     0,     0,   304,   370,   307,   383,
     0,     0,     0,     0,   313,   314,   316,   318,   319,   320,
   321,   323,   325,     0,     0,   370,     6,    13,     0,    14,
    15,   344,     0,   346,     0,   349,    16,    17,    18,    19,
    20,    21,    22,    23,    24,    25,    26,    27,    31,    32,
    33,    34,    35,     0,    38,     0,    41,     0,    43,     0,
     0,    48,     0,    51,    52,     0,    57,   354,     0,     0,
     0,     0,     0,     0,    71,    72,   383,   383,     0,   383,
   383,   383,   383,   383,   383,   383,   383,    85,    87,    90,
    91,    92,     0,    94,   361,    95,    96,   275,   278,   367,
   368,   280,    -2,   375,   383,   285,   291,   378,   380,   381,
   296,   297,   299,   301,   302,     0,    -2,   308,   309,   310,
   311,   312,   326,     0,    -2,   331,     0,   333,   335,     0,
     0,     0,     0,   351,    36,    37,    39,    40,    42,    44,
    45,    46,    47,    49,    50,    53,    54,    55,    56,    58,
    60,    59,    61,    62,    63,    64,    65,    66,    67,    68,
    69,    73,    74,   343,    75,    76,    77,    78,    79,    80,
    81,    82,    93,   366,     0,   374,     0,   371,   377,   303,
   327,     0,     0,   383,     0,     0,     0,     0,   347,   348,
   350,   369,   376,   332,     0,   338,     0,   337,   339,     0,
   334,   336,     0,     0,     0,     0,     0,   345,   340,   341 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"Y_NL",	257,
	"Y_INT",	258,
	"Y_ID",	259,
	"Y_REG",	260,
	"Y_FP_REG",	261,
	"Y_STR",	262,
	"Y_FP",	263,
	"Y_ABS_D_OP",	264,
	"Y_ABS_S_OP",	265,
	"Y_ADDIU_OP",	266,
	"Y_ADDI_OP",	267,
	"Y_ADDU_OP",	268,
	"Y_ADD_D_OP",	269,
	"Y_ADD_OP",	270,
	"Y_ADD_S_OP",	271,
	"Y_ANDI_OP",	272,
	"Y_AND_OP",	273,
	"Y_BC0F_OP",	274,
	"Y_BC0T_OP",	275,
	"Y_BC1F_OP",	276,
	"Y_BC1T_OP",	277,
	"Y_BC2F_OP",	278,
	"Y_BC2T_OP",	279,
	"Y_BC3F_OP",	280,
	"Y_BC3T_OP",	281,
	"Y_BEQ_OP",	282,
	"Y_BGEZAL_OP",	283,
	"Y_BGEZ_OP",	284,
	"Y_BGTZ_OP",	285,
	"Y_BLEZ_OP",	286,
	"Y_BLTZAL_OP",	287,
	"Y_BLTZ_OP",	288,
	"Y_BNE_OP",	289,
	"Y_BREAK_OP",	290,
	"Y_CFC0_OP",	291,
	"Y_CFC1_OP",	292,
	"Y_CFC2_OP",	293,
	"Y_CFC3_OP",	294,
	"Y_COP0_OP",	295,
	"Y_COP1_OP",	296,
	"Y_COP2_OP",	297,
	"Y_COP3_OP",	298,
	"Y_CTC0_OP",	299,
	"Y_CTC1_OP",	300,
	"Y_CTC2_OP",	301,
	"Y_CTC3_OP",	302,
	"Y_CVT_D_S_OP",	303,
	"Y_CVT_D_W_OP",	304,
	"Y_CVT_S_D_OP",	305,
	"Y_CVT_S_W_OP",	306,
	"Y_CVT_W_D_OP",	307,
	"Y_CVT_W_S_OP",	308,
	"Y_C_EQ_D_OP",	309,
	"Y_C_EQ_S_OP",	310,
	"Y_C_F_D_OP",	311,
	"Y_C_F_S_OP",	312,
	"Y_C_LE_D_OP",	313,
	"Y_C_LE_S_OP",	314,
	"Y_C_LT_D_OP",	315,
	"Y_C_LT_S_OP",	316,
	"Y_C_NGE_D_OP",	317,
	"Y_C_NGE_S_OP",	318,
	"Y_C_NGLE_D_OP",	319,
	"Y_C_NGLE_S_OP",	320,
	"Y_C_NGL_D_OP",	321,
	"Y_C_NGL_S_OP",	322,
	"Y_C_NGT_D_OP",	323,
	"Y_C_NGT_S_OP",	324,
	"Y_C_OLT_D_OP",	325,
	"Y_C_OLT_S_OP",	326,
	"Y_C_OLE_D_OP",	327,
	"Y_C_OLE_S_OP",	328,
	"Y_C_SEQ_D_OP",	329,
	"Y_C_SEQ_S_OP",	330,
	"Y_C_SF_D_OP",	331,
	"Y_C_SF_S_OP",	332,
	"Y_C_UEQ_D_OP",	333,
	"Y_C_UEQ_S_OP",	334,
	"Y_C_ULT_D_OP",	335,
	"Y_C_ULT_S_OP",	336,
	"Y_C_ULE_D_OP",	337,
	"Y_C_ULE_S_OP",	338,
	"Y_C_UN_D_OP",	339,
	"Y_C_UN_S_OP",	340,
	"Y_DIVU_OP",	341,
	"Y_DIV_D_OP",	342,
	"Y_DIV_OP",	343,
	"Y_DIV_S_OP",	344,
	"Y_JALR_OP",	345,
	"Y_JAL_OP",	346,
	"Y_JR_OP",	347,
	"Y_J_OP",	348,
	"Y_LBU_OP",	349,
	"Y_LB_OP",	350,
	"Y_LHU_OP",	351,
	"Y_LH_OP",	352,
	"Y_LUI_OP",	353,
	"Y_LWC0_OP",	354,
	"Y_LWC1_OP",	355,
	"Y_LWC2_OP",	356,
	"Y_LWC3_OP",	357,
	"Y_LWL_OP",	358,
	"Y_LWR_OP",	359,
	"Y_LW_OP",	360,
	"Y_MFC0_OP",	361,
	"Y_MFC1_OP",	362,
	"Y_MFC2_OP",	363,
	"Y_MFC3_OP",	364,
	"Y_MFHI_OP",	365,
	"Y_MFLO_OP",	366,
	"Y_MOV_D_OP",	367,
	"Y_MOV_S_OP",	368,
	"Y_MTC0_OP",	369,
	"Y_MTC1_OP",	370,
	"Y_MTC2_OP",	371,
	"Y_MTC3_OP",	372,
	"Y_MTHI_OP",	373,
	"Y_MTLO_OP",	374,
	"Y_MULTU_OP",	375,
	"Y_MULT_OP",	376,
	"Y_MUL_D_OP",	377,
	"Y_MUL_S_OP",	378,
	"Y_NEG_D_OP",	379,
	"Y_NEG_S_OP",	380,
	"Y_NOR_OP",	381,
	"Y_ORI_OP",	382,
	"Y_OR_OP",	383,
	"Y_PFW_OP",	384,
	"Y_RFE_OP",	385,
	"Y_SB_OP",	386,
	"Y_SH_OP",	387,
	"Y_SLLV_OP",	388,
	"Y_SLL_OP",	389,
	"Y_SLTIU_OP",	390,
	"Y_SLTI_OP",	391,
	"Y_SLTU_OP",	392,
	"Y_SLT_OP",	393,
	"Y_SRAV_OP",	394,
	"Y_SRA_OP",	395,
	"Y_SRLV_OP",	396,
	"Y_SRL_OP",	397,
	"Y_SUBU_OP",	398,
	"Y_SUB_D_OP",	399,
	"Y_SUB_OP",	400,
	"Y_SUB_S_OP",	401,
	"Y_SWC0_OP",	402,
	"Y_SWC1_OP",	403,
	"Y_SWC2_OP",	404,
	"Y_SWC3_OP",	405,
	"Y_SWL_OP",	406,
	"Y_SWR_OP",	407,
	"Y_SW_OP",	408,
	"Y_SYSCALL_OP",	409,
	"Y_TLBP_OP",	410,
	"Y_TLBR_OP",	411,
	"Y_TLBWI_OP",	412,
	"Y_TLBWR_OP",	413,
	"Y_XORI_OP",	414,
	"Y_XOR_OP",	415,
	"Y_ABS_POP",	416,
	"Y_BAL_POP",	417,
	"Y_BEQZ_POP",	418,
	"Y_BGEU_POP",	419,
	"Y_BGE_POP",	420,
	"Y_BGTU_POP",	421,
	"Y_BGT_POP",	422,
	"Y_BLEU_POP",	423,
	"Y_BLE_POP",	424,
	"Y_BLTU_POP",	425,
	"Y_BLT_POP",	426,
	"Y_BNEZ_POP",	427,
	"Y_B_POP",	428,
	"Y_LA_POP",	429,
	"Y_LD_POP",	430,
	"Y_LI_POP",	431,
	"Y_LI_D_POP",	432,
	"Y_LI_S_POP",	433,
	"Y_L_D_POP",	434,
	"Y_L_S_POP",	435,
	"Y_MFC1_D_POP",	436,
	"Y_MTC1_D_POP",	437,
	"Y_MOVE_POP",	438,
	"Y_MULOU_POP",	439,
	"Y_MULO_POP",	440,
	"Y_MUL_POP",	441,
	"Y_NEGU_POP",	442,
	"Y_NEG_POP",	443,
	"Y_NOP_POP",	444,
	"Y_NOT_POP",	445,
	"Y_REMU_POP",	446,
	"Y_REM_POP",	447,
	"Y_ROL_POP",	448,
	"Y_ROR_POP",	449,
	"Y_SD_POP",	450,
	"Y_SEQ_POP",	451,
	"Y_SGEU_POP",	452,
	"Y_SGE_POP",	453,
	"Y_SGTU_POP",	454,
	"Y_SGT_POP",	455,
	"Y_SLEU_POP",	456,
	"Y_SLE_POP",	457,
	"Y_SNE_POP",	458,
	"Y_S_D_POP",	459,
	"Y_S_S_POP",	460,
	"Y_ULHU_POP",	461,
	"Y_ULH_POP",	462,
	"Y_ULW_POP",	463,
	"Y_USH_POP",	464,
	"Y_USW_POP",	465,
	"Y_ALIAS_DIR",	466,
	"Y_ALIGN_DIR",	467,
	"Y_ASCII_DIR",	468,
	"Y_ASCIIZ_DIR",	469,
	"Y_ASM0_DIR",	470,
	"Y_BGNB_DIR",	471,
	"Y_BYTE_DIR",	472,
	"Y_COMM_DIR",	473,
	"Y_DATA_DIR",	474,
	"Y_DOUBLE_DIR",	475,
	"Y_ENDB_DIR",	476,
	"Y_ENDR_DIR",	477,
	"Y_END_DIR",	478,
	"Y_ENT_DIR",	479,
	"Y_ERR_DIR",	480,
	"Y_EXTERN_DIR",	481,
	"Y_FILE_DIR",	482,
	"Y_FLOAT_DIR",	483,
	"Y_FMASK_DIR",	484,
	"Y_FRAME_DIR",	485,
	"Y_GLOBAL_DIR",	486,
	"Y_HALF_DIR",	487,
	"Y_K_TEXT_DIR",	488,
	"Y_K_DATA_DIR",	489,
	"Y_LABEL_DIR",	490,
	"Y_LCOMM_DIR",	491,
	"Y_LIVEREG_DIR",	492,
	"Y_LOC_DIR",	493,
	"Y_MASK_DIR",	494,
	"Y_NOALIAS_DIR",	495,
	"Y_OPTIONS_DIR",	496,
	"Y_RDATA_DIR",	497,
	"Y_REPEAT_DIR",	498,
	"Y_SDATA_DIR",	499,
	"Y_SET_DIR",	500,
	"Y_SPACE_DIR",	501,
	"Y_STRUCT_DIR",	502,
	"Y_TEXT_DIR",	503,
	"Y_VERSTAMP_DIR",	504,
	"Y_VREG_DIR",	505,
	"Y_WORD_DIR",	506,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"LINE : /* empty */",
	"LINE : LBL_CMD",
	"LBL_CMD : OPT_LBL NON_EMPTY_CMD",
	"LBL_CMD : CMD",
	"OPT_LBL : ID ':'",
	"OPT_LBL : ID '=' Y_INT",
	"OPT_LBL : /* empty */",
	"NON_EMPTY_CMD : ASM_CODE Y_NL",
	"NON_EMPTY_CMD : ASM_DIRECTIVE Y_NL",
	"NON_EMPTY_CMD : Y_NL",
	"CMD : NON_EMPTY_CMD",
	"CMD : /* empty */",
	"ASM_CODE : LOAD_OP DEST_REG ADDRESS",
	"ASM_CODE : LOAD_COP COP_REG ADDRESS",
	"ASM_CODE : LOAD_IMM_OP DEST_REG IMM",
	"ASM_CODE : Y_LA_POP DEST_REG ADDRESS",
	"ASM_CODE : Y_LI_POP DEST_REG IMM",
	"ASM_CODE : Y_LI_D_POP F_DEST Y_FP",
	"ASM_CODE : Y_LI_S_POP F_DEST Y_FP",
	"ASM_CODE : Y_ULW_POP DEST_REG ADDRESS",
	"ASM_CODE : ULOADH_POP DEST_REG ADDRESS",
	"ASM_CODE : LOADF_OP F_DEST ADDRESS",
	"ASM_CODE : STORE_OP SOURCE ADDRESS",
	"ASM_CODE : STORE_COP COP_REG ADDRESS",
	"ASM_CODE : Y_USW_POP SOURCE ADDRESS",
	"ASM_CODE : Y_USH_POP SOURCE ADDRESS",
	"ASM_CODE : STOREF_OP F_SRC1 ADDRESS",
	"ASM_CODE : SYS_OP",
	"ASM_CODE : Y_BREAK_OP Y_INT",
	"ASM_CODE : Y_NOP_POP",
	"ASM_CODE : Y_ABS_POP DEST_REG SRC1",
	"ASM_CODE : Y_NEG_POP DEST_REG SRC1",
	"ASM_CODE : Y_NEGU_POP DEST_REG SRC1",
	"ASM_CODE : Y_NOT_POP DEST_REG SRC1",
	"ASM_CODE : Y_MOVE_POP DEST_REG SRC1",
	"ASM_CODE : BINARY_OP_I DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OP_I DEST_REG SRC1 IMM",
	"ASM_CODE : BINARY_OP_I DEST_REG IMM",
	"ASM_CODE : BINARY_OPR_I DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OPR_I DEST_REG SRC1 Y_INT",
	"ASM_CODE : BINARY_OPR_I DEST_REG Y_INT",
	"ASM_CODE : BINARY_IMM_OP DEST_REG SRC1 IMM",
	"ASM_CODE : BINARY_IMM_OP DEST_REG IMM",
	"ASM_CODE : SHIFT_OP DEST_REG SRC1 Y_INT",
	"ASM_CODE : SHIFT_OP DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OP_NOI DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OP_NOI DEST_REG SRC1 IMM",
	"ASM_CODE : BINARY_OP_NOI DEST_REG IMM",
	"ASM_CODE : SUB_OP DEST_REG SRC1 SRC2",
	"ASM_CODE : SUB_OP DEST_REG SRC1 IMM",
	"ASM_CODE : SUB_OP DEST_REG IMM",
	"ASM_CODE : DIV_POP DEST_REG SRC1",
	"ASM_CODE : DIV_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : DIV_POP DEST_REG SRC1 IMM",
	"ASM_CODE : MUL_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : MUL_POP DEST_REG SRC1 IMM",
	"ASM_CODE : MULT_OP SRC1 SRC2",
	"ASM_CODE : Y_ROR_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : Y_ROL_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : Y_ROR_POP DEST_REG SRC1 IMM",
	"ASM_CODE : Y_ROL_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_LE_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_LE_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_GT_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_GT_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_GE_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_GE_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_EQ_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_EQ_POP DEST_REG SRC1 IMM",
	"ASM_CODE : NULLARY_BR_OP LABEL",
	"ASM_CODE : UNARY_BR_OP SRC1 LABEL",
	"ASM_CODE : UNARY_BR_POP SRC1 LABEL",
	"ASM_CODE : BINARY_BR_OP SRC1 SRC2 LABEL",
	"ASM_CODE : BINARY_BR_OP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_GT_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_GT_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_GE_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_GE_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_LT_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_LT_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_LE_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_LE_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : J_OPS LABEL",
	"ASM_CODE : J_OPS SRC1",
	"ASM_CODE : J_OPS DEST SRC1",
	"ASM_CODE : B_OP LABEL",
	"ASM_CODE : MOVE_COP_OP COP_REG COP_REG",
	"ASM_CODE : MOV_FROM_HILO_OP REG",
	"ASM_CODE : MOV_TO_HILO_OP REG",
	"ASM_CODE : MOV_COP_OP REG COP_REG",
	"ASM_CODE : CTL_COP_OP COP_REG COP_REG",
	"ASM_CODE : FP_ABS_OP F_DEST F_SRC1",
	"ASM_CODE : FP_BINARY_OP F_DEST F_SRC1 F_SRC2",
	"ASM_CODE : FP_CONVERT_OP F_DEST F_SRC2",
	"ASM_CODE : FP_NEG_OP F_DEST F_SRC2",
	"ASM_CODE : FP_CMP_OP F_SRC1 F_SRC2",
	"LOAD_OP : Y_LB_OP",
	"LOAD_OP : Y_LBU_OP",
	"LOAD_OP : Y_LH_OP",
	"LOAD_OP : Y_LHU_OP",
	"LOAD_OP : Y_LW_OP",
	"LOAD_OP : Y_LWL_OP",
	"LOAD_OP : Y_LWR_OP",
	"LOAD_OP : Y_LD_POP",
	"LOAD_OP : Y_PFW_OP",
	"LOAD_COP : Y_LWC0_OP",
	"LOAD_COP : Y_LWC2_OP",
	"LOAD_COP : Y_LWC3_OP",
	"LOAD_IMM_OP : Y_LUI_OP",
	"ULOADH_POP : Y_ULH_POP",
	"ULOADH_POP : Y_ULHU_POP",
	"LOADF_OP : Y_LWC1_OP",
	"LOADF_OP : Y_L_S_POP",
	"LOADF_OP : Y_L_D_POP",
	"STORE_OP : Y_SB_OP",
	"STORE_OP : Y_SH_OP",
	"STORE_OP : Y_SW_OP",
	"STORE_OP : Y_SWL_OP",
	"STORE_OP : Y_SWR_OP",
	"STORE_OP : Y_SD_POP",
	"STORE_COP : Y_SWC0_OP",
	"STORE_COP : Y_SWC2_OP",
	"STORE_COP : Y_SWC3_OP",
	"STOREF_OP : Y_SWC1_OP",
	"STOREF_OP : Y_S_S_POP",
	"STOREF_OP : Y_S_D_POP",
	"SYS_OP : Y_RFE_OP",
	"SYS_OP : Y_SYSCALL_OP",
	"BINARY_OP_I : Y_ADD_OP",
	"BINARY_OP_I : Y_ADDU_OP",
	"BINARY_OP_I : Y_AND_OP",
	"BINARY_OP_I : Y_XOR_OP",
	"BINARY_OP_I : Y_OR_OP",
	"BINARY_OP_I : Y_SLT_OP",
	"BINARY_OP_I : Y_SLTU_OP",
	"BINARY_OPR_I : Y_SLLV_OP",
	"BINARY_OPR_I : Y_SRAV_OP",
	"BINARY_OPR_I : Y_SRLV_OP",
	"BINARY_IMM_OP : Y_ADDI_OP",
	"BINARY_IMM_OP : Y_ADDIU_OP",
	"BINARY_IMM_OP : Y_ANDI_OP",
	"BINARY_IMM_OP : Y_ORI_OP",
	"BINARY_IMM_OP : Y_XORI_OP",
	"BINARY_IMM_OP : Y_SLTI_OP",
	"BINARY_IMM_OP : Y_SLTIU_OP",
	"SHIFT_OP : Y_SLL_OP",
	"SHIFT_OP : Y_SRA_OP",
	"SHIFT_OP : Y_SRL_OP",
	"BINARY_OP_NOI : Y_NOR_OP",
	"SUB_OP : Y_SUB_OP",
	"SUB_OP : Y_SUBU_OP",
	"DIV_POP : Y_DIV_OP",
	"DIV_POP : Y_DIVU_OP",
	"DIV_POP : Y_REM_POP",
	"DIV_POP : Y_REMU_POP",
	"MUL_POP : Y_MUL_POP",
	"MUL_POP : Y_MULO_POP",
	"MUL_POP : Y_MULOU_POP",
	"SET_LE_POP : Y_SLE_POP",
	"SET_LE_POP : Y_SLEU_POP",
	"SET_GT_POP : Y_SGT_POP",
	"SET_GT_POP : Y_SGTU_POP",
	"SET_GE_POP : Y_SGE_POP",
	"SET_GE_POP : Y_SGEU_POP",
	"SET_EQ_POP : Y_SEQ_POP",
	"SET_EQ_POP : Y_SNE_POP",
	"MULT_OP : Y_MULT_OP",
	"MULT_OP : Y_MULTU_OP",
	"NULLARY_BR_OP : Y_BC0T_OP",
	"NULLARY_BR_OP : Y_BC1T_OP",
	"NULLARY_BR_OP : Y_BC2T_OP",
	"NULLARY_BR_OP : Y_BC3T_OP",
	"NULLARY_BR_OP : Y_BC0F_OP",
	"NULLARY_BR_OP : Y_BC1F_OP",
	"NULLARY_BR_OP : Y_BC2F_OP",
	"NULLARY_BR_OP : Y_BC3F_OP",
	"UNARY_BR_OP : Y_BGEZ_OP",
	"UNARY_BR_OP : Y_BGEZAL_OP",
	"UNARY_BR_OP : Y_BGTZ_OP",
	"UNARY_BR_OP : Y_BLEZ_OP",
	"UNARY_BR_OP : Y_BLTZ_OP",
	"UNARY_BR_OP : Y_BLTZAL_OP",
	"UNARY_BR_POP : Y_BEQZ_POP",
	"UNARY_BR_POP : Y_BNEZ_POP",
	"BINARY_BR_OP : Y_BEQ_OP",
	"BINARY_BR_OP : Y_BNE_OP",
	"BR_GT_POP : Y_BGT_POP",
	"BR_GT_POP : Y_BGTU_POP",
	"BR_GE_POP : Y_BGE_POP",
	"BR_GE_POP : Y_BGEU_POP",
	"BR_LT_POP : Y_BLT_POP",
	"BR_LT_POP : Y_BLTU_POP",
	"BR_LE_POP : Y_BLE_POP",
	"BR_LE_POP : Y_BLEU_POP",
	"J_OPS : Y_J_OP",
	"J_OPS : Y_JR_OP",
	"J_OPS : Y_JAL_OP",
	"J_OPS : Y_JALR_OP",
	"B_OP : Y_B_POP",
	"B_OP : Y_BAL_POP",
	"MOVE_COP_OP : Y_MOV_S_OP",
	"MOVE_COP_OP : Y_MOV_D_OP",
	"MOV_FROM_HILO_OP : Y_MFHI_OP",
	"MOV_FROM_HILO_OP : Y_MFLO_OP",
	"MOV_TO_HILO_OP : Y_MTHI_OP",
	"MOV_TO_HILO_OP : Y_MTLO_OP",
	"MOV_COP_OP : Y_MFC0_OP",
	"MOV_COP_OP : Y_MFC1_OP",
	"MOV_COP_OP : Y_MFC1_D_POP",
	"MOV_COP_OP : Y_MFC2_OP",
	"MOV_COP_OP : Y_MFC3_OP",
	"MOV_COP_OP : Y_MTC0_OP",
	"MOV_COP_OP : Y_MTC1_OP",
	"MOV_COP_OP : Y_MTC1_D_POP",
	"MOV_COP_OP : Y_MTC2_OP",
	"MOV_COP_OP : Y_MTC3_OP",
	"CTL_COP_OP : Y_CFC0_OP",
	"CTL_COP_OP : Y_CFC1_OP",
	"CTL_COP_OP : Y_CFC2_OP",
	"CTL_COP_OP : Y_CFC3_OP",
	"CTL_COP_OP : Y_CTC0_OP",
	"CTL_COP_OP : Y_CTC1_OP",
	"CTL_COP_OP : Y_CTC2_OP",
	"CTL_COP_OP : Y_CTC3_OP",
	"FP_ABS_OP : Y_ABS_S_OP",
	"FP_ABS_OP : Y_ABS_D_OP",
	"FP_BINARY_OP : Y_ADD_S_OP",
	"FP_BINARY_OP : Y_ADD_D_OP",
	"FP_BINARY_OP : Y_DIV_S_OP",
	"FP_BINARY_OP : Y_DIV_D_OP",
	"FP_BINARY_OP : Y_MUL_S_OP",
	"FP_BINARY_OP : Y_MUL_D_OP",
	"FP_BINARY_OP : Y_SUB_S_OP",
	"FP_BINARY_OP : Y_SUB_D_OP",
	"FP_CONVERT_OP : Y_CVT_D_S_OP",
	"FP_CONVERT_OP : Y_CVT_D_W_OP",
	"FP_CONVERT_OP : Y_CVT_S_D_OP",
	"FP_CONVERT_OP : Y_CVT_S_W_OP",
	"FP_CONVERT_OP : Y_CVT_W_D_OP",
	"FP_CONVERT_OP : Y_CVT_W_S_OP",
	"FP_NEG_OP : Y_NEG_S_OP",
	"FP_NEG_OP : Y_NEG_D_OP",
	"FP_CMP_OP : Y_C_F_S_OP",
	"FP_CMP_OP : Y_C_UN_S_OP",
	"FP_CMP_OP : Y_C_EQ_S_OP",
	"FP_CMP_OP : Y_C_UEQ_S_OP",
	"FP_CMP_OP : Y_C_OLT_S_OP",
	"FP_CMP_OP : Y_C_OLE_S_OP",
	"FP_CMP_OP : Y_C_ULT_S_OP",
	"FP_CMP_OP : Y_C_ULE_S_OP",
	"FP_CMP_OP : Y_C_SF_S_OP",
	"FP_CMP_OP : Y_C_NGLE_S_OP",
	"FP_CMP_OP : Y_C_SEQ_S_OP",
	"FP_CMP_OP : Y_C_NGL_S_OP",
	"FP_CMP_OP : Y_C_LT_S_OP",
	"FP_CMP_OP : Y_C_NGE_S_OP",
	"FP_CMP_OP : Y_C_LE_S_OP",
	"FP_CMP_OP : Y_C_NGT_S_OP",
	"FP_CMP_OP : Y_C_F_D_OP",
	"FP_CMP_OP : Y_C_UN_D_OP",
	"FP_CMP_OP : Y_C_EQ_D_OP",
	"FP_CMP_OP : Y_C_UEQ_D_OP",
	"FP_CMP_OP : Y_C_OLT_D_OP",
	"FP_CMP_OP : Y_C_OLE_D_OP",
	"FP_CMP_OP : Y_C_ULT_D_OP",
	"FP_CMP_OP : Y_C_ULE_D_OP",
	"FP_CMP_OP : Y_C_SF_D_OP",
	"FP_CMP_OP : Y_C_NGLE_D_OP",
	"FP_CMP_OP : Y_C_SEQ_D_OP",
	"FP_CMP_OP : Y_C_NGL_D_OP",
	"FP_CMP_OP : Y_C_LT_D_OP",
	"FP_CMP_OP : Y_C_NGE_D_OP",
	"FP_CMP_OP : Y_C_LE_D_OP",
	"FP_CMP_OP : Y_C_NGT_D_OP",
	"ASM_DIRECTIVE : Y_ALIAS_DIR Y_REG Y_REG",
	"ASM_DIRECTIVE : Y_ALIGN_DIR EXPR",
	"ASM_DIRECTIVE : Y_ASCII_DIR",
	"ASM_DIRECTIVE : Y_ASCII_DIR STR_LST",
	"ASM_DIRECTIVE : Y_ASCIIZ_DIR",
	"ASM_DIRECTIVE : Y_ASCIIZ_DIR STR_LST",
	"ASM_DIRECTIVE : Y_ASM0_DIR",
	"ASM_DIRECTIVE : Y_BGNB_DIR Y_INT",
	"ASM_DIRECTIVE : Y_BYTE_DIR",
	"ASM_DIRECTIVE : Y_BYTE_DIR EXPR_LST",
	"ASM_DIRECTIVE : Y_COMM_DIR ID EXPR",
	"ASM_DIRECTIVE : Y_DATA_DIR",
	"ASM_DIRECTIVE : Y_DATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_K_DATA_DIR",
	"ASM_DIRECTIVE : Y_K_DATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_DOUBLE_DIR",
	"ASM_DIRECTIVE : Y_DOUBLE_DIR FP_EXPR_LST",
	"ASM_DIRECTIVE : Y_END_DIR OPTIONAL_ID",
	"ASM_DIRECTIVE : Y_ENDB_DIR Y_INT",
	"ASM_DIRECTIVE : Y_ENDR_DIR",
	"ASM_DIRECTIVE : Y_ENT_DIR ID",
	"ASM_DIRECTIVE : Y_ENT_DIR ID Y_INT",
	"ASM_DIRECTIVE : Y_EXTERN_DIR ID EXPR",
	"ASM_DIRECTIVE : Y_ERR_DIR",
	"ASM_DIRECTIVE : Y_FILE_DIR Y_INT Y_STR",
	"ASM_DIRECTIVE : Y_FLOAT_DIR",
	"ASM_DIRECTIVE : Y_FLOAT_DIR FP_EXPR_LST",
	"ASM_DIRECTIVE : Y_FMASK_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_FRAME_DIR REGISTER Y_INT REGISTER",
	"ASM_DIRECTIVE : Y_GLOBAL_DIR ID",
	"ASM_DIRECTIVE : Y_HALF_DIR",
	"ASM_DIRECTIVE : Y_HALF_DIR EXPR_LST",
	"ASM_DIRECTIVE : Y_LABEL_DIR ID",
	"ASM_DIRECTIVE : Y_LCOMM_DIR ID EXPR",
	"ASM_DIRECTIVE : Y_LIVEREG_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_LOC_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_MASK_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_NOALIAS_DIR Y_REG Y_REG",
	"ASM_DIRECTIVE : Y_OPTIONS_DIR ID",
	"ASM_DIRECTIVE : Y_REPEAT_DIR EXPR",
	"ASM_DIRECTIVE : Y_RDATA_DIR",
	"ASM_DIRECTIVE : Y_RDATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_SDATA_DIR",
	"ASM_DIRECTIVE : Y_SDATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_SET_DIR ID",
	"ASM_DIRECTIVE : Y_SPACE_DIR EXPR",
	"ASM_DIRECTIVE : Y_STRUCT_DIR EXPR",
	"ASM_DIRECTIVE : Y_TEXT_DIR",
	"ASM_DIRECTIVE : Y_TEXT_DIR Y_INT",
	"ASM_DIRECTIVE : Y_K_TEXT_DIR",
	"ASM_DIRECTIVE : Y_K_TEXT_DIR Y_INT",
	"ASM_DIRECTIVE : Y_VERSTAMP_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_VREG_DIR REGISTER Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_WORD_DIR",
	"ASM_DIRECTIVE : Y_WORD_DIR EXPR_LST",
	"ADDRESS : /* empty */",
	"ADDRESS : ADDR",
	"ADDR : '(' REGISTER ')'",
	"ADDR : ABS_ADDR",
	"ADDR : ABS_ADDR '(' REGISTER ')'",
	"ADDR : Y_ID",
	"ADDR : Y_ID '(' REGISTER ')'",
	"ADDR : Y_ID '+' ABS_ADDR",
	"ADDR : ABS_ADDR '+' ID",
	"ADDR : Y_ID '-' ABS_ADDR",
	"ADDR : Y_ID '+' ABS_ADDR '(' REGISTER ')'",
	"ADDR : Y_ID '-' ABS_ADDR '(' REGISTER ')'",
	"IMMEDIATE : /* empty */",
	"IMMEDIATE : IMM",
	"IMM : ABS_ADDR",
	"IMM : '(' ABS_ADDR ')' '>' '>' Y_INT",
	"IMM : ID",
	"IMM : Y_ID '+' ABS_ADDR",
	"IMM : Y_ID '-' ABS_ADDR",
	"ABS_ADDR : Y_INT",
	"ABS_ADDR : Y_INT '+' Y_INT",
	"ABS_ADDR : Y_INT Y_INT",
	"DEST_REG : REGISTER",
	"SRC1 : REGISTER",
	"SRC2 : REGISTER",
	"DEST : REGISTER",
	"REG : REGISTER",
	"SOURCE : REGISTER",
	"REGISTER : Y_REG",
	"F_DEST : FP_REGISTER",
	"F_SRC1 : FP_REGISTER",
	"F_SRC2 : FP_REGISTER",
	"FP_REGISTER : Y_FP_REG",
	"COP_REG : Y_REG",
	"COP_REG : Y_FP_REG",
	"LABEL : ID",
	"STR_LST : STR_LST STR",
	"STR_LST : STR",
	"STR : Y_STR",
	"STR : Y_STR ':' Y_INT",
	"EXPRESSION : /* empty */",
	"EXPRESSION : EXPR",
	"EXPR : Y_INT",
	"EXPR : ID",
	"EXPR_LST : EXPR_LST EXPRESSION",
	"EXPR_LST : EXPRESSION",
	"EXPR_LST : EXPRESSION ':' Y_INT",
	"FP_EXPR_LST : FP_EXPR_LST Y_FP",
	"FP_EXPR_LST : Y_FP",
	"OPTIONAL_ID : /* empty */",
	"OPTIONAL_ID : OPT_ID",
	"OPT_ID : ID",
	"OPT_ID : /* empty */",
	"ID : /* empty */",
	"ID : Y_ID",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.12	93/06/07 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yynewmax * sizeof(type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside switch should never be
	executed; yypvt is set to 0 to avoid "used before set" warning.
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
	yypvt = 0;
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 375 "parser.y"
{scanner_start_line (); } break;
case 5:
# line 383 "parser.y"
{
			   this_line_labels =
			     cons_label (record_label ((char*)yypvt[-1].p,
						       text_dir
						       ? current_text_pc ()
						       : current_data_pc (),
						       0),
					 this_line_labels);
			 } break;
case 6:
# line 394 "parser.y"
{
		  label *l = record_label ((char*)yypvt[-2].p, (mem_addr)yypvt[-0].i, 1);

		  l->const_flag = 1;
		  clear_labels ();
		} break;
case 8:
# line 406 "parser.y"
{
		  clear_labels ();
		  LINE_PARSE_DONE;
		} break;
case 9:
# line 412 "parser.y"
{
		  clear_labels ();
		  LINE_PARSE_DONE;
		} break;
case 10:
# line 418 "parser.y"
{
		  LINE_PARSE_DONE;
		} break;
case 12:
# line 426 "parser.y"
{
		  clear_labels ();
		  FILE_PARSE_DONE;
		} break;
case 13:
# line 435 "parser.y"
{
		  i_type_inst (yypvt[-2].i == Y_LD_POP ? Y_LW_OP : yypvt[-2].i,
			       yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  if (yypvt[-2].i == Y_LD_POP)
		    i_type_inst_free (Y_LW_OP,
				      yypvt[-1].i + 1,
				      addr_expr_reg ((addr_expr *)yypvt[-0].p),
				      incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
							4));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 14:
# line 451 "parser.y"
{
		  i_type_inst (yypvt[-2].i, yypvt[-1].i, addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 15:
# line 459 "parser.y"
{
		  i_type_inst_free (yypvt[-2].i, yypvt[-1].i, 0, (imm_expr *)yypvt[-0].p);
		} break;
case 16:
# line 465 "parser.y"
{
		  if (addr_expr_reg ((addr_expr *)yypvt[-0].p))
		    i_type_inst (Y_ADDI_OP, yypvt[-1].i,
				 addr_expr_reg ((addr_expr *)yypvt[-0].p),
				 addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  else
		    i_type_inst (Y_ORI_OP, yypvt[-1].i, 0,
				 addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 17:
# line 479 "parser.y"
{
		  i_type_inst_free (Y_ORI_OP, yypvt[-1].i, 0, (imm_expr *)yypvt[-0].p);
		} break;
case 18:
# line 485 "parser.y"
{
		  int *x = (int *) yypvt[-0].p;

		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*x));
		  r_type_inst (Y_MTC1_OP, yypvt[-1].i, 0, 1);
		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*(x+1)));
		  r_type_inst (Y_MTC1_OP, yypvt[-1].i + 1, 0, 1);
		} break;
case 19:
# line 496 "parser.y"
{
		  float x = (float)* ((double *) yypvt[-0].p);
		  int *y = (int *) &x;

		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*y));
		  r_type_inst (Y_MTC1_OP, yypvt[-1].i, 0, 1);
		} break;
case 20:
# line 506 "parser.y"
{
#ifdef BIGENDIAN
		  i_type_inst (Y_LWL_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  i_type_inst_free (Y_LWR_OP, yypvt[-1].i,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      3));
#else
		  i_type_inst_free (Y_LWL_OP, yypvt[-1].i,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      3));
		  i_type_inst (Y_LWR_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
#endif
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 21:
# line 530 "parser.y"
{
#ifdef BIGENDIAN
		  i_type_inst ((yypvt[-2].i == Y_ULH_POP ? Y_LB_OP : Y_LBU_OP),
			       yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  i_type_inst_free (Y_LBU_OP, 1,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      1));
#else
		  i_type_inst_free ((yypvt[-2].i == Y_ULH_POP ? Y_LB_OP : Y_LBU_OP),
				    yypvt[-1].i,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      1));
		  i_type_inst (Y_LBU_OP, 1,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
#endif
		  r_sh_type_inst (Y_SLL_OP, yypvt[-1].i, yypvt[-1].i, 8);
		  r_type_inst (Y_OR_OP, yypvt[-1].i, yypvt[-1].i, 1);
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 22:
# line 558 "parser.y"
{
		  i_type_inst (Y_LWC1_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  if (yypvt[-2].i == Y_L_D_POP)
		    i_type_inst_free (Y_LWC1_OP, yypvt[-1].i + 1,
				      addr_expr_reg ((addr_expr *)yypvt[-0].p),
				      incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
							4));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 23:
# line 573 "parser.y"
{
		  i_type_inst (yypvt[-2].i == Y_SD_POP ? Y_SW_OP : yypvt[-2].i,
			       yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  if (yypvt[-2].i == Y_SD_POP)
		    i_type_inst_free (Y_SW_OP, yypvt[-1].i + 1,
				      addr_expr_reg ((addr_expr *)yypvt[-0].p),
				      incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
							4));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 24:
# line 589 "parser.y"
{
		  i_type_inst (yypvt[-2].i, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 25:
# line 599 "parser.y"
{
#ifdef BIGENDIAN
		  i_type_inst (Y_SWL_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  i_type_inst_free (Y_SWR_OP, yypvt[-1].i,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      3));
#else
		  i_type_inst_free (Y_SWL_OP, yypvt[-1].i,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      3));
		  i_type_inst (Y_SWR_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
#endif
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 26:
# line 623 "parser.y"
{
		  i_type_inst (Y_SB_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  r_sh_type_inst (Y_SRL_OP, 1, yypvt[-1].i, 8);
		  i_type_inst_free (Y_SB_OP, 1,
				    addr_expr_reg ((addr_expr *)yypvt[-0].p),
				    incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
						      1));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 27:
# line 638 "parser.y"
{
		  i_type_inst (Y_SWC1_OP, yypvt[-1].i,
			       addr_expr_reg ((addr_expr *)yypvt[-0].p),
			       addr_expr_imm ((addr_expr *)yypvt[-0].p));
		  if (yypvt[-2].i == Y_S_D_POP)
		    i_type_inst_free (Y_SWC1_OP, yypvt[-1].i + 1,
				      addr_expr_reg ((addr_expr *)yypvt[-0].p),
				      incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0].p),
							4));
		  free (((addr_expr *)yypvt[-0].p)->imm);
		  free ((addr_expr *)yypvt[-0].p);
		} break;
case 28:
# line 653 "parser.y"
{
		  r_type_inst (yypvt[-0].i, 0, 0, 0);
		} break;
case 29:
# line 659 "parser.y"
{
		  if (yypvt[-0].i == 1)
		    yyerror ("Breakpoint 1 is reserved for debugger");
		  r_type_inst (yypvt[-1].i, yypvt[-0].i, 0, 0);
		} break;
case 30:
# line 667 "parser.y"
{
		  nop_inst ();
		} break;
case 31:
# line 673 "parser.y"
{
		  if (yypvt[-1].i != yypvt[-0].i)
		    r_type_inst (Y_ADDU_OP, yypvt[-1].i, 0, yypvt[-0].i);

		  i_type_inst_free (Y_BGEZ_OP, 0, yypvt[-0].i, branch_offset (2));
		  r_type_inst (Y_SUB_OP, yypvt[-1].i, 0, yypvt[-0].i);
		} break;
case 32:
# line 683 "parser.y"
{
		  r_type_inst (Y_SUB_OP, yypvt[-1].i, 0, yypvt[-0].i);
		} break;
case 33:
# line 689 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, yypvt[-1].i, 0, yypvt[-0].i);
		} break;
case 34:
# line 695 "parser.y"
{
		  r_type_inst (Y_NOR_OP, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 35:
# line 701 "parser.y"
{
		  r_type_inst (Y_ADDU_OP, yypvt[-1].i, 0, yypvt[-0].i);
		} break;
case 36:
# line 707 "parser.y"
{
		  r_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 37:
# line 713 "parser.y"
{
		  i_type_inst_free (op_to_imm_op (yypvt[-3].i), yypvt[-2].i, yypvt[-1].i,
				    (imm_expr *)yypvt[-0].p);
		} break;
case 38:
# line 720 "parser.y"
{
		  i_type_inst_free (op_to_imm_op (yypvt[-2].i), yypvt[-1].i, yypvt[-1].i,
				    (imm_expr *)yypvt[-0].p);
		} break;
case 39:
# line 727 "parser.y"
{
		  r_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-0].i, yypvt[-1].i);
		} break;
case 40:
# line 733 "parser.y"
{
		  r_sh_type_inst (op_to_imm_op (yypvt[-3].i), yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 41:
# line 739 "parser.y"
{
		  r_sh_type_inst (op_to_imm_op (yypvt[-2].i), yypvt[-1].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 42:
# line 745 "parser.y"
{
		  i_type_inst_free (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, (imm_expr *)yypvt[-0].p);
		} break;
case 43:
# line 751 "parser.y"
{
		  i_type_inst_free (yypvt[-2].i, yypvt[-1].i, yypvt[-1].i, (imm_expr *)yypvt[-0].p);
		} break;
case 44:
# line 757 "parser.y"
{
		  r_sh_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 45:
# line 763 "parser.y"
{
		  r_type_inst (imm_op_to_op (yypvt[-3].i), yypvt[-2].i, yypvt[-0].i, yypvt[-1].i);
		} break;
case 46:
# line 769 "parser.y"
{
		  r_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 47:
# line 775 "parser.y"
{
		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (!zero_imm ((imm_expr *)yypvt[-0].p))
			/* Use $at */
			i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		      r_type_inst (yypvt[-3].i,
				   yypvt[-2].i,
				   yypvt[-1].i,
				   (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		    }
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 48:
# line 793 "parser.y"
{
		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (!zero_imm ((imm_expr *)yypvt[-0].p))
			/* Use $at */
			i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		      r_type_inst (yypvt[-2].i,
				   yypvt[-1].i,
				   yypvt[-1].i,
				   (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		    }
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 49:
# line 811 "parser.y"
{
		  r_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 50:
# line 817 "parser.y"
{
		  int val = eval_imm_expr ((imm_expr*)yypvt[-0].p);

		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    i_type_inst (yypvt[-3].i == Y_SUB_OP ? Y_ADDI_OP
				 : yypvt[-3].i == Y_SUBU_OP ? Y_ADDIU_OP
				 : (fatal_error ("Bad SUB_OP\n"), 0),
				 yypvt[-2].i,
				 yypvt[-1].i,
				 make_imm_expr ( -val, NULL, 0));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 51:
# line 834 "parser.y"
{
		  int val = eval_imm_expr ((imm_expr*)yypvt[-0].p);

		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    i_type_inst (yypvt[-2].i == Y_SUB_OP ? Y_ADDI_OP
				 : yypvt[-2].i == Y_SUBU_OP ? Y_ADDIU_OP
				 : (fatal_error ("Bad SUB_OP\n"), 0),
				 yypvt[-1].i,
				 yypvt[-1].i,
				 make_imm_expr (-val, NULL, 0));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 52:
# line 851 "parser.y"
{
		  /* The hardware divide operation (ignore 1st arg) */
		  if (yypvt[-2].i != Y_DIV_OP && yypvt[-2].i != Y_DIVU_OP)
		    yyerror ("Syntax error");
		  r_type_inst (yypvt[-2].i, 0, yypvt[-1].i, yypvt[-0].i);
		} break;
case 53:
# line 859 "parser.y"
{
		  /* Pseudo divide operations */
		  div_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 54:
# line 865 "parser.y"
{
		  if (zero_imm ((imm_expr *)yypvt[-0].p))
		    yyerror ("Divide by zero");
		  else
		    {
		      /* Use $at */
		      i_type_inst_free (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		      div_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, 1, 1);
		    }
		} break;
case 55:
# line 878 "parser.y"
{
		  mult_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 56:
# line 883 "parser.y"
{
		  if (zero_imm ((imm_expr *)yypvt[-0].p))
		    /* Optimize: n * 0 == 0 */
		    i_type_inst_free (Y_ORI_OP, yypvt[-2].i, 0, (imm_expr *)yypvt[-0].p);
		  else
		    {
		      /* Use $at */
		      i_type_inst_free (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		      mult_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, 1);
		    }
		} break;
case 57:
# line 897 "parser.y"
{
		  r_type_inst (yypvt[-2].i, 0, yypvt[-1].i, yypvt[-0].i);
		} break;
case 58:
# line 903 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, 1, 0, yypvt[-0].i);
		  r_type_inst (Y_SLLV_OP, 1, 1, yypvt[-1].i);
		  r_type_inst (Y_SRLV_OP, yypvt[-2].i, yypvt[-0].i, yypvt[-1].i);
		  r_type_inst (Y_OR_OP, yypvt[-2].i, yypvt[-2].i, 1);
		} break;
case 59:
# line 912 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, 1, 0, yypvt[-0].i);
		  r_type_inst (Y_SRLV_OP, 1, 1, yypvt[-1].i);
		  r_type_inst (Y_SLLV_OP, yypvt[-2].i, yypvt[-0].i, yypvt[-1].i);
		  r_type_inst (Y_OR_OP, yypvt[-2].i, yypvt[-2].i, 1);
		} break;
case 60:
# line 921 "parser.y"
{
		  long dist = eval_imm_expr ((imm_expr *)yypvt[-0].p);

		  r_sh_type_inst (Y_SLL_OP, 1, yypvt[-1].i, -dist);
		  r_sh_type_inst (Y_SRL_OP, yypvt[-2].i, yypvt[-1].i, dist);
		  r_type_inst (Y_OR_OP, yypvt[-2].i, yypvt[-2].i, 1);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 61:
# line 932 "parser.y"
{
		  long dist = eval_imm_expr ((imm_expr *)yypvt[-0].p);

		  r_sh_type_inst (Y_SRL_OP, 1, yypvt[-1].i, -dist);
		  r_sh_type_inst (Y_SLL_OP, yypvt[-2].i, yypvt[-1].i, dist);
		  r_type_inst (Y_OR_OP, yypvt[-2].i, yypvt[-2].i, 1);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 62:
# line 944 "parser.y"
{
		  set_le_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 63:
# line 949 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0].p))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		  set_le_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i,
			       (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 64:
# line 960 "parser.y"
{
		  set_gt_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 65:
# line 965 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0].p))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		  set_gt_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i,
			       (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 66:
# line 977 "parser.y"
{
		  set_ge_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 67:
# line 982 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0].p))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		  set_ge_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 68:
# line 992 "parser.y"
{
		  set_eq_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 69:
# line 997 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0].p))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0].p);
		  set_eq_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i,
			       (zero_imm ((imm_expr *)yypvt[-0].p) ? 0 : 1));
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 70:
# line 1008 "parser.y"
{
		  i_type_inst_free (yypvt[-1].i, 0, 0, (imm_expr *)yypvt[-0].p);
		} break;
case 71:
# line 1014 "parser.y"
{
		  i_type_inst_free (yypvt[-2].i, 0, yypvt[-1].i, (imm_expr *)yypvt[-0].p);
		} break;
case 72:
# line 1020 "parser.y"
{
		  i_type_inst_free (yypvt[-2].i == Y_BEQZ_POP ? Y_BEQ_OP : Y_BNE_OP,
			       0, yypvt[-1].i, (imm_expr *)yypvt[-0].p);
		} break;
case 73:
# line 1027 "parser.y"
{
		  i_type_inst_free (yypvt[-3].i, yypvt[-1].i, yypvt[-2].i, (imm_expr *)yypvt[-0].p);
		} break;
case 74:
# line 1032 "parser.y"
{
		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (zero_imm ((imm_expr *)yypvt[-1].p))
			i_type_inst (yypvt[-3].i, yypvt[-2].i,
				     (zero_imm ((imm_expr *)yypvt[-1].p) ? 0 : 1),
				     (imm_expr *)yypvt[-0].p);
		      else
			{
			  /* Use $at */
			  i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-1].p);
			  i_type_inst (yypvt[-3].i, yypvt[-2].i,
				       (zero_imm ((imm_expr *)yypvt[-1].p) ? 0 : 1),
				       (imm_expr *)yypvt[-0].p);
			}
		    }
		  free ((imm_expr *)yypvt[-1].p);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 75:
# line 1056 "parser.y"
{
		  r_type_inst (yypvt[-3].i == Y_BGT_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-1].i, yypvt[-2].i); /* Use $at */
		  i_type_inst_free (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		} break;
case 76:
# line 1063 "parser.y"
{
		  if (yypvt[-3].i == Y_BGT_POP)
		    {
		      /* Use $at */
		      i_type_inst_free (Y_SLTI_OP, 1, yypvt[-2].i,
					incr_expr_offset ((imm_expr *)yypvt[-1].p, 1));
		      i_type_inst (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		    }
		  else
		    {
		      /* Use $at */
		      /* Can't add 1 to immediate since 0xffffffff+1 = 0 < 1 */
		      i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-1].p);
		      i_type_inst_free (Y_BEQ_OP, yypvt[-2].i, 1, branch_offset (3));
		      r_type_inst (Y_SLTU_OP, 1, yypvt[-2].i, 1);
		      i_type_inst (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		    }
		  free ((imm_expr *)yypvt[-1].p);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 77:
# line 1086 "parser.y"
{
		  r_type_inst (yypvt[-3].i == Y_BGE_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-2].i, yypvt[-1].i); /* Use $at */
		  i_type_inst_free (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		} break;
case 78:
# line 1093 "parser.y"
{
		  i_type_inst (yypvt[-3].i == Y_BGE_POP ? Y_SLTI_OP : Y_SLTIU_OP,
			       1, yypvt[-2].i, (imm_expr *)yypvt[-1].p); /* Use $at */
		  i_type_inst_free (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		  free ((imm_expr *)yypvt[-1].p);
		} break;
case 79:
# line 1102 "parser.y"
{
		  r_type_inst (yypvt[-3].i == Y_BLT_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-2].i, yypvt[-1].i); /* Use $at */
		  i_type_inst_free (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		} break;
case 80:
# line 1109 "parser.y"
{
		  i_type_inst (yypvt[-3].i == Y_BLT_POP ? Y_SLTI_OP : Y_SLTIU_OP,
			       1, yypvt[-2].i, (imm_expr *)yypvt[-1].p); /* Use $at */
		  i_type_inst_free (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		  free ((imm_expr *)yypvt[-1].p);
		} break;
case 81:
# line 1118 "parser.y"
{
		  r_type_inst (yypvt[-3].i == Y_BLE_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-1].i, yypvt[-2].i); /* Use $at */
		  i_type_inst_free (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		} break;
case 82:
# line 1125 "parser.y"
{
		  if (yypvt[-3].i == Y_BLE_POP)
		    {
		      /* Use $at */
		      i_type_inst_free (Y_SLTI_OP, 1, yypvt[-2].i,
					incr_expr_offset ((imm_expr *)yypvt[-1].p, 1));
		      i_type_inst (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		    }
		  else
		    {
		      /* Use $at */
		      /* Can't add 1 to immediate since 0xffffffff+1 = 0 < 1 */
		      i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-1].p);
		      i_type_inst (Y_BEQ_OP, yypvt[-2].i, 1, (imm_expr *)yypvt[-0].p);
		      r_type_inst (Y_SLTU_OP, 1, yypvt[-2].i, 1);
		      i_type_inst (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0].p);
		    }
		  free ((imm_expr *)yypvt[-1].p);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 83:
# line 1148 "parser.y"
{
		  if ((yypvt[-1].i == Y_J_OP) || (yypvt[-1].i == Y_JR_OP))
		    j_type_inst (Y_J_OP, (imm_expr *)yypvt[-0].p);
		  else if ((yypvt[-1].i == Y_JAL_OP) || (yypvt[-1].i == Y_JALR_OP))
		    j_type_inst (Y_JAL_OP, (imm_expr *)yypvt[-0].p);
		  free ((imm_expr *)yypvt[-0].p);
		} break;
case 84:
# line 1158 "parser.y"
{
		  if ((yypvt[-1].i == Y_J_OP) || (yypvt[-1].i == Y_JR_OP))
		    r_type_inst (Y_JR_OP, 0, yypvt[-0].i, 0);
		  else if ((yypvt[-1].i == Y_JAL_OP) || (yypvt[-1].i == Y_JALR_OP))
		    r_type_inst (Y_JALR_OP, 31, yypvt[-0].i, 0);
		} break;
case 85:
# line 1167 "parser.y"
{
		  if ((yypvt[-2].i == Y_J_OP) || (yypvt[-2].i == Y_JR_OP))
		    r_type_inst (Y_JR_OP, 0, yypvt[-0].i, 0);
		  else if ((yypvt[-2].i == Y_JAL_OP) || (yypvt[-2].i == Y_JALR_OP))
		    r_type_inst (Y_JALR_OP, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 86:
# line 1176 "parser.y"
{
		  i_type_inst_free ((yypvt[-1].i == Y_BAL_POP ? Y_BGEZAL_OP : Y_BGEZ_OP),
				    0, 0, (imm_expr *)yypvt[-0].p);
		} break;
case 87:
# line 1184 "parser.y"
{
		  r_type_inst (yypvt[-2].i, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 88:
# line 1190 "parser.y"
{
		  r_type_inst (yypvt[-1].i, yypvt[-0].i, 0, 0);
		} break;
case 89:
# line 1196 "parser.y"
{
		  r_type_inst (yypvt[-1].i, 0, yypvt[-0].i, 0);
		} break;
case 90:
# line 1202 "parser.y"
{
		  if (yypvt[-2].i == Y_MFC1_D_POP)
		    {
		      r_type_inst (Y_MFC1_OP, yypvt[-0].i, 0, yypvt[-1].i);
		      r_type_inst (Y_MFC1_OP, yypvt[-0].i + 1, 0, yypvt[-1].i + 1);
		    }
		  else if (yypvt[-2].i == Y_MTC1_D_POP)
		    {
		      r_type_inst (Y_MTC1_OP, yypvt[-0].i, 0, yypvt[-1].i);
		      r_type_inst (Y_MTC1_OP, yypvt[-0].i + 1, 0, yypvt[-1].i + 1);
		    }
		  else
		    r_type_inst (yypvt[-2].i, yypvt[-0].i, 0, yypvt[-1].i);
		} break;
case 91:
# line 1219 "parser.y"
{
		  r_type_inst (yypvt[-2].i, yypvt[-0].i, 0, yypvt[-1].i);
		} break;
case 92:
# line 1225 "parser.y"
{
		  r_type_inst (yypvt[-2].i, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 93:
# line 1231 "parser.y"
{
		  r_type_inst (yypvt[-3].i, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 94:
# line 1237 "parser.y"
{
		  r_type_inst (yypvt[-2].i, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 95:
# line 1243 "parser.y"
{
		  r_type_inst (yypvt[-2].i, yypvt[-1].i, yypvt[-0].i, 0);
		} break;
case 96:
# line 1249 "parser.y"
{
		  r_cond_type_inst (yypvt[-2].i, yypvt[-1].i, yypvt[-0].i);
		} break;
case 276:
# line 1526 "parser.y"
{
		  align_data (yypvt[-0].i);
		} break;
case 277:
# line 1530 "parser.y"
{null_term = 0;} break;
case 278:
# line 1531 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 279:
# line 1536 "parser.y"
{null_term = 1;} break;
case 280:
# line 1537 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 283:
# line 1549 "parser.y"
{store_op = store_byte;} break;
case 284:
# line 1551 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 285:
# line 1558 "parser.y"
{
		  align_data (2);
		  if (lookup_label ((char*)yypvt[-1].p)->addr == 0)
		    record_label ((char*)yypvt[-1].p, current_data_pc (), 1);
		  increment_data_pc (yypvt[-0].i);
		} break;
case 286:
# line 1567 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 287:
# line 1574 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0].i);
		} break;
case 288:
# line 1583 "parser.y"
{
		  user_kernel_data_segment (1);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 289:
# line 1590 "parser.y"
{
		  user_kernel_data_segment (1);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0].i);
		} break;
case 290:
# line 1599 "parser.y"
{
		  store_op = store_double;
		  if (data_dir) set_data_alignment(3);
		} break;
case 291:
# line 1604 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 297:
# line 1622 "parser.y"
{
		  extern_directive ((char*)yypvt[-1].p, yypvt[-0].i);
		} break;
case 298:
# line 1628 "parser.y"
{
		  fatal_error ("File contains an .err directive\n");
		} break;
case 300:
# line 1637 "parser.y"
{
		  store_op = store_float;
		  if (data_dir) set_data_alignment (2);
		} break;
case 301:
# line 1642 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 304:
# line 1654 "parser.y"
{
		  make_label_global ((char*)yypvt[-0].p);
		} break;
case 305:
# line 1660 "parser.y"
{
		  store_op = store_half;
		  if (data_dir) set_data_alignment (1);
		} break;
case 306:
# line 1665 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 307:
# line 1672 "parser.y"
{
		  record_label ((char*)yypvt[-0].p,
				text_dir
				? current_text_pc ()
				: current_data_pc (),
				1);
		} break;
case 308:
# line 1682 "parser.y"
{
		  lcomm_directive ((char*)yypvt[-1].p, yypvt[-0].i);
		} break;
case 314:
# line 1700 "parser.y"
{
		  yyerror ("Warning: repeat directive ignored");
		} break;
case 315:
# line 1706 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 316:
# line 1713 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0].i);
		} break;
case 317:
# line 1722 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 318:
# line 1729 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0].i);
		} break;
case 319:
# line 1738 "parser.y"
{
		  if (streq ((char*)yypvt[-0].p, "noat"))
		    noat_flag = 1;
		  else if (streq ((char*)yypvt[-0].p, "at"))
		    noat_flag = 0;
		} break;
case 320:
# line 1747 "parser.y"
{
		  if (data_dir)
		    increment_data_pc (yypvt[-0].i);
		  else if (text_dir)
		    increment_text_pc (yypvt[-0].i);
		} break;
case 321:
# line 1756 "parser.y"
{
		  yyerror ("Warning: struct directive ignored");
		} break;
case 322:
# line 1762 "parser.y"
{
		  user_kernel_text_segment (0);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		} break;
case 323:
# line 1769 "parser.y"
{
		  user_kernel_text_segment (0);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		  set_text_pc (yypvt[-0].i);
		} break;
case 324:
# line 1778 "parser.y"
{
		  user_kernel_text_segment (1);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		} break;
case 325:
# line 1785 "parser.y"
{
		  user_kernel_text_segment (1);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		  set_text_pc (yypvt[-0].i);
		} break;
case 328:
# line 1799 "parser.y"
{
		  store_op = store_word_data;
		  if (data_dir) set_data_alignment (2);
		} break;
case 330:
# line 1809 "parser.y"
{only_id = 1;} break;
case 331:
# line 1809 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 332:
# line 1812 "parser.y"
{
		  yyval.p = make_addr_expr (0, NULL, yypvt[-1].i);
		} break;
case 333:
# line 1817 "parser.y"
{
		  yyval.p = make_addr_expr (yypvt[-0].i, NULL, 0);
		} break;
case 334:
# line 1822 "parser.y"
{
		  yyval.p = make_addr_expr (yypvt[-3].i, NULL, yypvt[-1].i);
		} break;
case 335:
# line 1827 "parser.y"
{
		  yyval.p = make_addr_expr (0, (char*)yypvt[-0].p, 0);
		  if (yypvt[-0].p) free ((char*)yypvt[-0].p);
		} break;
case 336:
# line 1833 "parser.y"
{
		  yyval.p = make_addr_expr (0, (char*)yypvt[-3].p, yypvt[-1].i);
		  if (yypvt[-3].p) free ((char*)yypvt[-3].p);
		} break;
case 337:
# line 1839 "parser.y"
{
		  yyval.p = make_addr_expr (yypvt[-0].i, (char*)yypvt[-2].p, 0);
		  if (yypvt[-2].p) free ((char*)yypvt[-2].p);
		} break;
case 338:
# line 1845 "parser.y"
{
		  yyval.p = make_addr_expr (yypvt[-2].i, (char*)yypvt[-0].p, 0);
		} break;
case 339:
# line 1850 "parser.y"
{
		  yyval.p = make_addr_expr (- yypvt[-0].i, (char*)yypvt[-2].p, 0);
		  if (yypvt[-2].p) free ((char*)yypvt[-2].p);
		} break;
case 340:
# line 1856 "parser.y"
{
		  yyval.p = make_addr_expr (yypvt[-3].i, (char*)yypvt[-5].p, yypvt[-1].i);
		  if (yypvt[-5].p) free ((char*)yypvt[-5].p);
		} break;
case 341:
# line 1862 "parser.y"
{
		  yyval.p = make_addr_expr (- yypvt[-3].i, (char*)yypvt[-5].p, yypvt[-1].i);
		  if (yypvt[-5].p) free ((char*)yypvt[-5].p);
		} break;
case 342:
# line 1869 "parser.y"
{only_id = 1;} break;
case 343:
# line 1869 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 344:
# line 1872 "parser.y"
{
		  yyval.p = make_imm_expr (yypvt[-0].i, NULL, 0);
		} break;
case 345:
# line 1877 "parser.y"
{
		  yyval.p = make_imm_expr (yypvt[-4].i >> yypvt[-0].i, NULL, 0);
		} break;
case 346:
# line 1882 "parser.y"
{
		  yyval.p = make_imm_expr (0, (char*)yypvt[-0].p, 0);
		} break;
case 347:
# line 1887 "parser.y"
{
		  yyval.p = make_imm_expr (yypvt[-0].i, (char*)yypvt[-2].p, 0);
		  free ((char*)yypvt[-2].p);
		} break;
case 348:
# line 1893 "parser.y"
{
		  yyval.p = make_imm_expr (- yypvt[-0].i, (char*)yypvt[-2].p, 0);
		  free ((char*)yypvt[-2].p);
		} break;
case 350:
# line 1903 "parser.y"
{yyval.i = yypvt[-2].i + yypvt[-0].i;} break;
case 351:
# line 1906 "parser.y"
{
		  /* Y_INT '-' Y_INT */
		  if (yypvt[-0].i >= 0)
		    yyerror ("Syntax error");
		  yyval.i = yypvt[-1].i - yypvt[-0].i;
		} break;
case 358:
# line 1927 "parser.y"
{
		  if (yypvt[-0].i < 0 || yypvt[-0].i > 31)
		    yyerror ("Register number out of range");
		  if (yypvt[-0].i == 1 && !bare_machine && !noat_flag)
		    yyerror ("Register 1 is reserved for assembler");
		  yyval = yypvt[-0];
		} break;
case 362:
# line 1942 "parser.y"
{
		  if (yypvt[-0].i < 0 || yypvt[-0].i > 31)
		    yyerror ("FP register number out of range");
		  yyval = yypvt[-0];
		} break;
case 365:
# line 1957 "parser.y"
{
		  yyval.p = make_imm_expr (- (int)current_text_pc (),
					(char*)yypvt[-0].p,
					1);
		} break;
case 368:
# line 1970 "parser.y"
{
		  store_string ((char*)yypvt[-0].p, y_str_length, null_term);
		  free ((char*)yypvt[-0].p);
		} break;
case 369:
# line 1975 "parser.y"
{
		  int i;

		  for (i = 0; i < yypvt[-0].i; i ++)
		    store_string ((char*)yypvt[-2].p, y_str_length, null_term);
		  free ((char*)yypvt[-2].p);
		} break;
case 370:
# line 1985 "parser.y"
{only_id = 1;} break;
case 371:
# line 1985 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 373:
# line 1990 "parser.y"
{
		  label *l = lookup_label ((char*)yypvt[-0].p);

		  if (l->addr == 0)
		    {
		      record_data_uses_symbol (current_data_pc (), l);
		      yyval.p = NULL;
		    }
		  else
		    yyval.i = l->addr;
		} break;
case 374:
# line 2004 "parser.y"
{
		  store_op (yypvt[-0].p);
		} break;
case 375:
# line 2008 "parser.y"
{
		  store_op (yypvt[-0].p);
		} break;
case 376:
# line 2012 "parser.y"
{
		  int i;

		  for (i = 0; i < yypvt[-0].i; i ++)
		    store_op (yypvt[-2].p);
		} break;
case 377:
# line 2022 "parser.y"
{
		  store_op (yypvt[-0].p);
		} break;
case 378:
# line 2026 "parser.y"
{
		  store_op (yypvt[-0].p);
		} break;
case 379:
# line 2032 "parser.y"
{only_id = 1;} break;
case 380:
# line 2032 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 382:
# line 2035 "parser.y"
{yyval.p = (void*)NULL;} break;
case 383:
# line 2039 "parser.y"
{only_id = 1;} break;
case 384:
# line 2039 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
# line	532 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

